/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ValidateService(value="\u8de8\u5e74\u62a5\u9500\u7684\u68c0\u67e5", ruleType=RuleType.THROW_OR_WARN)
public class CrossYearValidationStrategy
implements InvoiceValidateStrategy {
    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        Integer nowYear;
        String invoiceDate = invoice.getInvoiceDate();
        if (StringUtils.isBlank((CharSequence)invoiceDate)) {
            return;
        }
        int year = DateUtil.parseDate((CharSequence)invoiceDate).year();
        if (year < (nowYear = DateUtil.getNowYear())) {
            if (throwErr) {
                throw new InvoiceValidateException("\u6709\u8de8\u5e74\u62a5\u9500\u7684\u53d1\u7968");
            }
            context.addAnnotation("\u6709\u8de8\u5e74\u62a5\u9500\u7684\u53d1\u7968");
        }
    }
}

