/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.beust.jcommander.internal.Lists;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=2)
@Component
@ValidateService(value="\u68c0\u67e5\u662f\u5426\u4e58\u5750\u7684\u4e00\u7b49\u5ea7", ruleType=RuleType.ALWAYS)
public class FirstClassSeatStrategy
implements InvoiceValidateStrategy {
    private static List<String> TRAIN_SEAT_TYPE = Lists.newArrayList((Object[])new String[]{"\u5546\u52a1\u5ea7", "\u4e00\u7b49\u5ea7", "\u65b0\u7a7a\u8c03\u9ad8\u7ea7\u8f6f\u5367", "\u65b0\u7a7a\u8c03\u8f6f\u5367", "\u52a8\u5367", "\u7279\u7b49\u5ea7"});
    private static final String AIR_SEAT_TYPE = "\u7ecf\u6d4e\u8231";
    private static final List<String> TRAIN = Lists.newArrayList((Object[])new String[]{"train_ticket", "railway_digital_ticket"});
    private static final List<String> AIR = Lists.newArrayList((Object[])new String[]{"flight_itinerary", "flight_digital_ticket"});
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        if (this.isOutOfSeat(invoice, context)) {
            invoice.setNeedManualReview(true);
            context.addAnnotation("\u5ea7\u4f4d\u8d85\u6807");
        }
    }

    private boolean isOutOfSeat(EcsInvoiceInfoVO invoice, AnnotationContext context) throws InvoiceValidateException {
        if (!TRAIN.contains(invoice.getInvoiceOp()) && !AIR.contains(invoice.getInvoiceOp())) {
            return false;
        }
        String invoiceOp = invoice.getInvoiceOp();
        Object companyId = context.getMetaData("companyId");
        EcsConfigEntity outOfSeatType = this.ecsConfigService.getByKeyName("outOfSeatType", companyId.toString());
        if (outOfSeatType != null) {
            TRAIN_SEAT_TYPE = Lists.newArrayList((Object[])outOfSeatType.getKeyValue().split(","));
        }
        if ("train_ticket".equals(invoiceOp) || "railway_digital_ticket".equals(invoiceOp)) {
            return TRAIN_SEAT_TYPE.contains(invoice.getSeatType()) || invoice.getSeatType() != null && invoice.getSeatType().contains("\u8f6f\u5367");
        }
        if ("flight_itinerary".equals(invoiceOp) || "flight_digital_ticket".equals(invoiceOp)) {
            return !AIR_SEAT_TYPE.equals(invoice.getSeatType());
        }
        return false;
    }
}

