/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=2)
@Component
@ValidateService(value="\u5b9a\u989d\u53d1\u7968\u7c7b\u578b\u6821\u9a8c", ruleType=RuleType.ALWAYS)
public class QuotaInvoiceTypeStrategy
implements InvoiceValidateStrategy {
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        Object companyId = context.getMetaData("companyId");
        EcsConfigEntity config = this.ecsConfigService.getByKeyName("quotaInvoiceType", companyId.toString());
        if (StringUtils.isBlank((CharSequence)invoice.getInvoiceOpZh()) || !"\u901a\u7528\u5b9a\u989d\u53d1\u7968".equals(invoice.getInvoiceOpZh())) {
            return;
        }
        if (Objects.nonNull(config)) {
            String name = config.getName();
            String keyValue = config.getKeyValue();
            if (StringUtils.isBlank((CharSequence)keyValue)) {
                throw new InvoiceValidateException("\u8bf7\u4e0a\u4f20" + name + "\u76f8\u5173\u53d1\u7968");
            }
            List rules = null;
            try {
                rules = JsonUtil.getJsonToListMap((String)keyValue);
            }
            catch (Exception e) {
                throw new InvoiceValidateException("\u5b9a\u989d\u53d1\u7968\u7c7b\u578b\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            String invoiceTitle = invoice.getInvoiceTitle() == null ? "----" : invoice.getInvoiceTitle();
            boolean matchAnyRule = false;
            for (Map rule : rules) {
                Object include = rule.get("include");
                Object exclude = rule.get("exclude");
                boolean includeMatch = true;
                if (!Objects.isNull(include) && !StringUtils.isBlank((CharSequence)include.toString())) {
                    String[] includes = include.toString().split(",");
                    includeMatch = false;
                    for (String inc : includes) {
                        if (StringUtils.isBlank((CharSequence)inc) || !invoiceTitle.contains(inc.trim())) continue;
                        includeMatch = true;
                        break;
                    }
                }
                boolean excludeMatch = false;
                if (!Objects.isNull(exclude) && !StringUtils.isBlank((CharSequence)exclude.toString())) {
                    String[] excludes;
                    for (String exc : excludes = exclude.toString().split(",")) {
                        if (StringUtils.isBlank((CharSequence)exc) || !invoiceTitle.contains(exc.trim())) continue;
                        excludeMatch = true;
                        break;
                    }
                }
                if (!includeMatch || excludeMatch) continue;
                matchAnyRule = true;
                break;
            }
            if (!matchAnyRule) {
                throw new InvoiceValidateException("\u8bf7\u4e0a\u4f20" + name + "\u76f8\u5173\u53d1\u7968");
            }
        }
    }
}

