/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsBaseEntity;
import com.bringspring.ecs.entity.EcsInvoiceEntity;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.service.EcsInvoiceService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import com.bringspring.ecs.strategy.validate.enums.ValidateCustomizableType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ValidateService(value="\u62db\u5f85\u8d39\u62a5\u9500\u53d1\u7968\u603b\u91d1\u989d", ruleType=RuleType.CONDITIONAL, customizableType=ValidateCustomizableType.YES)
public class ReceiveAllInvoiceAmountStrategy
implements InvoiceValidateStrategy {
    @Autowired
    private EcsConfigService ecsConfigService;
    @Autowired
    private EcsInvoiceService ecsInvoiceService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        if (!"receive".equals(context.getMetaData("reimbType"))) {
            return;
        }
        Object recordId = context.getMetaData("recordId");
        Object companyId = context.getMetaData("companyId");
        String defaultValue = "2000";
        BigDecimal limitAmount = new BigDecimal(defaultValue).setScale(2, RoundingMode.HALF_UP);
        String invoiceDate = invoice.getInvoiceDate();
        String taxCode = invoice.getSellerTaxCode();
        BigDecimal totalAmount = this.getTotalAmount(invoiceDate, taxCode, recordId.toString());
        totalAmount = totalAmount.add(invoice.getInvoiceAmount());
        String fileType = "\u6c34\u5355";
        if ("2".equals(companyId)) {
            fileType = "\u4ed8\u6b3e\u622a\u56fe";
        }
        if (totalAmount.compareTo(limitAmount) > 0) {
            context.addAnnotation("\u62db\u5f85\u8d39\u91d1\u989d\u8d85\u8fc7" + limitAmount + "\u5143\uff0c\u9700\u4e0a\u4f20" + fileType);
        }
    }

    private BigDecimal getTotalAmount(String invoiceDate, String taxCode, String recordId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{invoiceDate, taxCode})) {
            return BigDecimal.ZERO;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsInvoiceEntity::getInvoiceDate, (Object)invoiceDate)).eq(EcsInvoiceEntity::getSellerTaxCode, (Object)taxCode)).eq(EcsBaseEntity::getDeleteMark, (Object)0)).ne(EcsInvoiceEntity::getRecordId, (Object)recordId);
        queryWrapper.select(new String[]{"sum(invoice_amount) as totalAmount"});
        Map map = this.ecsInvoiceService.getMap((Wrapper)queryWrapper);
        QueryWrapper queryWrapper1 = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper1.lambda().eq(EcsInvoiceEntity::getInvoiceDate, (Object)invoiceDate)).eq(EcsInvoiceEntity::getSellerTaxCode, (Object)taxCode)).eq(EcsInvoiceEntity::getRecordId, (Object)recordId);
        queryWrapper1.select(new String[]{"sum(invoice_amount) as totalAmount"});
        Map map1 = this.ecsInvoiceService.getMap((Wrapper)queryWrapper1);
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (map != null && map.containsKey("totalAmount") && map.get("totalAmount") != null) {
            totalAmount = totalAmount.add(new BigDecimal(map.get("totalAmount").toString()).setScale(2, RoundingMode.HALF_UP));
        }
        if (map1 != null && map1.containsKey("totalAmount") && map1.get("totalAmount") != null) {
            totalAmount = totalAmount.add(new BigDecimal(map1.get("totalAmount").toString()).setScale(2, RoundingMode.HALF_UP));
        }
        return totalAmount;
    }
}

