/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.hrms.archive.HrmsEmployeeArchiveInfoVO;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsExtendService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import com.bringspring.system.permission.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ValidateService(value="\u62a5\u9500\u4eba\u548c\u4e58\u8f66\u4eba\u662f\u5426\u4e00\u81f4", ruleType=RuleType.ALWAYS)
public class ReimbUserValidateStrategy
implements InvoiceValidateStrategy {
    private static final String TRANSPORTATION_INVOICE = "traffic";
    @Autowired
    private UserService userService;
    @Autowired
    private EcsExtendService ecsExtendService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        Object userId = context.getMetaData("userId");
        Object fileType = context.getMetaData("reimbType");
        if (TRANSPORTATION_INVOICE.equals(fileType)) {
            HrmsEmployeeArchiveInfoVO info = this.ecsExtendService.getEmployeeArchiveInfoById(userId.toString());
            if (StringUtils.isNotBlank((CharSequence)invoice.getPassengerName()) && info != null && !info.getName().equals(invoice.getPassengerName())) {
                throw new InvoiceValidateException("\u4e58\u8f66\u4eba\u4e0e\u62a5\u9500\u4eba\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20");
            }
        }
    }
}

