/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.strategy.validate.rules;

import com.bringspring.common.util.StringUtils;
import com.bringspring.ecs.entity.EcsConfigEntity;
import com.bringspring.ecs.exception.InvoiceValidateException;
import com.bringspring.ecs.model.invoice.EcsInvoiceInfoVO;
import com.bringspring.ecs.service.EcsConfigService;
import com.bringspring.ecs.strategy.validate.AnnotationContext;
import com.bringspring.ecs.strategy.validate.InvoiceValidateStrategy;
import com.bringspring.ecs.strategy.validate.annotation.ValidateService;
import com.bringspring.ecs.strategy.validate.enums.RuleType;
import com.bringspring.ecs.strategy.validate.enums.ValidateCustomizableType;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
@ValidateService(value="\u68c0\u67e5\u7533\u62a5\u65f6\u95f4", ruleType=RuleType.THROW_OR_WARN, customizableType=ValidateCustomizableType.YES)
public class ReportTimeStrategy
implements InvoiceValidateStrategy {
    @Autowired
    private EcsConfigService ecsConfigService;

    @Override
    public void validate(EcsInvoiceInfoVO invoice, AnnotationContext context, boolean throwErr) throws InvoiceValidateException {
        LocalDate currentDate;
        LocalDate parse;
        long daysBetween;
        String keyValue;
        String invoiceDateStr = invoice.getInvoiceDate();
        if (StringUtils.isBlank((CharSequence)invoiceDateStr)) {
            return;
        }
        Object companyId = context.getMetaData("companyId");
        String defaultValue = "45";
        long limitDays = Long.parseLong(defaultValue);
        EcsConfigEntity reportTimeDaysConfig = this.ecsConfigService.getByKeyName("reportTimeDays", companyId.toString());
        if (reportTimeDaysConfig != null && StringUtils.isNotBlank((CharSequence)(keyValue = reportTimeDaysConfig.getKeyValue()))) {
            try {
                limitDays = this.parseLimitDays(keyValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((daysBetween = ChronoUnit.DAYS.between(parse = LocalDate.parse(invoiceDateStr), currentDate = LocalDate.now())) > limitDays) {
            if (throwErr) {
                throw new InvoiceValidateException("\u60a8\u7684\u53d1\u7968\u5df2\u8d85\u671f" + limitDays + "\u5929\u4ee5\u4e0a");
            }
            context.addAnnotation("\u60a8\u7684\u53d1\u7968\u5df2\u8d85\u671f" + limitDays + "\u5929\u4ee5\u4e0a");
        }
    }

    private long parseLimitDays(String keyValue) {
        if (StringUtils.isBlank((CharSequence)keyValue)) {
            return 45L;
        }
        Pattern dayPattern = Pattern.compile("^(\\d+)d$", 2);
        Matcher dayMatcher = dayPattern.matcher(keyValue.trim());
        if (dayMatcher.matches()) {
            return Long.parseLong(dayMatcher.group(1));
        }
        Pattern monthPattern = Pattern.compile("^(\\d+)m$", 2);
        Matcher monthMatcher = monthPattern.matcher(keyValue.trim());
        if (monthMatcher.matches()) {
            int months = Integer.parseInt(monthMatcher.group(1));
            LocalDate currentDate = LocalDate.now();
            LocalDate monthsAgo = currentDate.minusMonths(months);
            return ChronoUnit.DAYS.between(monthsAgo, currentDate);
        }
        return Long.parseLong(keyValue.trim());
    }
}

