/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.task;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.ecs.entity.EcsAdvancePaymentEntity;
import com.bringspring.ecs.entity.EcsBaseEntity;
import com.bringspring.ecs.entity.EcsCompanyEntity;
import com.bringspring.ecs.entity.EcsRecordsEntity;
import com.bringspring.ecs.enums.DeleteMarkEnum;
import com.bringspring.ecs.enums.RecordAuditEnum;
import com.bringspring.ecs.enums.RecordNeedReceiveInvoiceEnum;
import com.bringspring.ecs.service.EcsAdvancePaymentService;
import com.bringspring.ecs.service.EcsCompanyService;
import com.bringspring.ecs.service.EcsMessageService;
import com.bringspring.ecs.service.EcsRecordsService;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.UserRelationService;
import com.google.common.collect.Lists;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EcsRecordsTask {
    private static final Logger log = LoggerFactory.getLogger(EcsRecordsTask.class);
    @Autowired
    private EcsRecordsService ecsRecordsService;
    @Autowired
    private EcsCompanyService ecsCompanyService;
    @Autowired
    private EcsMessageService ecsMessageService;
    @Autowired
    private EcsAdvancePaymentService ecsAdvancePaymentService;
    @Autowired
    private UserRelationService userRelationService;

    @JsbosTask(fullName="\u5b9a\u65f6\u67e5\u8be2\u672a\u6536\u7968\u5355\u636e", description="\u5b9a\u65f6\u67e5\u8be2\u672a\u6536\u7968\u5355\u636e")
    public void checkNotReceiveInvoiceList() {
        LocalDate today = LocalDate.now();
        if (today.getDayOfWeek() != DayOfWeek.TUESDAY) {
            return;
        }
        LocalDate lastFriday = today.with(TemporalAdjusters.previous(DayOfWeek.FRIDAY));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(EcsBaseEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark())).eq(EcsRecordsEntity::getNeedReceiveInvoice, (Object)RecordNeedReceiveInvoiceEnum.NEED_RECEIVE_INVOICE.getCode())).le(EcsRecordsEntity::getGeneratePdfTime, (Object)lastFriday)).le(EcsRecordsEntity::getSubmitTime, (Object)lastFriday)).ge(EcsRecordsEntity::getAuditStatus, (Object)RecordAuditEnum.AUDITING.getCode());
        List list = this.ecsRecordsService.list((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            for (EcsRecordsEntity recordsEntity : list) {
                String userId = recordsEntity.getUserId();
                this.ecsMessageService.sendReceiveInvoiceMessage(Lists.newArrayList((Object[])new String[]{userId}), () -> "\u60a8\u7684\u62a5\u9500\u5355\u636e: " + recordsEntity.getOrderNumber() + "\u5c1a\u672a\u6536\u7968\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u90ae\u5bc4", () -> "\u60a8\u7684\u62a5\u9500\u5355\u636e: " + recordsEntity.getOrderNumber() + "\u5c1a\u672a\u6536\u7968\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u90ae\u5bc4");
            }
        }
    }

    @JsbosTask(fullName="\u501f\u6b3e\u672a\u8fd8\u50ac\u7f34\u63d0\u9192", description="\u5b9a\u65f6\u67e5\u8be2\u672a\u6536\u7968\u5355\u636e")
    public void loanNotFinish() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().select(new SFunction[]{EcsAdvancePaymentEntity::getId, EcsAdvancePaymentEntity::getUserId, EcsAdvancePaymentEntity::getReimbCompany}).eq(EcsBaseEntity::getDeleteMark, (Object)com.bringspring.common.base.DeleteMarkEnum.NOT_DELETE.getCode())).eq(EcsAdvancePaymentEntity::getAuditStatus, (Object)RecordAuditEnum.PAID.getCode())).apply("total_advance_amount > repayment_amount + repaying_amount", new Object[0])).apply("DATEDIFF(advance_predict_time, NOW()) = 3", new Object[0])).orderByDesc(EcsAdvancePaymentEntity::getAdvancePredictTime);
        List list = this.ecsAdvancePaymentService.list((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            List list1 = this.ecsCompanyService.list();
            Map<String, EcsCompanyEntity> collect = list1.stream().collect(Collectors.toMap(EcsCompanyEntity::getId, v -> v));
            for (EcsAdvancePaymentEntity advancePaymentEntity : list) {
                EcsCompanyEntity ecsCompanyEntity = collect.get(advancePaymentEntity.getReimbCompany());
                String cashierRole = ecsCompanyEntity.getCashierRole();
                List<String> collect1 = new ArrayList<String>();
                if (StringUtils.isNotBlank((CharSequence)cashierRole)) {
                    List data = this.userRelationService.getListByObjectId(cashierRole);
                    collect1 = data.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                }
                String userId = advancePaymentEntity.getUserId();
                collect1.add(userId);
                this.ecsMessageService.sendLoanMessage(collect1, () -> "\u60a8\u7684\u501f\u6b3e\u5355: " + advancePaymentEntity.getOrderNumber() + "\u5c06\u4e8e3\u5929\u540e\u5230\u671f\uff0c\u8bf7\u53ca\u65f6\u8fd8\u6b3e", () -> "\u60a8\u7684\u501f\u6b3e\u5355: " + advancePaymentEntity.getOrderNumber() + "\u5c06\u4e8e3\u5929\u540e\u5230\u671f\uff0c\u8bf7\u53ca\u65f6\u8fd8\u6b3e");
            }
        }
    }
}

