/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.utils;

import com.aliyun.apache.hc.client5.http.utils.Base64;
import com.bringspring.common.util.XSSEscape;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Base64ToFileUtil {
    public static List<File> decodeAndUnzip(String base64String, String outputDir) throws IOException {
        byte[] zipBytes = Base64.decodeBase64((String)base64String);
        File tempZipFile = File.createTempFile("temp", ".zip");
        try (FileOutputStream fos = new FileOutputStream(tempZipFile);){
            fos.write(zipBytes);
        }
        List<File> extractedFiles = Base64ToFileUtil.unzip(tempZipFile.getAbsolutePath(), outputDir);
        return extractedFiles;
    }

    private static List<File> unzip(String zipFilePath, String destDir) throws IOException {
        byte[] buffer = new byte[1024];
        ArrayList<File> extractedFiles = new ArrayList<File>();
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(Paths.get(zipFilePath, new String[0]), new OpenOption[0]));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                File newFile = new File(XSSEscape.escapePath((String)(destDir + zipEntry.getName())));
                new File(newFile.getParent()).mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    extractedFiles.add(newFile);
                }
                zis.closeEntry();
            }
        }
        return extractedFiles;
    }
}

