/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.utils;

import cn.hutool.core.util.StrUtil;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EcsMessageUtils {
    private static final Logger log = LoggerFactory.getLogger(EcsMessageUtils.class);
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    public void sendMessageNew(String taskCode, String sendCode, Map<String, String> keys, String linkUrl, String appUrl, String pcUrl, String userId, String termType, String typeDesc, Map<String, String> otherKey) {
        log.info("code:{},\u63a5\u6536\u4eba:{}", (Object)sendCode, (Object)userId);
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode(taskCode);
        taskMsg.setSendCode(sendCode);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setKeys(keys);
        if (StrUtil.isEmpty((CharSequence)linkUrl)) {
            try {
                linkUrl = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
            }
            catch (BaseException e) {
                log.error("\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u5f02\u5e38:" + e.getMessage());
            }
        }
        linkMsgKeys.setLinkUrl(linkUrl);
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(termType);
        customKeysLink.setTermTypeDesc(typeDesc);
        customKeysLink.setPcUrl(pcUrl);
        customKeysLink.setAppUrl(appUrl);
        customKeysLink.setOtherKey(otherKey);
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        taskMsg.setToUserIds(userId);
        try {
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

