/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class OcrDateUtil {
    private static final List<DateTimeFormatter> DEFAULT_FORMATTERS = OcrDateUtil.buildDefaultFormatters();
    private static final Pattern YEAR_PATTERN = Pattern.compile("\\d{1,4}");
    private static List<DateTimeFormatter> formatters;
    private static ErrorHandlingStrategy errorHandlingStrategy;

    public OcrDateUtil() {
        formatters = DEFAULT_FORMATTERS;
        errorHandlingStrategy = ErrorHandlingStrategy.RETURN_NULL;
    }

    private static List<DateTimeFormatter> buildDefaultFormatters() {
        ArrayList<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        formatters.add(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        formatters.add(DateTimeFormatter.ofPattern("yyyyMMdd"));
        formatters.add(DateTimeFormatter.ofPattern("MM/dd/yyyy"));
        formatters.add(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy-M-d"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy/M/d"));
        formatters.add(DateTimeFormatter.ofPattern("M/d/yyyy"));
        formatters.add(DateTimeFormatter.ofPattern("d/M/yyyy"));
        formatters.add(DateTimeFormatter.ofPattern("MMM dd, yyyy", Locale.ENGLISH));
        formatters.add(DateTimeFormatter.ofPattern("dd MMM yyyy", Locale.ENGLISH));
        builder = new DateTimeFormatterBuilder().appendPattern("MM/dd").parseDefaulting(ChronoField.YEAR, LocalDate.now().getYear());
        formatters.add(builder.toFormatter());
        builder = new DateTimeFormatterBuilder().appendPattern("M/d").parseDefaulting(ChronoField.YEAR, LocalDate.now().getYear());
        formatters.add(builder.toFormatter());
        builder = new DateTimeFormatterBuilder().appendPattern("yyyy").parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L);
        formatters.add(builder.toFormatter());
        return formatters;
    }

    public static LocalDate parseDate(String ocrText) {
        ocrText = OcrDateUtil.cleanUpOcrText(ocrText);
        for (DateTimeFormatter formatter : formatters) {
            try {
                LocalDate date = LocalDate.parse(ocrText, formatter.withResolverStyle(ResolverStyle.STRICT));
                return OcrDateUtil.adjustYear(date);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return OcrDateUtil.attemptLenientParsingAndYearCorrection(ocrText);
    }

    private static String cleanUpOcrText(String ocrText) {
        ocrText = ocrText.replaceAll("[^\\p{IsDigit}\\p{IsLetter}\u5e74\u6708\u65e5\\-/]", "");
        return ocrText;
    }

    private static LocalDate adjustYear(LocalDate date) {
        LocalDate now = LocalDate.now();
        if (date.getYear() < 100) {
            int twoDigitYear;
            int currentCentury = now.getYear() / 100 * 100;
            if ((date = date.withYear(currentCentury + (twoDigitYear = date.getYear()))).isAfter(now)) {
                date = date.minusYears(100L);
            }
            if (date.isAfter(now)) {
                date = date.minusYears(1L);
            }
        } else if (date.getYear() < now.getYear() - 1) {
            date = date.getMonthValue() > now.getMonthValue() || date.getMonthValue() == now.getMonthValue() && date.getDayOfMonth() > now.getDayOfMonth() ? date.withYear(now.getYear() - 1) : date.withYear(now.getYear());
        }
        return date;
    }

    private static LocalDate attemptLenientParsingAndYearCorrection(String ocrText) {
        String yearStr;
        for (DateTimeFormatter formatter : formatters) {
            try {
                LocalDate date = LocalDate.parse(ocrText, formatter.withResolverStyle(ResolverStyle.LENIENT));
                return OcrDateUtil.adjustYear(date);
            }
            catch (DateTimeParseException date) {
            }
        }
        Matcher yearMatcher = YEAR_PATTERN.matcher(ocrText);
        if (yearMatcher.find() && (yearStr = yearMatcher.group()).length() < 4) {
            int correctedYear = OcrDateUtil.correctYear(Integer.parseInt(yearStr));
            String correctedOcrText = ocrText.replace(yearStr, String.valueOf(correctedYear));
            return OcrDateUtil.parseDate(correctedOcrText);
        }
        switch (errorHandlingStrategy) {
            case THROW_EXCEPTION: {
                throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u65e5\u671f: " + ocrText);
            }
            case RETURN_NULL: {
                return null;
            }
            case ATTEMPT_GUESS: {
                return OcrDateUtil.attemptGuess(ocrText);
            }
        }
        return null;
    }

    private static int correctYear(int year) {
        int twoDigitYear;
        LocalDate now = LocalDate.now();
        int currentCentury = now.getYear() / 100 * 100;
        int correctedYear = currentCentury + (twoDigitYear = year % 100);
        if (correctedYear > now.getYear()) {
            correctedYear -= 100;
        }
        if (correctedYear > now.getYear()) {
            correctedYear = now.getYear() - 1;
        }
        return correctedYear;
    }

    private static LocalDate attemptGuess(String ocrText) {
        return null;
    }

    public static enum ErrorHandlingStrategy {
        THROW_EXCEPTION,
        RETURN_NULL,
        ATTEMPT_GUESS;

    }
}

