/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.utils;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.Matrix;

public class PdfDrawUtils {
    public static final float POINTS_PER_INCH = 72.0f;
    public static final float POINTS_PER_MM = 2.8346457f;

    public static float getPointsMm(float mm) {
        return mm * 2.8346457f;
    }

    public static void drawText(PDPageContentStream contentStream, float x, float y, String text, Color color, PDFont font, float fontSize) throws IOException {
        contentStream.setNonStrokingColor(color);
        contentStream.beginText();
        contentStream.setFont(font, fontSize);
        contentStream.newLineAtOffset(x, y);
        contentStream.showText(text);
        contentStream.endText();
    }

    public static void drawRectangle(PDPageContentStream contentStream, float x, float y, float width, float height, Color color) throws IOException {
        contentStream.setStrokingColor(color);
        contentStream.addRect(x, y, width, height);
        contentStream.stroke();
    }

    public static void drawFilledRectangle(PDPageContentStream contentStream, float x, float y, float width, float height, Color color) throws IOException {
        contentStream.setNonStrokingColor(color);
        contentStream.addRect(x, y, width, height);
        contentStream.fill();
    }

    public static void drawDashedLine(PDPageContentStream contentStream, float yPosition, float xStart, float xEnd, Color color) throws IOException {
        contentStream.setStrokingColor(color);
        contentStream.setLineDashPattern(new float[]{5.0f, 3.0f}, 0.0f);
        contentStream.moveTo(xStart, yPosition);
        contentStream.lineTo(xEnd, yPosition);
        contentStream.stroke();
        contentStream.setLineDashPattern(new float[0], 0.0f);
        contentStream.setStrokingColor(Color.BLACK);
    }

    public static void drawXMark(PDPageContentStream contentStream, float startX, float startY, float width, float height, Color color) throws IOException {
        contentStream.setStrokingColor(color);
        contentStream.setLineWidth(1.0f);
        contentStream.moveTo(startX, startY);
        contentStream.lineTo(startX + width, startY - height);
        contentStream.moveTo(startX + width, startY);
        contentStream.lineTo(startX, startY - height);
        contentStream.stroke();
    }

    public static void drawArrow(PDPageContentStream contentStream, float startX, float startY, float length, ArrowDirection direction, float arrowSize) throws Exception {
        float endY;
        float endX;
        switch (direction) {
            case UP: {
                endX = startX;
                endY = startY + length;
                break;
            }
            case DOWN: {
                endX = startX;
                endY = startY - length;
                break;
            }
            case LEFT: {
                endX = startX - length;
                endY = startY;
                break;
            }
            case RIGHT: {
                endX = startX + length;
                endY = startY;
                break;
            }
            default: {
                throw new IllegalArgumentException("\u65b9\u5411\u9519\u8bef");
            }
        }
        contentStream.moveTo(startX, startY);
        contentStream.lineTo(endX, endY);
        contentStream.stroke();
        float wing1X = endX;
        float wing1Y = endY;
        float wing2X = endX;
        float wing2Y = endY;
        switch (direction) {
            case UP: {
                wing1X = endX - arrowSize;
                wing1Y = endY - arrowSize;
                wing2X = endX + arrowSize;
                wing2Y = endY - arrowSize;
                break;
            }
            case DOWN: {
                wing1X = endX - arrowSize;
                wing1Y = endY + arrowSize;
                wing2X = endX + arrowSize;
                wing2Y = endY + arrowSize;
                break;
            }
            case LEFT: {
                wing1X = endX + arrowSize;
                wing1Y = endY - arrowSize;
                wing2X = endX + arrowSize;
                wing2Y = endY + arrowSize;
                break;
            }
            case RIGHT: {
                wing1X = endX - arrowSize;
                wing1Y = endY - arrowSize;
                wing2X = endX - arrowSize;
                wing2Y = endY + arrowSize;
                break;
            }
        }
        contentStream.moveTo(endX, endY);
        contentStream.lineTo(wing1X, wing1Y);
        contentStream.stroke();
        contentStream.moveTo(endX, endY);
        contentStream.lineTo(wing2X, wing2Y);
        contentStream.stroke();
    }

    public static void drawArrowByRotate(PDPageContentStream contentStream, float startX, float startY, float length, ArrowDirection direction, float arrowSize) throws Exception {
        contentStream.saveGraphicsState();
        contentStream.transform(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, startX, startY));
        switch (direction) {
            case UP: {
                break;
            }
            case DOWN: {
                contentStream.transform(new Matrix(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f));
                break;
            }
            case LEFT: {
                contentStream.transform(new Matrix(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f));
                break;
            }
            case RIGHT: {
                contentStream.transform(new Matrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
                break;
            }
            default: {
                throw new IllegalArgumentException("\u65b9\u5411\u9519\u8bef");
            }
        }
        contentStream.moveTo(0.0f, 0.0f);
        contentStream.lineTo(0.0f, length);
        contentStream.stroke();
        contentStream.moveTo(0.0f, length);
        contentStream.lineTo(-arrowSize, length - arrowSize);
        contentStream.stroke();
        contentStream.moveTo(0.0f, length);
        contentStream.lineTo(arrowSize, length - arrowSize);
        contentStream.stroke();
        contentStream.restoreGraphicsState();
    }

    public static void addCircle(PDPageContentStream contentStream, float x, float y, float radius) throws IOException {
        contentStream.moveTo(x + radius, y);
        contentStream.curveTo(x + radius, y + radius, x, y + radius, x - radius, y);
        contentStream.curveTo(x - radius, y - radius, x, y - radius, x + radius, y);
    }

    public static void drawCellText(PDPageContentStream contentStream, String text, float x, float y, float width, float height, PDFont font) throws IOException {
        String[] lines;
        float fontSize = 10.0f;
        float leading = 1.2f * fontSize;
        float textX = x + 2.0f;
        float textY = y - 15.0f;
        contentStream.beginText();
        contentStream.setFont(font, fontSize);
        contentStream.newLineAtOffset(textX, textY);
        for (String line : lines = text.split("\n")) {
            contentStream.showText(line);
            contentStream.newLineAtOffset(0.0f, -leading);
        }
        contentStream.endText();
    }

    private static void centerText(PDPageContentStream contentStream, String text, float x, float y, float width, float height, PDFont font, float fontSize, boolean centerVertically, boolean centerHorizontally) throws IOException {
        float stringWidth = font.getStringWidth(text) / 1000.0f * fontSize;
        float stringHeight = font.getStringWidth("\u4e2d") / 1000.0f * fontSize;
        float textX = x;
        float textY = y;
        if (centerHorizontally) {
            textX = x + (width - stringWidth) / 2.0f;
        }
        if (centerVertically) {
            textY = y + (height - stringHeight) / 2.0f;
        }
        contentStream.beginText();
        contentStream.setFont(font, fontSize);
        contentStream.newLineAtOffset(textX, textY);
        contentStream.showText(text);
        contentStream.endText();
    }

    public static void centerText(PDPageContentStream contentStream, String text, float x, float y, float width, float height, PDFont font, float fontSize) throws IOException {
        PdfDrawUtils.centerText(contentStream, text, x, y, width, height, font, fontSize, true, true);
    }

    public static void rowCenterText(PDPageContentStream contentStream, String text, float x, float y, float width, float height, PDFont font, float fontSize) throws IOException {
        PdfDrawUtils.centerText(contentStream, text, x, y, width, height, font, fontSize, false, true);
    }

    public static void colCenterText(PDPageContentStream contentStream, String text, float x, float y, float width, float height, PDFont font, float fontSize) throws IOException {
        PdfDrawUtils.centerText(contentStream, text, x, y, width, height, font, fontSize, true, false);
    }

    public static void rightAlignText(PDPageContentStream contentStream, String text, float x, float y, float width, float height, PDFont font, float fontSize, boolean centerVertically) throws IOException {
        float stringWidth = font.getStringWidth(text) / 1000.0f * fontSize;
        float textX = x + (width - stringWidth - PdfDrawUtils.getPointsMm(3.0f));
        float textY = y;
        if (centerVertically) {
            textY = y + (height - fontSize) / 2.0f;
        }
        contentStream.beginText();
        contentStream.setFont(font, fontSize);
        contentStream.newLineAtOffset(textX, textY);
        contentStream.showText(text);
        contentStream.endText();
    }

    public static void drawWrapCellText(PDPageContentStream contentStream, String text, float x, float y, float width, float height, PDFont regularFont, float fontSize) throws IOException {
        float leading = 1.2f * fontSize;
        float textX = x + 2.0f;
        float textY = y + height - leading;
        List<String> lines = PdfDrawUtils.wrapText(text, regularFont, fontSize, width - 4.0f);
        if (lines.size() == 1) {
            PdfDrawUtils.colCenterText(contentStream, text, textX, y, width, height, regularFont, fontSize);
        } else {
            contentStream.beginText();
            contentStream.setFont(regularFont, fontSize);
            contentStream.newLineAtOffset(textX, textY);
            for (String line : lines) {
                if (textY - leading < y - height) break;
                contentStream.showText(line);
                contentStream.newLineAtOffset(0.0f, -leading);
                textY -= leading;
            }
            contentStream.endText();
        }
    }

    public static List<String> wrapText(String text, PDFont font, float fontSize, float maxWidth) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        float textWidth = font.getStringWidth(text) / 1000.0f * fontSize;
        double lineNumber = Math.ceil(textWidth / (maxWidth - 4.0f));
        if (lineNumber > 1.0) {
            int start = 0;
            int end = 0;
            int i = 0;
            while ((double)i < lineNumber) {
                end = (int)((maxWidth - 4.0f) / textWidth * (float)text.length() + (float)start);
                end = Math.min(end, text.length());
                lines.add(text.substring(start, end));
                start = end;
                ++i;
            }
            return lines;
        }
        lines.add(text);
        return lines;
    }

    public static enum ArrowDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

