/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.utils;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;

public class TransformImageUtil {
    public static BufferedImage correctImageOrientation(File imageFile) throws Exception {
        if (imageFile == null) {
            return null;
        }
        BufferedImage image = ImageIO.read(imageFile);
        Metadata metadata = ImageMetadataReader.readMetadata((File)imageFile);
        Directory directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        if (directory == null || !directory.containsTag(274)) {
            return image;
        }
        int orientation = directory.getInt(274);
        return TransformImageUtil.transformImage(image, orientation);
    }

    private static BufferedImage transformImage(BufferedImage image, int orientation) {
        int width = image.getWidth();
        int height = image.getHeight();
        switch (orientation) {
            case 1: {
                return image;
            }
            case 2: {
                BufferedImage transformedImage = new BufferedImage(width, height, image.getType());
                Graphics2D g2d = transformedImage.createGraphics();
                g2d.drawImage(image, width, 0, -width, height, null);
                g2d.dispose();
                return transformedImage;
            }
            case 3: {
                return TransformImageUtil.rotateImage(image, 180);
            }
            case 4: {
                BufferedImage transformedImage = new BufferedImage(width, height, image.getType());
                Graphics2D g2d = transformedImage.createGraphics();
                g2d.drawImage(image, 0, height, width, -height, null);
                g2d.dispose();
                return transformedImage;
            }
            case 5: {
                BufferedImage transformedImage = TransformImageUtil.rotateImage(image, 90);
                return TransformImageUtil.flipImageHorizontally(transformedImage);
            }
            case 6: {
                return TransformImageUtil.rotateImage(image, 90);
            }
            case 7: {
                BufferedImage transformedImage = TransformImageUtil.rotateImage(image, 270);
                return TransformImageUtil.flipImageHorizontally(transformedImage);
            }
            case 8: {
                return TransformImageUtil.rotateImage(image, 270);
            }
        }
        return image;
    }

    private static BufferedImage rotateImage(BufferedImage image, int angle) {
        int width = image.getWidth();
        int height = image.getHeight();
        double radians = Math.toRadians(angle);
        int newWidth = (int)Math.abs((double)width * Math.cos(radians) + (double)height * Math.sin(radians));
        int newHeight = (int)Math.abs((double)width * Math.sin(radians) + (double)height * Math.cos(radians));
        BufferedImage rotatedImage = new BufferedImage(newWidth, newHeight, image.getType());
        Graphics2D g2d = rotatedImage.createGraphics();
        g2d.setComposite(AlphaComposite.Src);
        g2d.setColor(new Color(255, 255, 255, 0));
        g2d.fillRect(0, 0, newWidth, newHeight);
        g2d.translate((double)newWidth / 2.0, (double)newHeight / 2.0);
        g2d.rotate(radians);
        g2d.translate((double)(-width) / 2.0, (double)(-height) / 2.0);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return rotatedImage;
    }

    private static BufferedImage flipImageHorizontally(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage flippedImage = new BufferedImage(width, height, image.getType());
        Graphics2D g2d = flippedImage.createGraphics();
        g2d.drawImage(image, width, 0, -width, height, null);
        g2d.dispose();
        return flippedImage;
    }

    public static BufferedImage processImage(BufferedImage originalImage) {
        BufferedImage rgbImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 1);
        Graphics2D g2d = rgbImage.createGraphics();
        g2d.drawImage((Image)originalImage, 0, 0, null);
        g2d.dispose();
        int width = rgbImage.getWidth();
        int height = rgbImage.getHeight();
        int minBrightness = 255;
        int maxBrightness = 0;
        long totalBrightness = 0L;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = new Color(rgbImage.getRGB(x, y));
                int brightness = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
                minBrightness = Math.min(minBrightness, brightness);
                maxBrightness = Math.max(maxBrightness, brightness);
                totalBrightness += (long)brightness;
            }
        }
        int averageBrightness = (int)(totalBrightness / (long)(width * height));
        int targetBrightness = 180;
        int brightnessOffset = Math.max(0, targetBrightness - averageBrightness);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = new Color(rgbImage.getRGB(x, y));
                int red = TransformImageUtil.adjustContrast(color.getRed(), minBrightness, maxBrightness);
                int green = TransformImageUtil.adjustContrast(color.getGreen(), minBrightness, maxBrightness);
                int blue = TransformImageUtil.adjustContrast(color.getBlue(), minBrightness, maxBrightness);
                double gamma = 1.2;
                red = TransformImageUtil.gammaCorrection(red, gamma);
                green = TransformImageUtil.gammaCorrection(green, gamma);
                blue = TransformImageUtil.gammaCorrection(blue, gamma);
                red = Math.min(255, red + brightnessOffset);
                green = Math.min(255, green + brightnessOffset);
                blue = Math.min(255, blue + brightnessOffset);
                rgbImage.setRGB(x, y, new Color(red, green, blue).getRGB());
            }
        }
        originalImage.flush();
        return rgbImage;
    }

    private static int adjustContrast(int color, int min, int max) {
        if (max == min) {
            return color;
        }
        return Math.min(255, Math.max(0, (color - min) * 255 / (max - min)));
    }

    private static int gammaCorrection(int color, double gamma) {
        return (int)(255.0 * Math.pow((double)color / 255.0, 1.0 / gamma));
    }

    public static BufferedImage processImage2(BufferedImage originalImage) {
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage rgbImage = new BufferedImage(width, height, 1);
        Graphics2D g2d = rgbImage.createGraphics();
        g2d.drawImage((Image)originalImage, 0, 0, null);
        g2d.dispose();
        int[] brightnessStats = TransformImageUtil.calculateBrightnessStats(rgbImage);
        int minBrightness = brightnessStats[0];
        int maxBrightness = brightnessStats[1];
        int averageBrightness = brightnessStats[2];
        int targetBrightness = Math.max(180, averageBrightness + 20);
        int brightnessOffset = Math.max(0, targetBrightness - averageBrightness);
        int[] contrastLUT = TransformImageUtil.createContrastLUT(minBrightness, maxBrightness);
        int[] gammaLUT = TransformImageUtil.createGammaLUT(1.2);
        IntStream.range(0, height).parallel().forEach(y -> {
            for (int x = 0; x < width; ++x) {
                int rgb = rgbImage.getRGB(x, y);
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                red = gammaLUT[contrastLUT[red]];
                green = gammaLUT[contrastLUT[green]];
                blue = gammaLUT[contrastLUT[blue]];
                red = Math.min(255, red + brightnessOffset);
                green = Math.min(255, green + brightnessOffset);
                blue = Math.min(255, blue + brightnessOffset);
                rgbImage.setRGB(x, y, red << 16 | green << 8 | blue);
            }
        });
        originalImage.flush();
        return rgbImage;
    }

    private static int[] calculateBrightnessStats(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] brightnessStats = new int[3];
        brightnessStats[0] = 255;
        brightnessStats[1] = 0;
        long totalBrightness = IntStream.range(0, height).parallel().mapToLong(y -> {
            long rowBrightness = 0L;
            int x = 0;
            while (x < width) {
                int rgb = image.getRGB(x, y);
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                int brightness = (red + green + blue) / 3;
                int[] nArray = brightnessStats;
                // MONITORENTER : brightnessStats
                brightnessStats[0] = Math.min(brightnessStats[0], brightness);
                brightnessStats[1] = Math.max(brightnessStats[1], brightness);
                // MONITOREXIT : nArray
                rowBrightness += (long)brightness;
                ++x;
            }
            return rowBrightness;
        }).sum();
        brightnessStats[2] = (int)(totalBrightness / (long)(width * height));
        return brightnessStats;
    }

    private static int[] createContrastLUT(int minBrightness, int maxBrightness) {
        int[] lut = new int[256];
        for (int i = 0; i < 256; ++i) {
            lut[i] = (i - minBrightness) * 255 / Math.max(1, maxBrightness - minBrightness);
            lut[i] = Math.min(255, Math.max(0, lut[i]));
        }
        return lut;
    }

    private static int[] createGammaLUT(double gamma) {
        int[] lut = new int[256];
        for (int i = 0; i < 256; ++i) {
            lut[i] = (int)Math.min(255.0, Math.pow((double)i / 255.0, gamma) * 255.0);
        }
        return lut;
    }

    public static BufferedImage processImage1(BufferedImage originalImage) {
        BufferedImage rgbImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 1);
        Graphics2D g2d = rgbImage.createGraphics();
        g2d.drawImage((Image)originalImage, 0, 0, null);
        g2d.dispose();
        for (int y = 0; y < rgbImage.getHeight(); ++y) {
            for (int x = 0; x < rgbImage.getWidth(); ++x) {
                Color color = new Color(rgbImage.getRGB(x, y));
                int red = Math.min(color.getRed() + 50, 255);
                int green = Math.min(color.getGreen() + 50, 255);
                int blue = Math.min(color.getBlue() + 50, 255);
                rgbImage.setRGB(x, y, new Color(red, green, blue).getRGB());
            }
        }
        originalImage.flush();
        return rgbImage;
    }
}

