/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecs.utils;

import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConverter {
    private static final Logger log = LoggerFactory.getLogger(XmlConverter.class);

    public static <T> String convertToXml(T object) {
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"GB2312");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "GB2312");
            marshaller.marshal(object, (Writer)writer);
            writer.flush();
            return byteArrayOutputStream.toString("GB2312");
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362xml\u5931\u8d25,{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static <T> String convertToGBKXml(T object) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"GBK");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("<?xml version=\"1.0\" encoding=\"GBK\"?>".getBytes("GBK"));
            marshaller.marshal(object, (Result)new StreamResult(baos));
            return baos.toString("GBK");
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362xml\u5931\u8d25,{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static <T> T convertXmlToJava(String xml, Class<T> clazz) {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(xml);
            return (T)unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            log.error("xml\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25,{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static <T, U> U convert(T source, Class<U> targetClass) {
        String jsonString = JSON.toJSONString(source);
        return (U)JSON.parseObject((String)jsonString, targetClass);
    }

    public static JSONObject convertXmlToJson(String xml) {
        return XML.toJSONObject((String)xml);
    }

    public static void main(String[] args) {
        String xml = "<?xml version=\"1.0\" encoding=\"GBK\"?>\n<stream>\n<action>SKBALQRY</action>\n<userName>rkkjzl</userName>\n<list name=\"userDataList\">\n<row>\n<accountNo>8111101013101613790</accountNo>\n</row>\n</list>\n</stream>";
        XmlConverter.sendRequest(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendRequest(String xmlParam) {
        String responseXml;
        block57: {
            responseXml = "";
            String realURL = "http://39.99.147.197:6789";
            HttpURLConnection con = null;
            int responseCode = -1;
            try {
                con = (HttpURLConnection)new URL(realURL).openConnection();
                con.setDoOutput(true);
                con.setDoInput(true);
                con.setAllowUserInteraction(false);
                con.setUseCaches(false);
                con.setRequestProperty("Content-type", "text/xml");
                con.setRequestMethod("POST");
                try (DataOutputStream dos = new DataOutputStream(con.getOutputStream());){
                    dos.write(xmlParam.getBytes("GBK"));
                    dos.flush();
                }
                responseCode = con.getResponseCode();
                if (responseCode == 200) {
                    var6_7 = null;
                    try (InputStream in = con.getInputStream();
                         InputStreamReader isr = new InputStreamReader(in, "GBK");
                         BufferedReader br = new BufferedReader(isr);){
                        String line;
                        StringBuilder rexml = new StringBuilder();
                        while ((line = br.readLine()) != null) {
                            rexml.append(line);
                        }
                        responseXml = rexml.toString();
                        break block57;
                    }
                    catch (Throwable throwable) {
                        var6_7 = throwable;
                        throw throwable;
                    }
                }
                log.info("\u8fde\u63a5\u5931\u8d25:{}", (Object)responseCode);
            }
            catch (IOException e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u65f6\u53d1\u751f I/O \u5f02\u5e38: ", (Throwable)e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
                log.info("\u8bf7\u6c42\u7ed3\u675f\uff0c\u54cd\u5e94\u7ed3\u679c: {}", (Object)responseXml);
            }
        }
        return responseXml;
    }
}

