/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkPurchaseApplyListEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkPurchaseApplyListService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.erp.entity.ErpConsumingApplyEntity;
import com.bringspring.erp.entity.ErpConsumingDetailEntity;
import com.bringspring.erp.entity.ErpMaterialEntity;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingApplyCrForm;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingApplyInfoVO;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingApplyListVO;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingApplyPagination;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingApplyPaginationExportModel;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingApplyUpForm;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingDetailModel;
import com.bringspring.erp.service.ErpConsumingApplyService;
import com.bringspring.erp.service.ErpConsumingDetailService;
import com.bringspring.erp.service.ErpMaterialService;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9886\u7528\u7533\u8bf7\u8868 \u4e3b\u8868"}, value="erp")
@RequestMapping(value={"/api/erp/ErpConsumingApply"})
public class ErpConsumingApplyController {
    private static final Logger log = LoggerFactory.getLogger(ErpConsumingApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpConsumingApplyService erpConsumingApplyService;
    @Autowired
    private ErpConsumingDetailService oaConsumingDetailService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private ErpMaterialService erpMaterialService;
    @Autowired
    private ErpMaterialTypeService ofMaterialTypeService;
    @Autowired
    private RkPurchaseApplyListService rkPurchaseApplyListService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody ErpConsumingApplyPagination erpConsumingApplyPagination) throws IOException {
        List<ErpConsumingApplyEntity> list = this.erpConsumingApplyService.getList(erpConsumingApplyPagination);
        List listVO = JsonUtil.getJsonToList(list, ErpConsumingApplyListVO.class);
        for (ErpConsumingApplyListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity;
            CrmCustomerEntity customerEntity;
            RkContractProjectEntity projectEntity;
            RkContractEntity rkContractEntity;
            vo.setSaleManager(this.baseDataUtil.userSelectValues(vo.getSaleManager()));
            vo.setProjectManager(this.baseDataUtil.userSelectValues(vo.getProjectManager()));
            vo.setApplyPerson(this.baseDataUtil.userSelectValues(vo.getApplyPerson()));
            vo.setStatusName(this.baseDataUtil.getDictName(vo.getStatus(), "consumingEnabledMark"));
            if (!StrUtil.isBlank((CharSequence)vo.getContractId()) && ObjectUtil.isNotEmpty((Object)(rkContractEntity = this.contractService.getInfo(vo.getContractId())))) {
                vo.setContractId(rkContractEntity.getContractName());
            }
            if (!StrUtil.isBlank((CharSequence)vo.getProjectId()) && ObjectUtil.isNotEmpty((Object)(projectEntity = this.rkContractProjectService.getInfo(vo.getProjectId())))) {
                vo.setProjectId(projectEntity.getProjectName());
            }
            if (!StrUtil.isBlank((CharSequence)vo.getCustomerId()) && ObjectUtil.isNotEmpty((Object)(customerEntity = this.crmCustomerService.getInfo(vo.getCustomerId())))) {
                vo.setCustomerId(customerEntity.getName());
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpConsumingApplyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        ErpConsumingApplyCrForm erpConsumingApplyCrForm = (ErpConsumingApplyCrForm)((Object)JsonUtil.getJsonToBean(crData, ErpConsumingApplyCrForm.class));
        String flowEngineId = "577758014920998725";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        ErpConsumingApplyEntity entity = (ErpConsumingApplyEntity)JsonUtil.getJsonToBean((Object)((Object)erpConsumingApplyCrForm), ErpConsumingApplyEntity.class);
        entity.setId(mainId);
        entity.setEnabledMark(erpConsumingApplyCrForm.getStatus());
        this.erpConsumingApplyService.save(entity);
        List ErpConsumingDetailList = JsonUtil.getJsonToList(erpConsumingApplyCrForm.getErpConsumingDetailList(), ErpConsumingDetailEntity.class);
        for (ErpConsumingDetailEntity entitys : ErpConsumingDetailList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setApplyId(entity.getId());
            this.oaConsumingDetailService.save(entitys);
        }
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(ErpConsumingApplyPaginationExportModel erpConsumingApplyPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)erpConsumingApplyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        ErpConsumingApplyPagination erpConsumingApplyPagination = (ErpConsumingApplyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)erpConsumingApplyPaginationExportModel), ErpConsumingApplyPagination.class));
        List<ErpConsumingApplyEntity> list = this.erpConsumingApplyService.getTypeList(erpConsumingApplyPagination, erpConsumingApplyPaginationExportModel.getDataType());
        for (ErpConsumingApplyEntity erpConsumingApplyEntity : list) {
            erpConsumingApplyEntity.setSaleManager(this.baseDataUtil.userSelectValues(erpConsumingApplyEntity.getSaleManager()));
            erpConsumingApplyEntity.setProjectManager(this.baseDataUtil.userSelectValues(erpConsumingApplyEntity.getProjectManager()));
            erpConsumingApplyEntity.setApplyPerson(this.baseDataUtil.userSelectValues(erpConsumingApplyEntity.getApplyPerson()));
        }
        List listVO = JsonUtil.getJsonToList(list, ErpConsumingApplyListVO.class);
        for (ErpConsumingApplyListVO erpConsumingApplyListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)erpConsumingApplyPaginationExportModel.getSelectKey()) ? erpConsumingApplyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540cid", (Object)"contractId"));
                        continue block34;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540ccode", (Object)"contractCode"));
                        continue block34;
                    }
                    case "saleManager": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u7ecf\u7406", (Object)"saleManager"));
                        continue block34;
                    }
                    case "contractLevel": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7ea7\u522b", (Object)"contractLevel"));
                        continue block34;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237id", (Object)"customerId"));
                        continue block34;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76eeid", (Object)"projectId"));
                        continue block34;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block34;
                    }
                    case "projectManager": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectManager"));
                        continue block34;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u8bf4\u660e", (Object)"description"));
                        continue block34;
                    }
                    case "applyPerson": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"applyPerson"));
                        continue block34;
                    }
                    case "applyDate": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65f6\u95f4", (Object)"applyDate"));
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ErpConsumingApplyInfoVO> info(@PathVariable(value="id") String id) {
        ErpConsumingApplyEntity entity = this.erpConsumingApplyService.getInfo(id);
        ErpConsumingApplyInfoVO vo = (ErpConsumingApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpConsumingApplyInfoVO.class);
        List<ErpConsumingDetailEntity> ErpConsumingDetailList = this.erpConsumingApplyService.GetErpConsumingDetailList(id);
        vo.setErpConsumingDetailList(JsonUtil.getJsonToList(ErpConsumingDetailList, ErpConsumingDetailModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<ErpConsumingApplyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCustomerEntity customerEntity;
        RkContractProjectEntity projectEntity;
        RkContractEntity rkContractEntity;
        ErpConsumingApplyEntity entity = this.erpConsumingApplyService.getInfo(id);
        ErpConsumingApplyInfoVO vo = (ErpConsumingApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpConsumingApplyInfoVO.class);
        List<ErpConsumingDetailEntity> oaConsumingDetailList = this.erpConsumingApplyService.GetErpConsumingDetailList(id);
        ArrayList<ErpConsumingDetailModel> oaConsumingDetailModelList = new ArrayList<ErpConsumingDetailModel>();
        if (!oaConsumingDetailList.isEmpty()) {
            for (ErpConsumingDetailEntity erpConsumingDetailEntity : oaConsumingDetailList) {
                ErpConsumingDetailModel detailModel = (ErpConsumingDetailModel)JsonUtil.getJsonToBean((Object)erpConsumingDetailEntity, ErpConsumingDetailModel.class);
                ErpMaterialEntity codeInfo = this.erpMaterialService.getCodeInfo(detailModel.getMaterialCode());
                detailModel.setMaterialName(codeInfo.getFullName());
                detailModel.setMaterialBrand(codeInfo.getBrand());
                detailModel.setMaterialModel(codeInfo.getModel());
                List purchaseList = this.rkPurchaseApplyListService.getListByConsumingId(detailModel.getId());
                for (RkPurchaseApplyListEntity temp : purchaseList) {
                    temp.setApplyUserId(this.baseDataUtil.userSelectValue(temp.getApplyUserId()));
                }
                detailModel.setPurchaseApplyList(purchaseList);
                oaConsumingDetailModelList.add(detailModel);
            }
        }
        vo.setErpConsumingDetailList(oaConsumingDetailModelList);
        vo.setSaleManager(this.baseDataUtil.userSelectValues(vo.getSaleManager()));
        vo.setProjectManager(this.baseDataUtil.userSelectValues(vo.getProjectManager()));
        vo.setApplyPerson(this.baseDataUtil.userSelectValues(vo.getApplyPerson()));
        if (!StrUtil.isBlank((CharSequence)vo.getContractId()) && ObjectUtil.isNotEmpty((Object)(rkContractEntity = this.contractService.getInfo(vo.getContractId())))) {
            vo.setContractId(rkContractEntity.getContractName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getProjectId()) && ObjectUtil.isNotEmpty((Object)(projectEntity = this.rkContractProjectService.getInfo(vo.getProjectId())))) {
            vo.setProjectId(projectEntity.getProjectName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getCustomerId()) && ObjectUtil.isNotEmpty((Object)(customerEntity = this.crmCustomerService.getInfo(vo.getCustomerId())))) {
            vo.setCustomerId(customerEntity.getName());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        ErpConsumingApplyUpForm erpConsumingApplyUpForm = (ErpConsumingApplyUpForm)((Object)JsonUtil.getJsonToBean(upData, ErpConsumingApplyUpForm.class));
        String flowEngineId = "577758014920998725";
        ErpConsumingApplyEntity entity = this.erpConsumingApplyService.getInfo(id);
        if (entity != null) {
            ErpConsumingApplyEntity subentity = (ErpConsumingApplyEntity)JsonUtil.getJsonToBean((Object)((Object)erpConsumingApplyUpForm), ErpConsumingApplyEntity.class);
            subentity.setEnabledMark(erpConsumingApplyUpForm.getStatus());
            this.erpConsumingApplyService.update(id, subentity);
            this.oaConsumingDetailService.deleteListByApplyId(id);
            List ErpConsumingDetailList = JsonUtil.getJsonToList(erpConsumingApplyUpForm.getErpConsumingApplyList(), ErpConsumingDetailEntity.class);
            for (ErpConsumingDetailEntity entitys : ErpConsumingDetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setApplyId(entity.getId());
                this.oaConsumingDetailService.save(entitys);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        ErpConsumingApplyEntity entity = this.erpConsumingApplyService.getInfo(id);
        if (entity != null) {
            this.erpConsumingApplyService.delete(entity);
            this.oaConsumingDetailService.deleteListByApplyId(id);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/materialList"})
    public ActionResult materialList(@RequestBody ErpConsumingApplyPagination erpConsumingApplyPagination) throws IOException {
        List<ErpConsumingDetailEntity> list = this.oaConsumingDetailService.getDetailList(erpConsumingApplyPagination);
        List listVO = JsonUtil.getJsonToList(list, ErpConsumingDetailModel.class);
        for (ErpConsumingDetailModel vo : listVO) {
            ErpMaterialEntity codeInfo;
            FlowTaskEntity flowTaskEntity;
            CrmCustomerEntity customerEntity;
            RkContractProjectEntity projectEntity;
            RkContractEntity rkContractEntity;
            ErpConsumingApplyEntity apply = this.erpConsumingApplyService.getInfo(vo.getApplyId());
            vo.setSaleManager(this.baseDataUtil.userSelectValues(apply.getSaleManager()));
            vo.setProjectManager(this.baseDataUtil.userSelectValues(apply.getProjectManager()));
            vo.setApplyPerson(this.baseDataUtil.userSelectValues(apply.getApplyPerson()));
            vo.setStatusName(this.baseDataUtil.getDictName(apply.getStatus(), "consumingEnabledMark"));
            vo.setDescription(apply.getDescription());
            vo.setContractCode(apply.getContractCode());
            vo.setApplyDate(apply.getApplyDate());
            if (!StrUtil.isBlank((CharSequence)apply.getContractId()) && ObjectUtil.isNotEmpty((Object)(rkContractEntity = this.contractService.getInfo(apply.getContractId())))) {
                vo.setContractId(rkContractEntity.getContractName());
            }
            if (!StrUtil.isBlank((CharSequence)apply.getProjectId()) && ObjectUtil.isNotEmpty((Object)(projectEntity = this.rkContractProjectService.getInfo(apply.getProjectId())))) {
                vo.setProjectId(projectEntity.getProjectName());
            }
            if (!StrUtil.isBlank((CharSequence)apply.getCustomerId()) && ObjectUtil.isNotEmpty((Object)(customerEntity = this.crmCustomerService.getInfo(apply.getCustomerId())))) {
                vo.setCustomerId(customerEntity.getName());
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)apply.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
            } else {
                vo.setFlowState(null);
            }
            if (!ObjectUtil.isNotEmpty((Object)(codeInfo = this.erpMaterialService.getCodeInfo(vo.getMaterialCode())))) continue;
            vo.setMaterialName(codeInfo.getFullName());
            vo.setMaterialBrand(codeInfo.getBrand());
            vo.setMaterialModel(codeInfo.getModel());
            vo.setMaterialCategory(codeInfo.getMaterialTypeId());
            vo.setMaterialCategoryName(this.ofMaterialTypeService.getInfo(codeInfo.getMaterialTypeId()).getFullName());
            vo.setMaterialProperty(codeInfo.getProperties());
            vo.setMaterialPropertyName(this.baseDataUtil.getDictName(codeInfo.getProperties(), "materialProperties"));
            vo.setMeasureUnit(codeInfo.getMatUnit());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpConsumingApplyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }
}

