/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.erp.entity.ErpEnterCheckOperateEntity;
import com.bringspring.erp.entity.ErpEnterEntity;
import com.bringspring.erp.entity.ErpEnterOperateEntity;
import com.bringspring.erp.entity.ErpMaterialTypeEntity;
import com.bringspring.erp.mapper.ErpEnterCheckOperateMapper;
import com.bringspring.erp.mapper.ErpEnterMapper;
import com.bringspring.erp.mapper.ErpEnterOperateMapper;
import com.bringspring.erp.model.enter.ErpEnterInfoVO;
import com.bringspring.erp.model.enter.ErpEnterListVO;
import com.bringspring.erp.model.enter.ErpEnterPagination;
import com.bringspring.erp.model.enter.ErpEnterPaginationExportModel;
import com.bringspring.erp.model.enterOperate.ErpEnterOperateCrForm;
import com.bringspring.erp.service.ErpEnterCheckOperateService;
import com.bringspring.erp.service.ErpEnterOperateService;
import com.bringspring.erp.service.ErpEntrepotService;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"erp_enter_operate"}, value="erp")
@RequestMapping(value={"/api/erp/ErpEnterOperate"})
public class ErpEnterOperateController {
    private static final Logger log = LoggerFactory.getLogger(ErpEnterOperateController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpEnterOperateService erpEnterOperateService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ErpEntrepotService erpEntrepotService;
    @Autowired
    private ErpEnterMapper erpEnterMapper;
    @Autowired
    private ErpEnterOperateMapper erpEnterOperateMapper;
    @Autowired
    private ErpMaterialTypeService erpMaterialTypeService;
    @Autowired
    private ErpEnterCheckOperateMapper erpEnterCheckOperateMapper;
    @Autowired
    private ErpEnterCheckOperateService erpEnterCheckOperateService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody ErpEnterPagination erpEnterPagination) throws IOException {
        List<ErpEnterOperateEntity> list = this.erpEnterOperateService.getList(erpEnterPagination);
        ArrayList<ErpEnterListVO> listVO = new ArrayList<ErpEnterListVO>();
        for (ErpEnterOperateEntity entity : list) {
            ErpEnterEntity erpEnterEntity = (ErpEnterEntity)this.erpEnterMapper.selectById((Serializable)((Object)entity.getEnterId()));
            ErpEnterListVO vo = (ErpEnterListVO)JsonUtil.getJsonToBean((Object)erpEnterEntity, ErpEnterListVO.class);
            vo.setNumber(String.valueOf(entity.getNumber()));
            vo.setCreatorTime(entity.getCreatorTime());
            vo.setBatch(entity.getBatch());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getBuyer())) {
                vo.setBuyer(this.baseDataUtil.userSelectValue(vo.getBuyer()));
            }
            vo.setProperties(this.baseDataUtil.getDictName(vo.getProperties(), "materialProperties"));
            vo.setPutId(entity.getId());
            vo.setCheckNumber(entity.getCheckNumber());
            vo.setRetreatNumber(entity.getRetreatNumber());
            vo.setIsCheck(entity.getIsCheck());
            vo.setEnterType(entity.getEnterType());
            listVO.add(vo);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpEnterPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getRecordList"})
    public ActionResult recordList(@RequestBody ErpEnterPagination erpEnterPagination) {
        List<ErpEnterOperateEntity> list = this.erpEnterOperateService.getListBySql(erpEnterPagination);
        ArrayList<ErpEnterListVO> listVO = new ArrayList<ErpEnterListVO>();
        for (ErpEnterOperateEntity entity : list) {
            ErpEnterEntity erpEnterEntity = (ErpEnterEntity)this.erpEnterMapper.selectById((Serializable)((Object)entity.getEnterId()));
            ErpEnterListVO vo = (ErpEnterListVO)JsonUtil.getJsonToBean((Object)erpEnterEntity, ErpEnterListVO.class);
            vo.setNumber(String.valueOf(erpEnterEntity.getNumber()));
            vo.setCreatorTime(entity.getCreatorTime());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entity.getCreatorUserId())) {
                vo.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            }
            vo.setProperties(this.baseDataUtil.getDictName(vo.getProperties(), "materialProperties"));
            vo.setPutId(entity.getId());
            vo.setOperateNumber(entity.getNumber());
            vo.setEnterTypeName(this.baseDataUtil.getDictName(entity.getEnterType(), "putType"));
            vo.setEnterType(entity.getEnterType());
            vo.setPutDate(entity.getPutDate());
            vo.setBatch(entity.getBatch());
            vo.setApplyCode(entity.getApplyCode());
            listVO.add(vo);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpEnterPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid ErpEnterOperateCrForm erpEnterOperateCrForm) throws DataException {
        this.erpEnterOperateService.create(erpEnterOperateCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/detail/{id}/{type}"})
    public ActionResult<ErpEnterInfoVO> detailInfo(@PathVariable(value="id") String id, @PathVariable(value="type") String type) {
        ErpEnterOperateEntity entity = new ErpEnterOperateEntity();
        ErpEnterInfoVO vo = new ErpEnterInfoVO();
        if (type.equals("putGood")) {
            entity = (ErpEnterOperateEntity)this.erpEnterOperateMapper.selectById((Serializable)((Object)id));
            ErpEnterEntity erpEnterEntity = (ErpEnterEntity)this.erpEnterMapper.selectById((Serializable)((Object)entity.getEnterId()));
            vo = (ErpEnterInfoVO)JsonUtil.getJsonToBean((Object)erpEnterEntity, ErpEnterInfoVO.class);
            vo.setBatch(entity.getBatch());
            vo.setIsConform(entity.getIsConform());
            vo.setIsFull(entity.getIsFull());
            vo.setIsSatisfaction(entity.getIsSatisfaction());
            vo.setRemark(entity.getRemark());
            vo.setQualityStart(entity.getQualityStart());
            vo.setQualityFinish(entity.getQualityFinish());
            vo.setFile(entity.getFile());
            vo.setApplyCode(entity.getApplyCode());
            vo.setBatch(entity.getBatch());
        } else {
            ErpEnterCheckOperateEntity erpEnterCheckOperateEntity = (ErpEnterCheckOperateEntity)this.erpEnterCheckOperateMapper.selectById((Serializable)((Object)id));
            ErpEnterEntity erpEnterEntity = (ErpEnterEntity)this.erpEnterMapper.selectById((Serializable)((Object)erpEnterCheckOperateEntity.getEnterId()));
            vo = (ErpEnterInfoVO)JsonUtil.getJsonToBean((Object)erpEnterEntity, ErpEnterInfoVO.class);
            entity = (ErpEnterOperateEntity)JsonUtil.getJsonToBean((Object)erpEnterCheckOperateEntity, ErpEnterOperateEntity.class);
            vo.setLocation(erpEnterCheckOperateEntity.getLocation());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)erpEnterCheckOperateEntity.getEntrepot())) {
                vo.setEntrepot(this.erpEntrepotService.getCode(erpEnterCheckOperateEntity.getEntrepot()).getEntrepotName());
            }
            vo.setRemark(erpEnterCheckOperateEntity.getRemark());
            vo.setFile(erpEnterCheckOperateEntity.getFile());
            vo.setApplyCode(erpEnterCheckOperateEntity.getApplyCode());
            vo.setBatch(erpEnterCheckOperateEntity.getBatch());
        }
        vo.setOperateNumber(entity.getNumber());
        vo.setPutDate(entity.getPutDate());
        vo.setProperties(this.baseDataUtil.getDictName(vo.getProperties(), "materialProperties"));
        vo.setMaterialType(this.erpMaterialTypeService.getInfo(vo.getMaterialType()).getFullName());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getBuyer())) {
            vo.setBuyer(this.baseDataUtil.userSelectValue(vo.getBuyer()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getCreatorUserId())) {
            vo.setCreatorUserName(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
        }
        vo.setCreatorTime(entity.getCreatorTime());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getLastModifyUserId())) {
            vo.setLastModifyUserName(this.baseDataUtil.userSelectValue(entity.getLastModifyUserId()));
        }
        vo.setLastModifyTime(entity.getLastModifyTime());
        vo.setErpEnterOperateList(this.erpEnterOperateService.getListByEnterCheckId(id));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(ErpEnterPaginationExportModel erpEnterPaginationExportModel) throws IOException {
        ErpEnterListVO vo;
        if (StringUtils.isEmpty((String)erpEnterPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        ErpEnterPagination mjOaAssetsApplyPagination = (ErpEnterPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)erpEnterPaginationExportModel), ErpEnterPagination.class));
        List<ErpEnterOperateEntity> list = this.erpEnterOperateService.getTypeListBySql(mjOaAssetsApplyPagination, erpEnterPaginationExportModel.getDataType());
        ArrayList<ErpEnterListVO> listVO = new ArrayList<ErpEnterListVO>();
        for (ErpEnterOperateEntity entity : list) {
            ErpEnterEntity erpEnterEntity = (ErpEnterEntity)this.erpEnterMapper.selectById((Serializable)((Object)entity.getEnterId()));
            vo = (ErpEnterListVO)JsonUtil.getJsonToBean((Object)erpEnterEntity, ErpEnterListVO.class);
            vo.setNumber(String.valueOf(erpEnterEntity.getNumber()));
            vo.setCreatorTime(entity.getCreatorTime());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entity.getCreatorUserId())) {
                vo.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            }
            vo.setProperties(this.baseDataUtil.getDictName(vo.getProperties(), "materialProperties"));
            vo.setPutId(entity.getId());
            vo.setOperateNumber(entity.getNumber());
            vo.setEnterTypeName(this.baseDataUtil.getDictName(entity.getEnterType(), "putType"));
            vo.setEnterType(entity.getEnterType());
            vo.setPutDate(entity.getPutDate());
            vo.setBatch(entity.getBatch());
            vo.setApplyCode(entity.getApplyCode());
            ErpMaterialTypeEntity erpMaterialTypeEntity = this.erpMaterialTypeService.getInfo(erpEnterEntity.getMaterialType());
            if (ObjectUtil.isNotEmpty((Object)erpMaterialTypeEntity)) {
                vo.setMaterialType(erpMaterialTypeEntity.getFullName());
            }
            listVO.add(vo);
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)erpEnterPaginationExportModel.getSelectKey()) ? erpEnterPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block44: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "putDate": {
                        entitys.add(new ExcelExportEntity("\u64cd\u4f5c\u65e5\u671f", (Object)"putDate"));
                        continue block44;
                    }
                    case "enterTypeName": {
                        entitys.add(new ExcelExportEntity("\u7c7b\u578b", (Object)"enterTypeName"));
                        continue block44;
                    }
                    case "operateNumber": {
                        entitys.add(new ExcelExportEntity("\u672c\u6b21\u64cd\u4f5c\u6570\u91cf", (Object)"operateNumber"));
                        continue block44;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u64cd\u4f5c\u5458", (Object)"creatorUserId"));
                        continue block44;
                    }
                    case "procureCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u53f7", (Object)"procureCode"));
                        continue block44;
                    }
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u7f16\u53f7", (Object)"code"));
                        continue block44;
                    }
                    case "properties": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5c5e\u6027", (Object)"properties"));
                        continue block44;
                    }
                    case "materialType": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5206\u7c7b", (Object)"materialType"));
                        continue block44;
                    }
                    case "brand": {
                        entitys.add(new ExcelExportEntity("\u54c1\u724c", (Object)"brand"));
                        continue block44;
                    }
                    case "fullName": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u540d\u79f0", (Object)"fullName"));
                        continue block44;
                    }
                    case "model": {
                        entitys.add(new ExcelExportEntity("\u89c4\u683c\u578b\u53f7", (Object)"model"));
                        continue block44;
                    }
                    case "number": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u6570\u91cf", (Object)"number"));
                        continue block44;
                    }
                    case "price": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u4ef7\u683c", (Object)"price"));
                        continue block44;
                    }
                    case "applyCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u660e\u7ec6\u5355\u636e\u53f7", (Object)"applyCode"));
                        continue block44;
                    }
                    case "batch": {
                        entitys.add(new ExcelExportEntity("\u6279\u6b21", (Object)"batch"));
                        continue block44;
                    }
                    case "marketId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u53f7", (Object)"marketId"));
                        continue block44;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

