/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.erp.entity.ErpEntrepotEntity;
import com.bringspring.erp.entity.ErpStorageRecordsEntity;
import com.bringspring.erp.mapper.ErpStorageRecordsMapper;
import com.bringspring.erp.model.entrepot.ErpEntrepotCrForm;
import com.bringspring.erp.model.entrepot.ErpEntrepotInfoVO;
import com.bringspring.erp.model.entrepot.ErpEntrepotListVO;
import com.bringspring.erp.model.entrepot.ErpEntrepotPagination;
import com.bringspring.erp.model.entrepot.ErpEntrepotPaginationExportModel;
import com.bringspring.erp.model.entrepot.ErpEntrepotUpForm;
import com.bringspring.erp.service.ErpEntrepotService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"erp_entrepot"}, value="erp")
@RequestMapping(value={"/api/erp/ErpEntrepot"})
public class ErpEntrepotController {
    private static final Logger log = LoggerFactory.getLogger(ErpEntrepotController.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpEntrepotService erpEntrepotService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ErpStorageRecordsMapper erpStorageRecordsMapper;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody ErpEntrepotPagination erpEntrepotPagination) throws IOException {
        List<ErpEntrepotEntity> list = this.erpEntrepotService.getList(erpEntrepotPagination);
        List listVO = JsonUtil.getJsonToList(list, ErpEntrepotListVO.class);
        for (ErpEntrepotListVO erpEntrepotVO : listVO) {
            erpEntrepotVO.setEntrepotType(this.baseDataUtil.getDictName(erpEntrepotVO.getEntrepotType(), "entrepot"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpEntrepotPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid ErpEntrepotCrForm erpEntrepotCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        ErpEntrepotEntity entity = (ErpEntrepotEntity)JsonUtil.getJsonToBean((Object)erpEntrepotCrForm, ErpEntrepotEntity.class);
        if (!this.erpEntrepotService.checkCodeUnique(entity)) {
            return ActionResult.fail((String)"\u7f16\u7801\u51b2\u7a81\uff0c\u65b0\u589e\u5931\u8d25");
        }
        if (!this.erpEntrepotService.checkNameUnique(entity)) {
            return ActionResult.fail((String)"\u540d\u79f0\u51b2\u7a81\uff0c\u65b0\u589e\u5931\u8d25");
        }
        entity.setId(mainId);
        this.erpEntrepotService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ErpEntrepotInfoVO> info(@PathVariable(value="id") String id) {
        ErpEntrepotEntity entity = this.erpEntrepotService.getInfo(id);
        ErpEntrepotInfoVO vo = (ErpEntrepotInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpEntrepotInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<ErpEntrepotInfoVO> detailInfo(@PathVariable(value="id") String id) {
        ErpEntrepotEntity entity = this.erpEntrepotService.getInfo(id);
        ErpEntrepotInfoVO vo = (ErpEntrepotInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpEntrepotInfoVO.class);
        vo.setEntrepotType(this.baseDataUtil.getDictName(vo.getEntrepotType(), "entrepot"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ErpEntrepotUpForm erpEntrepotUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        ErpEntrepotEntity entity = this.erpEntrepotService.getInfo(id);
        if (entity != null) {
            ErpEntrepotEntity subentity = (ErpEntrepotEntity)JsonUtil.getJsonToBean((Object)erpEntrepotUpForm, ErpEntrepotEntity.class);
            if (!this.erpEntrepotService.checkCodeUnique(subentity)) {
                return ActionResult.fail((String)"\u7f16\u7801\u51b2\u7a81\uff0c\u65b0\u589e\u5931\u8d25");
            }
            if (!this.erpEntrepotService.checkNameUnique(subentity)) {
                return ActionResult.fail((String)"\u540d\u79f0\u51b2\u7a81\uff0c\u65b0\u589e\u5931\u8d25");
            }
            this.erpEntrepotService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        ErpEntrepotEntity entity = this.erpEntrepotService.getInfo(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpStorageRecordsEntity::getWarehouseId, (Object)entity.getCode());
        List erpStorageRecordsEntities = this.erpStorageRecordsMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)erpStorageRecordsEntities)) {
            return ActionResult.fail((String)"\u4ed3\u5e93\u4e0b\u6709\u7269\u6599\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        if (entity != null) {
            this.erpEntrepotService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getAllWarehouseByCompany/{companyId}"})
    @DSTransactional
    public ActionResult getAllWarehouseByCompany(@PathVariable(value="companyId") String companyId) {
        List<ErpEntrepotEntity> allWarehouseByCompany = this.erpEntrepotService.getAllWarehouseByCompany(companyId);
        return ActionResult.success(allWarehouseByCompany);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(ErpEntrepotPaginationExportModel erpEntrepotPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)erpEntrepotPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        ErpEntrepotPagination erpEntrepotPagination = (ErpEntrepotPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)erpEntrepotPaginationExportModel), ErpEntrepotPagination.class));
        List<ErpEntrepotEntity> list = this.erpEntrepotService.getTypeList(erpEntrepotPagination, erpEntrepotPaginationExportModel.getDataType());
        for (ErpEntrepotEntity erpEntrepotEntity : list) {
            erpEntrepotEntity.setEntrepotType(this.baseDataUtil.getDictName(erpEntrepotEntity.getEntrepotType(), "entrepot"));
        }
        List listVO = JsonUtil.getJsonToList(list, ErpEntrepotListVO.class);
        for (ErpEntrepotListVO erpEntrepotListVO : listVO) {
            if (erpEntrepotListVO.getDeleteMark().equals("0")) {
                erpEntrepotListVO.setDeleteMark("\u6b63\u5e38");
                continue;
            }
            erpEntrepotListVO.setDeleteMark("\u505c\u7528");
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)erpEntrepotPaginationExportModel.getSelectKey()) ? erpEntrepotPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block24: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u4ed3\u5e93\u7f16\u7801", (Object)"code"));
                        continue block24;
                    }
                    case "entrepotName": {
                        entitys.add(new ExcelExportEntity("\u4ed3\u5e93\u540d\u79f0", (Object)"entrepotName"));
                        continue block24;
                    }
                    case "entrepotType": {
                        entitys.add(new ExcelExportEntity("\u4ed3\u5e93\u5206\u7c7b", (Object)"entrepotType"));
                        continue block24;
                    }
                    case "location": {
                        entitys.add(new ExcelExportEntity("\u4ed3\u5e93\u4f4d\u7f6e", (Object)"location"));
                        continue block24;
                    }
                    case "deleteMark": {
                        entitys.add(new ExcelExportEntity("\u4ed3\u5e93\u72b6\u6001", (Object)"deleteMark"));
                        continue block24;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block24;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u4ed3\u5e93\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u4ed3\u5e93\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

