/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.erp.entity.ErpMaterialTypeEntity;
import com.bringspring.erp.model.ofmaterialtype.ErpMaterialTypeCrForm;
import com.bringspring.erp.model.ofmaterialtype.ErpMaterialTypeInfoVO;
import com.bringspring.erp.model.ofmaterialtype.ErpMaterialTypeListVO;
import com.bringspring.erp.model.ofmaterialtype.ErpMaterialTypePagination;
import com.bringspring.erp.model.ofmaterialtype.ErpMaterialTypeUpForm;
import com.bringspring.erp.plugin.MaterialTypePlugin;
import com.bringspring.erp.plugin.MaterialTypePluginServiceLocator;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7269\u6599\u5206\u7c7b"}, value="erp")
@RequestMapping(value={"/api/erp/erpMaterialType"})
public class ErpMaterialTypeController {
    private static final Logger log = LoggerFactory.getLogger(ErpMaterialTypeController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpMaterialTypeService ofmaterialtypeService;
    @Autowired
    private MaterialTypePluginServiceLocator materialTypePluginServiceLocator;

    @GetMapping(value={"/getList"})
    public ActionResult list(ErpMaterialTypePagination ofmaterialtypePagination) throws IOException {
        List<ErpMaterialTypeEntity> list = this.ofmaterialtypeService.getList(ofmaterialtypePagination);
        for (ErpMaterialTypeEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, ErpMaterialTypeListVO.class);
        for (ErpMaterialTypeListVO erpMaterialTypeListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofmaterialtypePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid ErpMaterialTypeCrForm ofmaterialtypeCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65b0\u589e\u5931\u8d25");
        }
        ErpMaterialTypeEntity entity = (ErpMaterialTypeEntity)JsonUtil.getJsonToBean((Object)ofmaterialtypeCrForm, ErpMaterialTypeEntity.class);
        if (!this.ofmaterialtypeService.checkCodeUnique(entity)) {
            return ActionResult.fail((String)"\u7f16\u7801\u51b2\u7a81\uff0c\u65b0\u589e\u5931\u8d25");
        }
        if (!this.ofmaterialtypeService.checkNameUnique(entity)) {
            return ActionResult.fail((String)"\u540d\u79f0\u51b2\u7a81\uff0c\u65b0\u589e\u5931\u8d25");
        }
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.ofmaterialtypeService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ErpMaterialTypeInfoVO> info(@PathVariable(value="id") String id) {
        ErpMaterialTypeEntity entity = this.ofmaterialtypeService.getInfo(id);
        ErpMaterialTypeInfoVO vo = (ErpMaterialTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpMaterialTypeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<ErpMaterialTypeInfoVO> detailInfo(@PathVariable(value="id") String id) {
        ErpMaterialTypeEntity entity = this.ofmaterialtypeService.getInfo(id);
        ErpMaterialTypeInfoVO vo = (ErpMaterialTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpMaterialTypeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ErpMaterialTypeUpForm ofmaterialtypeUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        ErpMaterialTypeEntity entity = this.ofmaterialtypeService.getInfo(id);
        if (entity != null) {
            ErpMaterialTypeEntity subentity = (ErpMaterialTypeEntity)JsonUtil.getJsonToBean((Object)ofmaterialtypeUpForm, ErpMaterialTypeEntity.class);
            if (!this.ofmaterialtypeService.checkCodeUnique(subentity)) {
                return ActionResult.fail((String)"\u7f16\u7801\u51b2\u7a81\uff0c\u66f4\u65b0\u5931\u8d25");
            }
            if (!this.ofmaterialtypeService.checkNameUnique(subentity)) {
                return ActionResult.fail((String)"\u540d\u79f0\u51b2\u7a81\uff0c\u66f4\u65b0\u5931\u8d25");
            }
            this.ofmaterialtypeService.update(id, subentity);
            subentity.setCompanyId(userInfo.getOrganizeId());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        ErpMaterialTypeEntity entity = this.ofmaterialtypeService.getInfo(id);
        if (entity != null) {
            if (this.ofmaterialtypeService.selectTypeCount(id) > 0L) {
                return ActionResult.fail((String)"\u5b58\u5728\u4e0b\u7ea7\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            String checkResultStr = "";
            Map<String, MaterialTypePlugin> serviceLocatorAll = this.materialTypePluginServiceLocator.getAll();
            Set<Map.Entry<String, MaterialTypePlugin>> entries = serviceLocatorAll.entrySet();
            for (Map.Entry<String, MaterialTypePlugin> entry : entries) {
                String tempStr = entry.getValue().checkMaterialTypeExistData(id);
                if (!StringUtils.isNotEmpty((CharSequence)tempStr)) continue;
                checkResultStr = checkResultStr + tempStr + "\uff0c";
            }
            if (StringUtils.isNotEmpty((CharSequence)checkResultStr)) {
                return ActionResult.fail((String)(checkResultStr + "\u4e0d\u5141\u8bb8\u5220\u9664"));
            }
            this.ofmaterialtypeService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getListTree/{parentId}"})
    public ActionResult getListTree(@PathVariable(value="parentId") String parentId) {
        List<ErpMaterialTypeInfoVO> listVO = this.ofmaterialtypeService.getListTree(parentId);
        return ActionResult.success(listVO);
    }
}

