/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.erp.entity.ErpEnterCheckOperateEntity;
import com.bringspring.erp.entity.ErpEnterEntity;
import com.bringspring.erp.entity.ErpEnterOperateEntity;
import com.bringspring.erp.entity.ErpStorageRecordsEntity;
import com.bringspring.erp.mapper.ErpEnterCheckOperateMapper;
import com.bringspring.erp.mapper.ErpEnterMapper;
import com.bringspring.erp.mapper.ErpEnterOperateMapper;
import com.bringspring.erp.model.enter.ErpEnterPagination;
import com.bringspring.erp.model.enterOperate.ErpEnterOperateCrForm;
import com.bringspring.erp.service.ErpEnterCheckOperateService;
import com.bringspring.erp.service.ErpEnterService;
import com.bringspring.erp.service.ErpStorageRecordsService;
import com.bringspring.erp.util.Constants;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpEnterCheckOperateServiceImpl
extends ServiceImpl<ErpEnterCheckOperateMapper, ErpEnterCheckOperateEntity>
implements ErpEnterCheckOperateService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpEnterService erpEnterService;
    @Autowired
    private ErpEnterMapper erpEnterMapper;
    @Autowired
    private ErpEnterOperateMapper erpEnterOperateMapper;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ErpStorageRecordsService erpStorageRecordsService;

    @Override
    public void create(ErpEnterOperateCrForm erpEnterOperateCrForm) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        ErpEnterCheckOperateEntity entity = (ErpEnterCheckOperateEntity)JsonUtil.getJsonToBean((Object)erpEnterOperateCrForm, ErpEnterCheckOperateEntity.class);
        entity.setEnterId(erpEnterOperateCrForm.getId());
        if (erpEnterOperateCrForm.getEnterType().equals("check")) {
            ErpEnterEntity info = this.erpEnterService.getInfo(erpEnterOperateCrForm.getId());
            info.setCheckNumber(info.getCheckNumber() + Integer.valueOf(erpEnterOperateCrForm.getNumber()));
            this.erpEnterMapper.updateById(info);
            ErpEnterOperateEntity erpEnterOperateEntity = (ErpEnterOperateEntity)this.erpEnterOperateMapper.selectById((Serializable)((Object)erpEnterOperateCrForm.getPutId()));
            erpEnterOperateEntity.setCheckNumber(erpEnterOperateEntity.getCheckNumber() + Integer.valueOf(erpEnterOperateCrForm.getNumber()));
            if (erpEnterOperateEntity.getCheckNumber() + erpEnterOperateEntity.getRetreatNumber() == erpEnterOperateEntity.getNumber()) {
                erpEnterOperateEntity.setIsCheck(1);
            }
            if (ObjectUtil.isNotEmpty((Object)erpEnterOperateCrForm.getRetreatNumber()) && erpEnterOperateCrForm.getRetreatNumber() > 0) {
                erpEnterOperateEntity.setRetreatNumber(erpEnterOperateEntity.getRetreatNumber() + erpEnterOperateCrForm.getRetreatNumber());
            }
            this.erpEnterOperateMapper.updateById(erpEnterOperateEntity);
            String applyCode = "";
            applyCode = StringUtil.isNotEmpty((String)erpEnterOperateEntity.getApplyCode()) ? erpEnterOperateEntity.getApplyCode() : (StringUtil.isNotEmpty((String)info.getApplyCode()) ? info.getApplyCode() : this.erpEnterService.getApplyCode(info.getProcureCode(), info.getCode()));
            String putStorageId = RandomUtil.uuId();
            ErpStorageRecordsEntity erpStorageRecordsEntity = ErpStorageRecordsEntity.builder().id(putStorageId).companyId(userInfo.getOrganizeId()).warehouseId(erpEnterOperateCrForm.getEntrepot()).materialCode(((ErpEnterEntity)this.erpEnterMapper.selectById((Serializable)((Object)erpEnterOperateCrForm.getId()))).getCode()).amount(Integer.valueOf(erpEnterOperateCrForm.getNumber())).price(((ErpEnterEntity)this.erpEnterMapper.selectById((Serializable)((Object)erpEnterOperateCrForm.getId()))).getPrice()).type(Constants.PUT_STORAGE).outboundDate(new Date()).contractId(((ErpEnterEntity)this.erpEnterMapper.selectById((Serializable)((Object)erpEnterOperateCrForm.getId()))).getMarketId()).procureId(((ErpEnterEntity)this.erpEnterMapper.selectById((Serializable)((Object)erpEnterOperateCrForm.getId()))).getProcureCode()).enabledMark(1).description(erpEnterOperateCrForm.getRemark()).applyCode(applyCode).batch(erpEnterOperateEntity.getBatch()).inspectionId(mainId).pricingScheme(erpEnterOperateCrForm.getPricingScheme()).build();
            this.erpStorageRecordsService.saveBytype(erpStorageRecordsEntity, Constants.PUT_STORAGE);
            entity.setBatch(erpEnterOperateEntity.getBatch());
            entity.setApplyCode(applyCode);
        }
        entity.setId(mainId);
        this.save(entity);
        if (ObjectUtil.isNotEmpty((Object)erpEnterOperateCrForm.getRetreatNumber()) && erpEnterOperateCrForm.getRetreatNumber() > 0) {
            ErpEnterCheckOperateEntity returnEntity = new ErpEnterCheckOperateEntity();
            returnEntity.setEnterId(erpEnterOperateCrForm.getId());
            returnEntity.setEnterType("salesReturn");
            returnEntity.setNumber(erpEnterOperateCrForm.getRetreatNumber());
            returnEntity.setPutDate(erpEnterOperateCrForm.getPutDate());
            String returnMainId = RandomUtil.uuId();
            returnEntity.setId(returnMainId);
            returnEntity.setPutId(entity.getPutId());
            returnEntity.setEntrepot("");
            returnEntity.setLocation("");
            this.save(returnEntity);
            ErpEnterEntity info = this.erpEnterService.getInfo(erpEnterOperateCrForm.getId());
            info.setRetreatNumber(info.getRetreatNumber() + Integer.valueOf(erpEnterOperateCrForm.getRetreatNumber()));
            this.erpEnterMapper.updateById(info);
        }
    }

    @Override
    public List<ErpEnterCheckOperateEntity> getList(ErpEnterPagination erpEnterPagination) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int erpEnterNum = 0;
        QueryWrapper erpEnterQueryWrapper = new QueryWrapper();
        if (!userInfo.getIsAdministrator().booleanValue() && Objects.nonNull(erpEnterPagination.getMenuId()) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(erpEnterQueryWrapper, erpEnterPagination.getMenuId(), "erp_enter_operate"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<ErpEnterCheckOperateEntity>();
            }
            erpEnterQueryWrapper = (QueryWrapper)companyAuth;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)erpEnterPagination.getKeyword())) {
            ++erpEnterNum;
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(ErpEnterEntity::getFullName, (Object)erpEnterPagination.getKeyword())).or()).like(ErpEnterEntity::getProcureName, (Object)erpEnterPagination.getKeyword())).or()).like(ErpEnterEntity::getProcureCode, (Object)erpEnterPagination.getKeyword())).or()).like(ErpEnterEntity::getCode, (Object)erpEnterPagination.getKeyword());
            List erpEnterEntities = this.erpEnterMapper.selectList((Wrapper)queryWrapper);
            if (!erpEnterEntities.isEmpty()) {
                List ids = erpEnterEntities.stream().map(ErpEnterEntity::getId).collect(Collectors.toList());
                erpEnterQueryWrapper.lambda().in(ErpEnterCheckOperateEntity::getEnterId, ids);
            }
        }
        erpEnterQueryWrapper.lambda().orderByDesc(ErpEnterCheckOperateEntity::getCreatorTime);
        if (AllIdList.size() > 0) {
            erpEnterQueryWrapper.lambda().in(ErpEnterCheckOperateEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)erpEnterPagination.getSidx())) {
            erpEnterQueryWrapper.lambda().orderByDesc(ErpEnterCheckOperateEntity::getId);
        } else {
            try {
                String sidx = erpEnterPagination.getSidx();
                ErpEnterEntity erpEnterEntity = new ErpEnterEntity();
                Field declaredField = erpEnterEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                erpEnterQueryWrapper = "asc".equals(erpEnterPagination.getSort().toLowerCase()) ? (QueryWrapper)erpEnterQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)erpEnterQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(erpEnterPagination.getCurrentPage(), erpEnterPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)erpEnterQueryWrapper);
            return erpEnterPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return erpEnterPagination.setData(list, list.size());
    }
}

