/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.erp.entity.ErpBatchEntity;
import com.bringspring.erp.entity.ErpEnterCheckOperateEntity;
import com.bringspring.erp.entity.ErpEnterEntity;
import com.bringspring.erp.entity.ErpEnterOperateEntity;
import com.bringspring.erp.mapper.ErpBatchMapper;
import com.bringspring.erp.mapper.ErpEnterCheckOperateMapper;
import com.bringspring.erp.mapper.ErpEnterMapper;
import com.bringspring.erp.mapper.ErpEnterOperateMapper;
import com.bringspring.erp.model.enter.ErpEnterPagination;
import com.bringspring.erp.model.enterOperate.ErpEnterOperateCrForm;
import com.bringspring.erp.model.enterOperate.ErpEnterOperateInfoVO;
import com.bringspring.erp.service.ErpEnterOperateService;
import com.bringspring.erp.service.ErpEnterService;
import com.bringspring.erp.service.ErpEntrepotService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpEnterOperateServiceImpl
extends ServiceImpl<ErpEnterOperateMapper, ErpEnterOperateEntity>
implements ErpEnterOperateService {
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ErpEnterMapper erpEnterMapper;
    @Autowired
    private ErpEnterService erpEnterService;
    @Autowired
    private ErpEnterOperateMapper erpEnterOperateMapper;
    @Autowired
    private ErpEntrepotService erpEntrepotService;
    @Autowired
    private ErpBatchMapper erpBatchMapper;
    @Autowired
    private ErpEnterCheckOperateMapper erpEnterCheckOperateMapper;

    @Override
    public void create(ErpEnterOperateCrForm erpEnterOperateCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        ErpEnterOperateEntity entity = (ErpEnterOperateEntity)JsonUtil.getJsonToBean((Object)erpEnterOperateCrForm, ErpEnterOperateEntity.class);
        entity.setEnterId(erpEnterOperateCrForm.getId());
        if (erpEnterOperateCrForm.getEnterType().equals("putGood")) {
            String mainId2 = RandomUtil.uuId();
            int index = erpEnterOperateCrForm.getBatch().indexOf("-");
            ErpBatchEntity build = ErpBatchEntity.builder().id(mainId2).fullName(erpEnterOperateCrForm.getProcureCode()).batch(erpEnterOperateCrForm.getBatch().substring(index + 1)).build();
            this.erpBatchMapper.insert(build);
            entity.setBatch(erpEnterOperateCrForm.getBatch());
            if (CollectionUtil.isNotEmpty(erpEnterOperateCrForm.getStartTime())) {
                entity.setQualityStart(new Date(erpEnterOperateCrForm.getStartTime().get(0)));
                entity.setQualityFinish(new Date(erpEnterOperateCrForm.getStartTime().get(1)));
            }
            entity.setIsCheck(0);
            entity.setCheckNumber(0);
            entity.setRetreatNumber(0);
            ErpEnterEntity info = this.erpEnterService.getInfo(erpEnterOperateCrForm.getId());
            info.setReceiveNumber(info.getReceiveNumber() + Integer.valueOf(erpEnterOperateCrForm.getNumber()));
            this.erpEnterMapper.updateById(info);
        }
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public List<ErpEnterOperateInfoVO> getListByEnterId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(ErpEnterOperateEntity::getEnterId, new Object[]{id});
        List list = this.list((Wrapper)queryWrapper);
        QueryWrapper checkQueryWrapper = new QueryWrapper();
        checkQueryWrapper.lambda().in(ErpEnterCheckOperateEntity::getEnterId, new Object[]{id});
        List checkList = this.erpEnterCheckOperateMapper.selectList((Wrapper)checkQueryWrapper);
        List checkListVO = JsonUtil.getJsonToList((Object)checkList, ErpEnterOperateInfoVO.class);
        List listVO = JsonUtil.getJsonToList((Object)list, ErpEnterOperateInfoVO.class);
        listVO.addAll(checkListVO);
        for (ErpEnterOperateInfoVO enterOperateInfoVO : listVO) {
            enterOperateInfoVO.setEnterType(this.baseDataUtil.getDictName(enterOperateInfoVO.getEnterType(), "putType"));
            if (StringUtils.isNotEmpty((CharSequence)enterOperateInfoVO.getCreatorUserId())) {
                enterOperateInfoVO.setCreatorUserId(this.baseDataUtil.userSelectValue(enterOperateInfoVO.getCreatorUserId()));
            }
            if (!StringUtils.isNotEmpty((CharSequence)enterOperateInfoVO.getEntrepot())) continue;
            enterOperateInfoVO.setEntrepot(this.erpEntrepotService.getCode(enterOperateInfoVO.getEntrepot()).getEntrepotName());
        }
        return listVO;
    }

    @Override
    public List<ErpEnterOperateEntity> getList(ErpEnterPagination erpEnterPagination) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int erpEnterNum = 0;
        QueryWrapper erpEnterQueryWrapper = new QueryWrapper();
        if (!userInfo.getIsAdministrator().booleanValue() && Objects.nonNull(erpEnterPagination.getMenuId()) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(erpEnterQueryWrapper, erpEnterPagination.getMenuId(), "erp_enter_operate"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<ErpEnterOperateEntity>();
            }
            erpEnterQueryWrapper = (QueryWrapper)companyAuth;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)erpEnterPagination.getKeyword())) {
            ++erpEnterNum;
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(ErpEnterEntity::getFullName, (Object)erpEnterPagination.getKeyword())).or()).like(ErpEnterEntity::getProcureName, (Object)erpEnterPagination.getKeyword())).or()).like(ErpEnterEntity::getProcureCode, (Object)erpEnterPagination.getKeyword())).or()).like(ErpEnterEntity::getCode, (Object)erpEnterPagination.getKeyword());
            List erpEnterEntities = this.erpEnterMapper.selectList((Wrapper)queryWrapper);
            if (!erpEnterEntities.isEmpty()) {
                List ids = erpEnterEntities.stream().map(ErpEnterEntity::getId).collect(Collectors.toList());
                erpEnterQueryWrapper.lambda().in(ErpEnterOperateEntity::getEnterId, ids);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)erpEnterPagination.getState()) && erpEnterPagination.getState() != 0) {
            erpEnterQueryWrapper.lambda().eq(ErpEnterOperateEntity::getEnterType, (Object)"putGood");
        }
        if (ObjectUtil.isNotEmpty((Object)erpEnterPagination.getIsCheck())) {
            erpEnterQueryWrapper.lambda().eq(ErpEnterOperateEntity::getIsCheck, (Object)erpEnterPagination.getIsCheck());
        }
        erpEnterQueryWrapper.lambda().orderByDesc(ErpEnterOperateEntity::getCreatorTime);
        if (AllIdList.size() > 0) {
            erpEnterQueryWrapper.lambda().in(ErpEnterOperateEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)erpEnterPagination.getSidx())) {
            erpEnterQueryWrapper.lambda().orderByDesc(ErpEnterOperateEntity::getId);
        } else {
            try {
                String sidx = erpEnterPagination.getSidx();
                ErpEnterEntity erpEnterEntity = new ErpEnterEntity();
                Field declaredField = erpEnterEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                erpEnterQueryWrapper = "asc".equals(erpEnterPagination.getSort().toLowerCase()) ? (QueryWrapper)erpEnterQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)erpEnterQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(erpEnterPagination.getCurrentPage(), erpEnterPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)erpEnterQueryWrapper);
            return erpEnterPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return erpEnterPagination.setData(list, list.size());
    }

    @Override
    public List<ErpEnterOperateInfoVO> getListByEnterCheckId(String id) {
        QueryWrapper checkQueryWrapper = new QueryWrapper();
        checkQueryWrapper.lambda().in(ErpEnterCheckOperateEntity::getPutId, new Object[]{id});
        List checkList = this.erpEnterCheckOperateMapper.selectList((Wrapper)checkQueryWrapper);
        List listVO = JsonUtil.getJsonToList((Object)checkList, ErpEnterOperateInfoVO.class);
        for (ErpEnterOperateInfoVO enterOperateInfoVO : listVO) {
            enterOperateInfoVO.setEnterType(this.baseDataUtil.getDictName(enterOperateInfoVO.getEnterType(), "putType"));
            if (StringUtils.isNotEmpty((CharSequence)enterOperateInfoVO.getCreatorUserId())) {
                enterOperateInfoVO.setCreatorUserId(this.baseDataUtil.userSelectValue(enterOperateInfoVO.getCreatorUserId()));
            }
            if (!StringUtils.isNotEmpty((CharSequence)enterOperateInfoVO.getEntrepot())) continue;
            enterOperateInfoVO.setEntrepot(this.erpEntrepotService.getCode(enterOperateInfoVO.getEntrepot()).getEntrepotName());
        }
        return listVO;
    }

    @Override
    public List<ErpEnterOperateEntity> getListBySql(ErpEnterPagination erpEnterPagination) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper erpEnterQueryWrapper = new QueryWrapper();
        String userId = "";
        String companyId = "";
        if (!userInfo.getIsAdministrator().booleanValue() && Objects.nonNull(erpEnterPagination.getMenuId()) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(erpEnterQueryWrapper, erpEnterPagination.getMenuId(), "erp_enter_operate"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                userId = userInfo.getUserId();
            } else {
                erpEnterQueryWrapper = (QueryWrapper)companyAuth;
                if (erpEnterQueryWrapper.getSqlSegment().contains("company_id")) {
                    companyId = userInfo.getOrganizeId();
                }
                if (erpEnterQueryWrapper.getSqlSegment().contains("user_id")) {
                    userId = userInfo.getOrganizeId();
                }
            }
        }
        if (ObjectUtil.isEmpty((Object)erpEnterPagination.getSidx())) {
            erpEnterPagination.setSidx("creator_time");
        }
        ArrayList<String> idList = new ArrayList<String>();
        List<Map<String, Object>> temp = this.erpEnterOperateMapper.getPutGoodAndCheck(erpEnterPagination.getKeyword(), idList, erpEnterPagination.getSidx(), erpEnterPagination.getSort(), userId, companyId);
        List erpEnterOperateEntityList = JsonUtil.getJsonToList(temp, ErpEnterOperateEntity.class);
        List resList = erpEnterOperateEntityList.stream().skip((erpEnterPagination.getCurrentPage() - 1L) * erpEnterPagination.getPageSize()).limit(erpEnterPagination.getPageSize()).collect(Collectors.toList());
        return erpEnterPagination.setData(resList, erpEnterOperateEntityList.size());
    }

    @Override
    public List<ErpEnterOperateEntity> getTypeListBySql(ErpEnterPagination erpEnterPagination, String dataType) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper erpEnterQueryWrapper = new QueryWrapper();
        String userId = "";
        String companyId = "";
        if (!userInfo.getIsAdministrator().booleanValue() && Objects.nonNull(erpEnterPagination.getMenuId()) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(erpEnterQueryWrapper, erpEnterPagination.getMenuId(), "erp_enter_operate"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                userId = userInfo.getUserId();
            } else {
                erpEnterQueryWrapper = (QueryWrapper)companyAuth;
                if (erpEnterQueryWrapper.getSqlSegment().contains("company_id")) {
                    companyId = userInfo.getOrganizeId();
                }
                if (erpEnterQueryWrapper.getSqlSegment().contains("user_id")) {
                    userId = userInfo.getOrganizeId();
                }
            }
        }
        if (ObjectUtil.isEmpty((Object)erpEnterPagination.getSidx())) {
            erpEnterPagination.setSidx("creator_time");
        }
        ArrayList<String> idList = new ArrayList<String>();
        List<Map<String, Object>> temp = this.erpEnterOperateMapper.getPutGoodAndCheck(erpEnterPagination.getKeyword(), idList, erpEnterPagination.getSidx(), erpEnterPagination.getSort(), userId, companyId);
        List erpEnterOperateEntityList = JsonUtil.getJsonToList(temp, ErpEnterOperateEntity.class);
        List<Object> resList = CollectionUtil.list((boolean)false);
        resList = StrUtil.equals((CharSequence)dataType, (CharSequence)"0") ? erpEnterOperateEntityList.stream().skip((erpEnterPagination.getCurrentPage() - 1L) * erpEnterPagination.getPageSize()).limit(erpEnterPagination.getPageSize()).collect(Collectors.toList()) : erpEnterOperateEntityList;
        return erpEnterPagination.setData(resList, erpEnterOperateEntityList.size());
    }
}

