/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PadUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkpurchaseapplydetaillistEntity;
import com.bringspring.contract.service.CrmErpEnterService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkpurchaseapplydetaillistService;
import com.bringspring.erp.entity.ErpBatchEntity;
import com.bringspring.erp.entity.ErpEnterEntity;
import com.bringspring.erp.entity.ErpMaterialEntity;
import com.bringspring.erp.mapper.ErpBatchMapper;
import com.bringspring.erp.mapper.ErpEnterMapper;
import com.bringspring.erp.model.enter.ErpEnterCrForm;
import com.bringspring.erp.model.enter.ErpEnterImportReturnVO;
import com.bringspring.erp.model.enter.ErpEnterImportVO;
import com.bringspring.erp.model.enter.ErpEnterListInvoiceVo;
import com.bringspring.erp.model.enter.ErpEnterPagination;
import com.bringspring.erp.service.ErpEnterService;
import com.bringspring.erp.service.ErpMaterialService;
import com.bringspring.system.base.entity.BillRuleEntity;
import com.bringspring.system.base.mapper.BillRuleMapper;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpEnterServiceImpl
extends ServiceImpl<ErpEnterMapper, ErpEnterEntity>
implements ErpEnterService,
CrmErpEnterService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BillRuleMapper billRuleMapper;
    @Autowired
    private ErpBatchMapper erpBatchMapper;
    @Autowired
    private ErpEnterService erpEnterService;
    @Autowired
    private ErpMaterialService erpMaterialService;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkpurchaseapplydetaillistService rkpurchaseapplydetaillistService;

    @Override
    public List<ErpEnterEntity> getList(ErpEnterPagination erpEnterPagination) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int erpEnterNum = 0;
        QueryWrapper erpEnterQueryWrapper = new QueryWrapper();
        if (!userInfo.getIsAdministrator().booleanValue() && Objects.nonNull(erpEnterPagination.getMenuId()) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(erpEnterQueryWrapper, erpEnterPagination.getMenuId(), "erp_enter"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<ErpEnterEntity>();
            }
            erpEnterQueryWrapper = (QueryWrapper)companyAuth;
        }
        if (StringUtil.isNotEmpty((String)erpEnterPagination.getKeyword())) {
            ++erpEnterNum;
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)erpEnterQueryWrapper.lambda().like(ErpEnterEntity::getFullName, (Object)erpEnterPagination.getKeyword())).or()).like(ErpEnterEntity::getProcureName, (Object)erpEnterPagination.getKeyword())).or()).like(ErpEnterEntity::getProcureCode, (Object)erpEnterPagination.getKeyword())).or()).like(ErpEnterEntity::getCode, (Object)erpEnterPagination.getKeyword());
        }
        if (StringUtil.isNotEmpty((String)erpEnterPagination.getProcureCode())) {
            erpEnterQueryWrapper.lambda().eq(ErpEnterEntity::getProcureCode, (Object)erpEnterPagination.getProcureCode());
        }
        if (StringUtils.isNotEmpty((String)erpEnterPagination.getMaterialTypeId())) {
            erpEnterQueryWrapper.lambda().eq(ErpEnterEntity::getMaterialType, (Object)erpEnterPagination.getMaterialTypeId());
        }
        if (StringUtils.isNotEmpty((String)erpEnterPagination.getCreatorUserId())) {
            erpEnterQueryWrapper.lambda().eq(ErpEnterEntity::getBuyer, (Object)erpEnterPagination.getCreatorUserId());
        }
        if (erpEnterPagination.getStartTime() != null && erpEnterPagination.getStartTime().size() > 0) {
            erpEnterPagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(erpEnterPagination.getStartTime().get(0))));
            erpEnterPagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(erpEnterPagination.getStartTime().get(1) + 86400000L)));
            erpEnterQueryWrapper.lambda().between(ErpEnterEntity::getCreatorTime, (Object)erpEnterPagination.getStartTimes(), (Object)erpEnterPagination.getEndTime());
        }
        if (AllIdList.size() > 0) {
            erpEnterQueryWrapper.lambda().in(ErpEnterEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)erpEnterPagination.getSidx())) {
            erpEnterQueryWrapper.lambda().orderByDesc(ErpEnterEntity::getId);
        } else {
            try {
                String sidx = erpEnterPagination.getSidx();
                ErpEnterEntity erpEnterEntity = new ErpEnterEntity();
                Field declaredField = erpEnterEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                erpEnterQueryWrapper = "asc".equals(erpEnterPagination.getSort().toLowerCase()) ? (QueryWrapper)erpEnterQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)erpEnterQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(erpEnterPagination.getCurrentPage(), erpEnterPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)erpEnterQueryWrapper);
            return erpEnterPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return erpEnterPagination.setData(list, list.size());
    }

    @Override
    public ErpEnterEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpEnterEntity::getId, (Object)id);
        return (ErpEnterEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(List<ErpEnterCrForm> entity) {
        if (!entity.isEmpty()) {
            for (ErpEnterCrForm erpEnterCrForm : entity) {
                ErpEnterEntity erpEnterEntity = (ErpEnterEntity)JsonUtil.getJsonToBean((Object)erpEnterCrForm, ErpEnterEntity.class);
                this.save(erpEnterEntity);
            }
        }
    }

    @Override
    public String getNumber(String enCode) throws DataException {
        Integer startNumber;
        StringBuilder strNumber = new StringBuilder();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BillRuleEntity::getEnCode, (Object)"IncomingBatch");
        BillRuleEntity entity = (BillRuleEntity)this.billRuleMapper.selectOne((Wrapper)queryWrapper);
        if (entity != null) {
            startNumber = Integer.parseInt(entity.getStartNumber());
            String dateFor = entity.getDateFormat();
            QueryWrapper entityQueryWrapper = new QueryWrapper();
            entityQueryWrapper.lambda().eq(ErpBatchEntity::getFullName, (Object)enCode);
            entityQueryWrapper.lambda().orderByDesc(ErpBatchEntity::getCreatorTime);
            List erpBatchEntities = this.erpBatchMapper.selectList((Wrapper)entityQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)erpBatchEntities)) {
                String lastChar = "";
                lastChar = ((ErpBatchEntity)erpBatchEntities.get(0)).getBatch().length() > 10 ? ((ErpBatchEntity)erpBatchEntities.get(0)).getBatch().substring(((ErpBatchEntity)erpBatchEntities.get(0)).getBatch().length() - 2) : ((ErpBatchEntity)erpBatchEntities.get(0)).getBatch().substring(((ErpBatchEntity)erpBatchEntities.get(0)).getBatch().length() - 1);
                entity.setThisNumber(Integer.valueOf(lastChar));
                if (!"no".equals(dateFor)) {
                    String thisDate = DateUtil.dateNow((String)entity.getDateFormat());
                    String serialDate = ((ErpBatchEntity)erpBatchEntities.get(0)).getBatch().substring(((ErpBatchEntity)erpBatchEntities.get(0)).getBatch().length() - dateFor.length() - entity.getDigit(), ((ErpBatchEntity)erpBatchEntities.get(0)).getBatch().length() - entity.getDigit());
                    if (!serialDate.equals(thisDate)) {
                        entity.setThisNumber(Integer.valueOf(0));
                    }
                }
            } else {
                entity.setThisNumber(Integer.valueOf(0));
            }
            strNumber.append(entity.getPrefix());
            if (!"no".equals(dateFor)) {
                strNumber.append(DateUtil.dateNow((String)entity.getDateFormat()));
            }
        } else {
            throw new DataException("\u5355\u636e\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        strNumber.append(PadUtil.padRight((String)String.valueOf(startNumber + entity.getThisNumber()), (int)entity.getDigit(), (char)'0'));
        return strNumber.toString();
    }

    @Override
    public List<ErpEnterListInvoiceVo> getPurchaseInvoice(String enCode) throws DataException {
        return null;
    }

    public Integer getHarvestNumber(String code, String materialCode) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ErpEnterEntity::getProcureCode, (Object)code);
        lambdaQueryWrapper.eq(ErpEnterEntity::getCode, (Object)materialCode);
        ErpEnterEntity one = (ErpEnterEntity)this.getOne((Wrapper)lambdaQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)one)) {
            return one.getReceiveNumber();
        }
        return 0;
    }

    public void save(RkContractProcureEntity rkContractProcureEntity, List<RkpurchaseapplydetaillistEntity> purchaseList) {
        ArrayList entities = new ArrayList();
        UserInfo userInfo = this.userProvider.get();
        purchaseList.stream().forEach(purchase -> {
            ErpEnterEntity entity = new ErpEnterEntity();
            ErpMaterialEntity materialInfo = this.erpMaterialService.getCodeInfo(purchase.getMaterialCode());
            if (ObjectUtil.isNotEmpty((Object)materialInfo)) {
                entity.setId(RandomUtil.uuId());
                entity.setApplyTaxRate(purchase.getApplyTaxRate());
                entity.setCompanyId(userInfo.getOrganizeId());
                entity.setProcureCode(rkContractProcureEntity.getProcureCode());
                entity.setProcureName(rkContractProcureEntity.getProcureName());
                entity.setBrand(materialInfo.getBrand());
                entity.setFullName(materialInfo.getFullName());
                entity.setCode(materialInfo.getCode());
                entity.setModel(materialInfo.getModel());
                entity.setProperties(materialInfo.getProperties());
                entity.setMaterialType(materialInfo.getMaterialTypeId());
                entity.setSupplier(purchase.getSupplierName());
                entity.setPrice(purchase.getApplyPrice());
                entity.setMarketId(purchase.getXsCode());
                entity.setNumber(purchase.getApplyCount().intValue());
                entity.setBuyer(purchase.getApplyBuyer());
                entity.setReceiveNumber(0);
                entity.setCheckNumber(0);
                entity.setRetreatNumber(0);
                entity.setCreatorTime(new Date());
                entity.setCreatorUserId(userInfo.getUserId());
                entity.setApplyCode(purchase.getApplyCode());
                entities.add(entity);
            }
        });
        this.saveBatch(entities);
    }

    @Override
    public Map<String, Object> importPreview(List<ErpEnterImportVO> fileImportList) {
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        if (fileImportList != null) {
            int i;
            String msg = "";
            for (i = 0; i < fileImportList.size(); ++i) {
                HashMap<String, Object> dataRowMap = new HashMap<String, Object>();
                ErpEnterImportVO model = fileImportList.get(i);
                dataRowMap.put("procureCode", model.getProcureCode());
                dataRowMap.put("marketId", model.getMarketId());
                dataRowMap.put("supplier", model.getSupplier());
                dataRowMap.put("buyer", model.getBuyer());
                dataRowMap.put("code", model.getCode());
                dataRowMap.put("number", model.getNumber());
                dataRowMap.put("price", model.getPrice());
                dataRowMap.put("applyTaxRate", model.getApplyTaxRate());
                dataRowMap.put("creatorTime", model.getCreatorTime());
                dataRow.add(dataRowMap);
            }
            for (i = 1; i < 6; ++i) {
                HashMap<String, Object> columnsMap = new HashMap<String, Object>();
                columnsMap.put("AllowDBNull", true);
                columnsMap.put("AutoIncrement", false);
                columnsMap.put("AutoIncrementSeed", 0);
                columnsMap.put("AutoIncrementStep", 1);
                columnsMap.put("Caption", this.getColumns(i));
                columnsMap.put("ColumnMapping", 1);
                columnsMap.put("ColumnName", this.getColumns(i));
                columnsMap.put("Container", null);
                columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
                columnsMap.put("DateTimeMode", 3);
                columnsMap.put("DefaultValue", null);
                columnsMap.put("DesignMode", false);
                columnsMap.put("Expression", "");
                columnsMap.put("ExtendedProperties", "");
                columnsMap.put("MaxLength", -1);
                columnsMap.put("Namespace", "");
                columnsMap.put("Ordinal", 0);
                columnsMap.put("Prefix", "");
                columnsMap.put("ReadOnly", false);
                columnsMap.put("Site", null);
                columnsMap.put("Table", fileImportList);
                columnsMap.put("Unique", false);
                columns.add(columnsMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u91c7\u8d2d\u5408\u540c\u53f7");
        map.put(2, "\u9500\u552e\u5408\u540c\u53f7");
        map.put(3, "\u4f9b\u5e94\u5546");
        map.put(4, "\u91c7\u8d2d\u5458");
        map.put(5, "\u7269\u6599\u7f16\u7801");
        map.put(6, "\u6570\u91cf");
        map.put(7, "\u5355\u4ef7");
        map.put(8, "\u7a0e\u7387");
        map.put(9, "\u521b\u5efa\u65e5\u671f");
        return (String)map.get(key);
    }

    @Override
    public ErpEnterImportReturnVO importData(List<ErpEnterImportVO> dataList) {
        String msg = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String year = sdf.format(new Date());
        List errorMsgList = CollectionUtil.list((boolean)false);
        List errorList = CollectionUtil.list((boolean)false);
        List successList = CollectionUtil.list((boolean)false);
        List taxList = this.dictionaryDataService.getList("4360623057975783731");
        List materialList = this.erpMaterialService.list();
        List proManagerList = this.rkProcureManageService.list();
        List contractList = this.rkContractService.list();
        for (ErpEnterImportVO model : dataList) {
            List tempPro;
            if (ObjectUtil.isEmpty((Object)model.getCode())) {
                model.setErrMsg("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else {
                tempPro = materialList.stream().filter(a -> a.getCode().equals(model.getCode())).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(tempPro)) {
                    model.setErrMsg("\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (ObjectUtil.isEmpty((Object)model.getProcureCode())) {
                model.setErrMsg("\u91c7\u8d2d\u5408\u540c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else {
                tempPro = proManagerList.stream().filter(a -> a.getProcureCode().equals(model.getProcureCode())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(tempPro)) {
                    model.setProcureId(tempPro.stream().map(RkProcureManageEntity::getId).collect(Collectors.joining("")));
                } else {
                    model.setErrMsg("\u91c7\u8d2d\u5408\u540c\u53f7\u4e0d\u5b58\u5728");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (!ObjectUtil.isEmpty((Object)model.getMarketId())) {
                tempPro = contractList.stream().filter(a -> a.getContractCode().equals(model.getMarketId())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(tempPro)) {
                    model.setContractId(tempPro.stream().map(RkContractEntity::getId).collect(Collectors.joining("")));
                } else {
                    model.setErrMsg("\u9500\u552e\u5408\u540c\u53f7\u4e0d\u5b58\u5728");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (ObjectUtil.isEmpty((Object)model.getNumber())) {
                model.setErrMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getPrice())) {
                model.setErrMsg("\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getApplyTaxRate())) {
                model.setErrMsg("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else if (!model.getApplyTaxRate().contains("%")) {
                model.setErrMsg("\u7a0e\u7387\u8bf7\u586b\u5199\u767e\u5206\u6bd4\u6587\u672c");
                errorMsgList.add(model.getErrMsg());
            } else {
                List tempTax = taxList.stream().filter(a -> a.getFullName().equals(model.getApplyTaxRate())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(tempTax)) {
                    model.setApplyTaxRateId(tempTax.stream().map(a -> a.getId()).collect(Collectors.joining("")));
                } else {
                    model.setErrMsg("\u7a0e\u7387\u672a\u5728\u6863\u6848\u8303\u56f4");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (!StringUtils.isNotEmpty((String)model.getErrMsg())) continue;
            model.setErrMsgList(errorMsgList);
            errorList.add(model);
        }
        if (CollectionUtil.isEmpty((Collection)errorMsgList)) {
            UserInfo userInfo = this.userProvider.get();
            for (ErpEnterImportVO model : dataList) {
                ErpEnterEntity entity = new ErpEnterEntity();
                entity.setId(RandomUtil.uuId());
                entity.setApplyTaxRate(model.getApplyTaxRateId());
                entity.setCompanyId(userInfo.getOrganizeId());
                entity.setProcureCode(model.getProcureCode());
                RkProcureManageEntity rkProcureManageEntity = this.rkProcureManageService.getInfo(model.getProcureId());
                entity.setProcureName(rkProcureManageEntity.getProcureName());
                ErpMaterialEntity materialInfo = this.erpMaterialService.getCodeInfo(model.getCode());
                entity.setBrand(materialInfo.getBrand());
                entity.setFullName(materialInfo.getFullName());
                entity.setCode(materialInfo.getCode());
                entity.setModel(materialInfo.getModel());
                entity.setProperties(materialInfo.getProperties());
                entity.setMaterialType(materialInfo.getMaterialTypeId());
                entity.setSupplier(rkProcureManageEntity.getSupplierName());
                entity.setPrice(model.getPrice());
                entity.setMarketId(model.getMarketId());
                entity.setNumber((int)model.getNumber());
                entity.setBuyer(rkProcureManageEntity.getCreatorUserId());
                entity.setReceiveNumber(0);
                entity.setCheckNumber(0);
                entity.setRetreatNumber(0);
                entity.setCreatorTime(ObjectUtil.isEmpty((Object)model.getCreatorTime()) ? new Date() : model.getCreatorTime());
                entity.setCreatorUserId(userInfo.getUserId());
                if (StrUtil.isNotEmpty((CharSequence)model.getApplyCode())) {
                    entity.setApplyCode(model.getApplyCode());
                }
                successList.add(entity);
            }
            this.saveBatch(successList);
        }
        ErpEnterImportReturnVO vo = new ErpEnterImportReturnVO();
        vo.setSnum(successList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, ErpEnterImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public String getApplyCode(String procureCode, String code) {
        String res = "";
        if (StrUtil.isNotEmpty((CharSequence)procureCode) && StrUtil.isNotEmpty((CharSequence)code)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(RkpurchaseapplydetaillistEntity::getHtCode, (Object)procureCode);
            queryWrapper.lambda().eq(RkpurchaseapplydetaillistEntity::getMaterialCode, (Object)code);
            queryWrapper.lambda().eq(RkpurchaseapplydetaillistEntity::getCloseFlowStatus, (Object)0);
            queryWrapper.lambda().isNotNull(RkpurchaseapplydetaillistEntity::getApplyCode);
            List list = this.rkpurchaseapplydetaillistService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                res = list.stream().map(RkpurchaseapplydetaillistEntity::getApplyCode).distinct().collect(Collectors.joining(","));
            }
        }
        return res;
    }
}

