/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.model.ErpMaterialVo;
import com.bringspring.contract.service.CrmErpMaterialService;
import com.bringspring.erp.entity.ErpMaterialEntity;
import com.bringspring.erp.entity.ErpMaterialTypeEntity;
import com.bringspring.erp.mapper.ErpMaterialMapper;
import com.bringspring.erp.model.ofmaterial.ErpMaterialListQuery;
import com.bringspring.erp.model.ofmaterial.ErpMaterialPagination;
import com.bringspring.erp.model.ofmaterial.MaterialImportReturnVO;
import com.bringspring.erp.model.ofmaterial.MaterialImportVO;
import com.bringspring.erp.service.ErpMaterialService;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.erp.util.DeleteMarkEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpMaterialServiceImpl
extends ServiceImpl<ErpMaterialMapper, ErpMaterialEntity>
implements ErpMaterialService,
CrmErpMaterialService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ErpMaterialTypeService erpMaterialTypeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private DictionaryDataService dictionaryDataService;

    @Override
    public List<ErpMaterialEntity> getList(ErpMaterialPagination ofMaterialPagination) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofmaterialNum = 0;
        QueryWrapper ofmaterialQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ofMaterialPagination.getMaterialTypeId())) {
            ++ofmaterialNum;
            ofmaterialQueryWrapper.lambda().eq(ErpMaterialEntity::getMaterialTypeId, (Object)ofMaterialPagination.getMaterialTypeId());
        }
        if (StringUtils.isNotEmpty((String)ofMaterialPagination.getDeleteMark())) {
            ++ofmaterialNum;
            ofmaterialQueryWrapper.lambda().like(ErpMaterialEntity::getDeleteMark, (Object)ofMaterialPagination.getDeleteMark());
        }
        if (StringUtils.isNotEmpty((String)ofMaterialPagination.getKeyword())) {
            ++ofmaterialNum;
            ofmaterialQueryWrapper.lambda().and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(ErpMaterialEntity::getFullName, (Object)ofMaterialPagination.getKeyword())).or()).like(ErpMaterialEntity::getCode, (Object)ofMaterialPagination.getKeyword())).or()).like(ErpMaterialEntity::getBrand, (Object)ofMaterialPagination.getKeyword())).or()).like(ErpMaterialEntity::getModel, (Object)ofMaterialPagination.getKeyword())).or()).like(ErpMaterialEntity::getDescription, (Object)ofMaterialPagination.getKeyword());
            });
        }
        if (!userInfo.getIsAdministrator().booleanValue()) {
            ofmaterialQueryWrapper.lambda().eq(ErpMaterialEntity::getCompanyId, (Object)userInfo.getOrganizeId());
        }
        if (StringUtils.isNotEmpty((String)ofMaterialPagination.getCode())) {
            ++ofmaterialNum;
            ofmaterialQueryWrapper.lambda().like(ErpMaterialEntity::getCode, (Object)ofMaterialPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)ofMaterialPagination.getFullName())) {
            ++ofmaterialNum;
            ofmaterialQueryWrapper.lambda().like(ErpMaterialEntity::getFullName, (Object)ofMaterialPagination.getFullName());
        }
        if (AllIdList.size() > 0) {
            ofmaterialQueryWrapper.lambda().in(ErpMaterialEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ofMaterialPagination.getSidx())) {
            ofmaterialQueryWrapper.lambda().orderByDesc(ErpMaterialEntity::getCreatorTime);
        } else {
            Field[] allFields;
            String sidx = ofMaterialPagination.getSidx();
            ErpMaterialEntity ErpMaterialEntity2 = new ErpMaterialEntity();
            for (Field allField : allFields = ReflectUtil.getFields(ErpMaterialEntity2.getClass())) {
                if (!sidx.equals(allField.getName())) continue;
                Field declaredField = allField;
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ofmaterialQueryWrapper = "asc".equals(ofMaterialPagination.getSort().toLowerCase()) ? (QueryWrapper)ofmaterialQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ofmaterialQueryWrapper.orderByDesc((Object)value);
                break;
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ofMaterialPagination.getCurrentPage(), ofMaterialPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ofmaterialQueryWrapper);
            return ofMaterialPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ofMaterialPagination.setData(list, list.size());
    }

    @Override
    public List<ErpMaterialEntity> getTypeList(ErpMaterialPagination ofMaterialPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofmaterialNum = 0;
        QueryWrapper ofmaterialQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ofMaterialPagination.getMaterialTypeId())) {
            ++ofmaterialNum;
            ofmaterialQueryWrapper.lambda().eq(ErpMaterialEntity::getMaterialTypeId, (Object)ofMaterialPagination.getMaterialTypeId());
        }
        if (StringUtils.isNotEmpty((String)ofMaterialPagination.getFullName())) {
            ++ofmaterialNum;
            ofmaterialQueryWrapper.lambda().like(ErpMaterialEntity::getFullName, (Object)ofMaterialPagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)ofMaterialPagination.getCode())) {
            ++ofmaterialNum;
            ofmaterialQueryWrapper.lambda().like(ErpMaterialEntity::getCode, (Object)ofMaterialPagination.getCode());
        }
        if (AllIdList.size() > 0) {
            ofmaterialQueryWrapper.lambda().in(ErpMaterialEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ofMaterialPagination.getSidx())) {
            ofmaterialQueryWrapper.lambda().orderByDesc(ErpMaterialEntity::getCreatorTime);
        } else {
            Field[] allFields;
            String sidx = ofMaterialPagination.getSidx();
            ErpMaterialEntity ErpMaterialEntity2 = new ErpMaterialEntity();
            for (Field allField : allFields = ReflectUtil.getFields(ErpMaterialEntity2.getClass())) {
                if (!sidx.equals(allField.getName())) continue;
                Field declaredField = allField;
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ofmaterialQueryWrapper = "asc".equals(ofMaterialPagination.getSort().toLowerCase()) ? (QueryWrapper)ofmaterialQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ofmaterialQueryWrapper.orderByDesc((Object)value);
                break;
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ofMaterialPagination.getCurrentPage(), ofMaterialPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ofmaterialQueryWrapper);
                return ofMaterialPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ofMaterialPagination.setData(list, list.size());
        }
        return this.list((Wrapper)ofmaterialQueryWrapper);
    }

    @Override
    public List<ErpMaterialEntity> getMaterialList(ErpMaterialListQuery ofMaterialListQuery) {
        QueryWrapper ofmaterialQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ofMaterialListQuery.getMaterialTypeId())) {
            ofmaterialQueryWrapper.lambda().eq(ErpMaterialEntity::getMaterialTypeId, (Object)ofMaterialListQuery.getMaterialTypeId());
        }
        if (StringUtils.isNotEmpty((String)ofMaterialListQuery.getFullName())) {
            ofmaterialQueryWrapper.lambda().like(ErpMaterialEntity::getFullName, (Object)ofMaterialListQuery.getFullName());
        }
        if (StringUtils.isNotEmpty((String)ofMaterialListQuery.getCode())) {
            ofmaterialQueryWrapper.lambda().like(ErpMaterialEntity::getCode, (Object)ofMaterialListQuery.getCode());
        }
        ofmaterialQueryWrapper.lambda().orderByDesc(ErpMaterialEntity::getCreatorTime);
        return this.list((Wrapper)ofmaterialQueryWrapper);
    }

    @Override
    public ErpMaterialEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpMaterialEntity::getId, (Object)id);
        return (ErpMaterialEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public ErpMaterialEntity getCodeInfo(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpMaterialEntity::getCode, (Object)code);
        return (ErpMaterialEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(ErpMaterialEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, ErpMaterialEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(ErpMaterialEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public boolean checkCodeUnique(ErpMaterialEntity entity) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ErpMaterialEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.eq(ErpMaterialEntity::getCode, (Object)entity.getCode());
        queryWrapper.last("limit 1");
        ErpMaterialEntity info = (ErpMaterialEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)info) || info.getId().equals(entity.getId());
    }

    @Override
    public boolean checkNameUnique(ErpMaterialEntity entity) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ErpMaterialEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.eq(ErpMaterialEntity::getFullName, (Object)entity.getFullName());
        queryWrapper.eq(ErpMaterialEntity::getModel, (Object)entity.getModel());
        queryWrapper.last("limit 1");
        ErpMaterialEntity info = (ErpMaterialEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)info) || info.getId().equals(entity.getId());
    }

    @Override
    public long selectMaterialByMaterialTypeIdCount(String materialTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpMaterialEntity::getMaterialTypeId, (Object)materialTypeId);
        return this.count((Wrapper)queryWrapper);
    }

    public List<String> getInfoList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{ErpMaterialEntity::getCode});
        return this.listObjs((Wrapper)queryWrapper, Object::toString);
    }

    public ErpMaterialVo getInfoByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpMaterialEntity::getCode, (Object)code);
        ErpMaterialEntity entity = (ErpMaterialEntity)this.getOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)entity)) {
            ErpMaterialTypeEntity typeInfo = this.erpMaterialTypeService.getInfo(entity.getMaterialTypeId());
            ErpMaterialVo erpMaterialVo = (ErpMaterialVo)JsonUtil.getJsonToBean((Object)entity, ErpMaterialVo.class);
            erpMaterialVo.setPropertiesName(this.baseDataUtil.getDictName(entity.getProperties(), "materialProperties"));
            erpMaterialVo.setMaterialTypeName(typeInfo.getFullName());
            return erpMaterialVo;
        }
        ErpMaterialVo temp = new ErpMaterialVo();
        temp.setCode(code);
        return temp;
    }

    @Override
    @Transactional
    public MaterialImportReturnVO importData(List<MaterialImportVO> dataList) {
        String msg = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String year = sdf.format(new Date());
        List errorMsgList = CollectionUtil.list((boolean)false);
        List errorList = CollectionUtil.list((boolean)false);
        List successList = CollectionUtil.list((boolean)false);
        List propertyList = this.dictionaryDataService.getList("523060482374910725");
        List typeList = this.erpMaterialTypeService.list();
        for (MaterialImportVO model : dataList) {
            ErpMaterialEntity entity;
            if (ObjectUtil.isEmpty((Object)model.getPropertiesName())) {
                model.setErrMsg("\u7269\u6599\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else {
                List tempPro = propertyList.stream().filter(a -> a.getFullName().equals(model.getPropertiesName())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(tempPro)) {
                    model.setProperties(tempPro.stream().map(DictionaryDataEntity::getEnCode).collect(Collectors.joining("")));
                } else {
                    model.setErrMsg("\u7269\u6599\u5c5e\u6027\u4e0d\u5b58\u5728");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (ObjectUtil.isEmpty((Object)model.getMaterialTypeName())) {
                model.setErrMsg("\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else {
                List tempType = typeList.stream().filter(a -> a.getFullName().equals(model.getMaterialTypeName())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(tempType)) {
                    model.setMaterialTypeId(tempType.stream().map(ErpMaterialTypeEntity::getId).collect(Collectors.joining("")));
                } else {
                    model.setErrMsg("\u7269\u6599\u5206\u7c7b\u4e0d\u5b58\u5728");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (ObjectUtil.isEmpty((Object)model.getBrand())) {
                model.setErrMsg("\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getFullName())) {
                model.setErrMsg("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else {
                entity = (ErpMaterialEntity)JsonUtil.getJsonToBean((Object)model, ErpMaterialEntity.class);
                if (!this.checkNameUnique(entity)) {
                    model.setErrMsg("\u540d\u79f0\u5df2\u5b58\u5728");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (ObjectUtil.isEmpty((Object)model.getModel())) {
                model.setErrMsg("\u89c4\u683c\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getCode())) {
                model.setErrMsg("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else {
                entity = (ErpMaterialEntity)JsonUtil.getJsonToBean((Object)model, ErpMaterialEntity.class);
                if (!this.checkCodeUnique(entity)) {
                    model.setErrMsg("\u7f16\u7801\u5df2\u5b58\u5728");
                    errorMsgList.add(model.getErrMsg());
                }
            }
            if (!StringUtils.isNotEmpty((String)model.getErrMsg())) continue;
            errorList.add(model);
        }
        if (CollectionUtil.isEmpty((Collection)errorMsgList)) {
            UserInfo userInfo = this.userProvider.get();
            for (MaterialImportVO model : dataList) {
                ErpMaterialEntity entity = (ErpMaterialEntity)JsonUtil.getJsonToBean((Object)model, ErpMaterialEntity.class);
                entity.setId(RandomUtil.uuId());
                entity.setCompanyId(userInfo.getOrganizeId());
                entity.setCreatorUserId(userInfo.getUserId());
                entity.setCreatorTime((Date)DateUtil.date());
                successList.add(entity);
            }
            this.saveBatch(successList);
        }
        MaterialImportReturnVO vo = new MaterialImportReturnVO();
        vo.setSnum(successList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, MaterialImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public Map<String, Object> importPreview(List<MaterialImportVO> fileImportList) {
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        if (fileImportList != null) {
            int i;
            String msg = "";
            for (i = 0; i < fileImportList.size(); ++i) {
                HashMap<String, String> dataRowMap = new HashMap<String, String>();
                MaterialImportVO model = fileImportList.get(i);
                dataRowMap.put("materialTypeName", model.getMaterialTypeName());
                dataRowMap.put("fullName", model.getFullName());
                dataRowMap.put("brand", model.getBrand());
                dataRowMap.put("code", model.getCode());
                dataRowMap.put("supplier", model.getSupplier());
                dataRowMap.put("propertiesName", model.getPropertiesName());
                dataRowMap.put("model", model.getModel());
                dataRowMap.put("matUnit", model.getMatUnit());
                dataRowMap.put("description", model.getDescription());
                dataRow.add(dataRowMap);
            }
            for (i = 1; i < 6; ++i) {
                HashMap<String, Object> columnsMap = new HashMap<String, Object>();
                columnsMap.put("AllowDBNull", true);
                columnsMap.put("AutoIncrement", false);
                columnsMap.put("AutoIncrementSeed", 0);
                columnsMap.put("AutoIncrementStep", 1);
                columnsMap.put("Caption", this.getColumns(i));
                columnsMap.put("ColumnMapping", 1);
                columnsMap.put("ColumnName", this.getColumns(i));
                columnsMap.put("Container", null);
                columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
                columnsMap.put("DateTimeMode", 3);
                columnsMap.put("DefaultValue", null);
                columnsMap.put("DesignMode", false);
                columnsMap.put("Expression", "");
                columnsMap.put("ExtendedProperties", "");
                columnsMap.put("MaxLength", -1);
                columnsMap.put("Namespace", "");
                columnsMap.put("Ordinal", 0);
                columnsMap.put("Prefix", "");
                columnsMap.put("ReadOnly", false);
                columnsMap.put("Site", null);
                columnsMap.put("Table", fileImportList);
                columnsMap.put("Unique", false);
                columns.add(columnsMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u7269\u6599\u5206\u7c7b");
        map.put(2, "\u7269\u6599\u540d\u79f0");
        map.put(3, "\u7269\u6599\u7f16\u7801");
        map.put(4, "\u4f9b\u5e94\u5546");
        map.put(5, "\u5c5e\u6027");
        map.put(6, "\u54c1\u724c");
        map.put(7, "\u89c4\u683c\u578b\u53f7");
        map.put(8, "\u8ba1\u91cf\u5355\u4f4d");
        map.put(9, "\u63cf\u8ff0");
        return (String)map.get(key);
    }

    public List<ErpMaterialVo> getCodeAndIdList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List resList = JsonUtil.getJsonToList((Object)list, ErpMaterialVo.class);
            for (ErpMaterialVo vo : resList) {
                ErpMaterialTypeEntity typeInfo = this.erpMaterialTypeService.getInfo(vo.getMaterialTypeId());
                vo.setPropertiesName(this.baseDataUtil.getDictName(vo.getProperties(), "materialProperties"));
                vo.setMaterialTypeName(typeInfo.getFullName());
            }
            return resList;
        }
        return null;
    }
}

