/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.erp.entity.ErpMaterialTypeEntity;
import com.bringspring.erp.mapper.ErpMaterialTypeMapper;
import com.bringspring.erp.model.ofmaterialtype.ErpMaterialTypeInfoVO;
import com.bringspring.erp.model.ofmaterialtype.ErpMaterialTypePagination;
import com.bringspring.erp.service.ErpMaterialTypeService;
import com.bringspring.erp.util.DeleteMarkEnum;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ErpMaterialTypeServiceImpl
extends ServiceImpl<ErpMaterialTypeMapper, ErpMaterialTypeEntity>
implements ErpMaterialTypeService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<ErpMaterialTypeEntity> getList(ErpMaterialTypePagination ofmaterialtypePagination) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofmaterialtypeNum = 0;
        QueryWrapper ofmaterialtypeQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ofmaterialtypePagination.getKeyword())) {
            ++ofmaterialtypeNum;
            ((LambdaQueryWrapper)((LambdaQueryWrapper)ofmaterialtypeQueryWrapper.lambda().like(ErpMaterialTypeEntity::getFullName, (Object)ofmaterialtypePagination.getKeyword())).or()).like(ErpMaterialTypeEntity::getCode, (Object)ofmaterialtypePagination.getKeyword());
        }
        if (!userInfo.getIsAdministrator().booleanValue()) {
            ofmaterialtypeQueryWrapper.lambda().eq(ErpMaterialTypeEntity::getCompanyId, (Object)userInfo.getOrganizeId());
        }
        if (StringUtils.isNotEmpty((String)ofmaterialtypePagination.getParentId())) {
            ++ofmaterialtypeNum;
            ofmaterialtypeQueryWrapper.lambda().eq(ErpMaterialTypeEntity::getParentId, (Object)ofmaterialtypePagination.getParentId());
        }
        if (StringUtils.isNotEmpty((String)ofmaterialtypePagination.getDeleteMark())) {
            ++ofmaterialtypeNum;
            ofmaterialtypeQueryWrapper.lambda().eq(ErpMaterialTypeEntity::getDeleteMark, (Object)ofmaterialtypePagination.getDeleteMark());
        }
        if (AllIdList.size() > 0) {
            ofmaterialtypeQueryWrapper.lambda().in(ErpMaterialTypeEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ofmaterialtypePagination.getSidx())) {
            ofmaterialtypeQueryWrapper.lambda().orderByAsc(ErpMaterialTypeEntity::getSortCode);
        } else {
            Field[] allFields;
            String sidx = ofmaterialtypePagination.getSidx();
            ErpMaterialTypeEntity ErpMaterialTypeEntity2 = new ErpMaterialTypeEntity();
            for (Field allField : allFields = ReflectUtil.getFields(ErpMaterialTypeEntity2.getClass())) {
                if (!sidx.equals(allField.getName())) continue;
                Field declaredField = allField;
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ofmaterialtypeQueryWrapper = "asc".equals(ofmaterialtypePagination.getSort().toLowerCase()) ? (QueryWrapper)ofmaterialtypeQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ofmaterialtypeQueryWrapper.orderByDesc((Object)value);
                break;
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ofmaterialtypePagination.getCurrentPage(), ofmaterialtypePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ofmaterialtypeQueryWrapper);
            return ofmaterialtypePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ofmaterialtypePagination.setData(list, list.size());
    }

    @Override
    public List<ErpMaterialTypeEntity> getTypeList(ErpMaterialTypePagination ofmaterialtypePagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofmaterialtypeNum = 0;
        QueryWrapper ofmaterialtypeQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ofmaterialtypePagination.getFullName())) {
            ++ofmaterialtypeNum;
            ofmaterialtypeQueryWrapper.lambda().like(ErpMaterialTypeEntity::getFullName, (Object)ofmaterialtypePagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)ofmaterialtypePagination.getDeleteMark())) {
            ++ofmaterialtypeNum;
            ofmaterialtypeQueryWrapper.lambda().eq(ErpMaterialTypeEntity::getDeleteMark, (Object)ofmaterialtypePagination.getDeleteMark());
        }
        if (AllIdList.size() > 0) {
            ofmaterialtypeQueryWrapper.lambda().in(ErpMaterialTypeEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ofmaterialtypePagination.getSidx())) {
            ofmaterialtypeQueryWrapper.lambda().orderByAsc(ErpMaterialTypeEntity::getSortCode);
        } else {
            Field[] allFields;
            String sidx = ofmaterialtypePagination.getSidx();
            ErpMaterialTypeEntity ErpMaterialTypeEntity2 = new ErpMaterialTypeEntity();
            for (Field allField : allFields = ReflectUtil.getFields(ErpMaterialTypeEntity2.getClass())) {
                if (!sidx.equals(allField.getName())) continue;
                Field declaredField = allField;
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ofmaterialtypeQueryWrapper = "asc".equals(ofmaterialtypePagination.getSort().toLowerCase()) ? (QueryWrapper)ofmaterialtypeQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ofmaterialtypeQueryWrapper.orderByDesc((Object)value);
                break;
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ofmaterialtypePagination.getCurrentPage(), ofmaterialtypePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ofmaterialtypeQueryWrapper);
                return ofmaterialtypePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ofmaterialtypePagination.setData(list, list.size());
        }
        return this.list((Wrapper)ofmaterialtypeQueryWrapper);
    }

    @Override
    public List<ErpMaterialTypeEntity> getListByParentId(String parentId) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpMaterialTypeEntity::getParentId, (Object)parentId);
        queryWrapper.lambda().eq(ErpMaterialTypeEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.lambda().orderByAsc(ErpMaterialTypeEntity::getSortCode);
        if (!userInfo.getIsAdministrator().booleanValue()) {
            queryWrapper.lambda().eq(ErpMaterialTypeEntity::getCompanyId, (Object)userInfo.getOrganizeId());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ErpMaterialTypeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpMaterialTypeEntity::getId, (Object)id);
        return (ErpMaterialTypeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(ErpMaterialTypeEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, ErpMaterialTypeEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(ErpMaterialTypeEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<ErpMaterialTypeInfoVO> getListTree(String parentId) {
        List<ErpMaterialTypeEntity> list = this.getListByParentId(parentId);
        if (!CollectionUtils.isEmpty(list)) {
            List listVO = JsonUtil.getJsonToList(list, ErpMaterialTypeInfoVO.class);
            this.recursionTree(listVO);
            return listVO;
        }
        return null;
    }

    public void recursionTree(List<ErpMaterialTypeInfoVO> returnList) {
        returnList.stream().forEach(item -> {
            List<ErpMaterialTypeEntity> listChild = this.getListByParentId(item.getId());
            if (ObjectUtil.isEmpty(listChild)) {
                return;
            }
            List listVO = JsonUtil.getJsonToList(listChild, ErpMaterialTypeInfoVO.class);
            item.setChildren(listVO);
            this.recursionTree(listVO);
        });
    }

    @Override
    public boolean checkCodeUnique(ErpMaterialTypeEntity entity) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ErpMaterialTypeEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.eq(ErpMaterialTypeEntity::getCode, (Object)entity.getCode());
        queryWrapper.last("limit 1");
        ErpMaterialTypeEntity info = (ErpMaterialTypeEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)info) || info.getId().equals(entity.getId());
    }

    @Override
    public boolean checkNameUnique(ErpMaterialTypeEntity entity) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ErpMaterialTypeEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.eq(ErpMaterialTypeEntity::getFullName, (Object)entity.getFullName());
        queryWrapper.last("limit 1");
        ErpMaterialTypeEntity info = (ErpMaterialTypeEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)info) || info.getId().equals(entity.getId());
    }

    @Override
    public long selectTypeCount(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpMaterialTypeEntity::getParentId, (Object)parentId);
        return this.count((Wrapper)queryWrapper);
    }
}

