/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.erp.entity.ErpConsumingApplyEntity;
import com.bringspring.erp.entity.ErpConsumingDetailEntity;
import com.bringspring.erp.entity.ErpEntrepotEntity;
import com.bringspring.erp.entity.ErpOutboundEntity;
import com.bringspring.erp.entity.ErpStorageRecordsEntity;
import com.bringspring.erp.entity.ErpWarehouseEntity;
import com.bringspring.erp.mapper.ErpWarehouseMapper;
import com.bringspring.erp.model.erpWarehouse.ErpWarehouseDetailListVO;
import com.bringspring.erp.model.erpWarehouse.ErpWarehousePagination;
import com.bringspring.erp.model.erpoutbound.ErpOutboundCrForm;
import com.bringspring.erp.service.ErpConsumingApplyService;
import com.bringspring.erp.service.ErpConsumingDetailService;
import com.bringspring.erp.service.ErpEntrepotService;
import com.bringspring.erp.service.ErpOutboundService;
import com.bringspring.erp.service.ErpStorageRecordsService;
import com.bringspring.erp.service.ErpWarehouseService;
import com.bringspring.erp.util.Constants;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpWarehouseServiceImpl
extends ServiceImpl<ErpWarehouseMapper, ErpWarehouseEntity>
implements ErpWarehouseService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ErpEntrepotService erpEntrepotService;
    @Autowired
    private ErpOutboundService erpOutboundService;
    @Autowired
    private ErpStorageRecordsService erpStorageRecordsService;
    @Autowired
    private ErpWarehouseMapper erpWarehouseMapper;
    @Autowired
    private ErpConsumingApplyService erpConsumingApplyService;
    @Autowired
    private ErpConsumingDetailService erpConsumingDetailService;

    @Override
    public List<ErpWarehouseEntity> getList(ErpWarehousePagination erpWarehousePagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int erpWarehouseNum = 0;
        QueryWrapper erpWarehouseQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)erpWarehousePagination.getCompanyId())) {
            ++erpWarehouseNum;
            erpWarehouseQueryWrapper.lambda().like(ErpWarehouseEntity::getCompanyId, (Object)erpWarehousePagination.getCompanyId());
        }
        if (StringUtil.isNotEmpty((String)erpWarehousePagination.getWarehouseId())) {
            ++erpWarehouseNum;
            erpWarehouseQueryWrapper.lambda().like(ErpWarehouseEntity::getWarehouseId, (Object)erpWarehousePagination.getWarehouseId());
        }
        if (StringUtil.isNotEmpty((String)erpWarehousePagination.getMaterialCode())) {
            ++erpWarehouseNum;
            erpWarehouseQueryWrapper.lambda().like(ErpWarehouseEntity::getMaterialCode, (Object)erpWarehousePagination.getMaterialCode());
        }
        if (AllIdList.size() > 0) {
            erpWarehouseQueryWrapper.lambda().in(ErpWarehouseEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)erpWarehousePagination.getSidx())) {
            erpWarehouseQueryWrapper.lambda().orderByDesc(ErpWarehouseEntity::getId);
        } else {
            try {
                String sidx = erpWarehousePagination.getSidx();
                ErpWarehouseEntity erpWarehouseEntity = new ErpWarehouseEntity();
                Field declaredField = erpWarehouseEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                erpWarehouseQueryWrapper = "asc".equals(erpWarehousePagination.getSort().toLowerCase()) ? (QueryWrapper)erpWarehouseQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)erpWarehouseQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(erpWarehousePagination.getCurrentPage(), erpWarehousePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)erpWarehouseQueryWrapper);
            return erpWarehousePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return erpWarehousePagination.setData(list, list.size());
    }

    @Override
    public List getListAllInfo(ErpWarehouseDetailListVO erpWarehousePagination) {
        PageHelper.startPage((int)((int)erpWarehousePagination.getCurrentPage()), (int)((int)erpWarehousePagination.getPageSize()));
        List<ErpWarehouseDetailListVO> warehouseComprehensiveInfo = ((ErpWarehouseMapper)this.baseMapper).getWarehouseComprehensiveInfo(erpWarehousePagination);
        PageInfo pageInfo = new PageInfo(warehouseComprehensiveInfo);
        return erpWarehousePagination.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public List<ErpWarehouseEntity> getTypeList(ErpWarehousePagination erpWarehousePagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int erpWarehouseNum = 0;
        QueryWrapper erpWarehouseQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)erpWarehousePagination.getCompanyId())) {
            ++erpWarehouseNum;
            erpWarehouseQueryWrapper.lambda().like(ErpWarehouseEntity::getCompanyId, (Object)erpWarehousePagination.getCompanyId());
        }
        if (StringUtil.isNotEmpty((String)erpWarehousePagination.getWarehouseId())) {
            ++erpWarehouseNum;
            erpWarehouseQueryWrapper.lambda().like(ErpWarehouseEntity::getWarehouseId, (Object)erpWarehousePagination.getWarehouseId());
        }
        if (StringUtil.isNotEmpty((String)erpWarehousePagination.getMaterialCode())) {
            ++erpWarehouseNum;
            erpWarehouseQueryWrapper.lambda().like(ErpWarehouseEntity::getMaterialCode, (Object)erpWarehousePagination.getMaterialCode());
        }
        if (AllIdList.size() > 0) {
            erpWarehouseQueryWrapper.lambda().in(ErpWarehouseEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)erpWarehousePagination.getSidx())) {
            erpWarehouseQueryWrapper.lambda().orderByDesc(ErpWarehouseEntity::getId);
        } else {
            try {
                String sidx = erpWarehousePagination.getSidx();
                ErpWarehouseEntity erpWarehouseEntity = new ErpWarehouseEntity();
                Field declaredField = erpWarehouseEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                erpWarehouseQueryWrapper = "asc".equals(erpWarehousePagination.getSort().toLowerCase()) ? (QueryWrapper)erpWarehouseQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)erpWarehouseQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(erpWarehousePagination.getCurrentPage(), erpWarehousePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)erpWarehouseQueryWrapper);
                return erpWarehousePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return erpWarehousePagination.setData(list, list.size());
        }
        return this.list((Wrapper)erpWarehouseQueryWrapper);
    }

    @Override
    public ErpWarehouseEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpWarehouseEntity::getId, (Object)id);
        return (ErpWarehouseEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public ErpWarehouseEntity getInfoByWarehouseIdAndMaterialCode(String warehouseId, String materialCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ErpWarehouseEntity::getWarehouseId, (Object)warehouseId)).eq(ErpWarehouseEntity::getMaterialCode, (Object)materialCode);
        return (ErpWarehouseEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<ErpWarehouseEntity> getListByWarehouseId(String warehouseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpWarehouseEntity::getWarehouseId, (Object)warehouseId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(ErpWarehouseEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, ErpWarehouseEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<ErpWarehouseEntity> getListByMateriaCode(String materiaCode, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpWarehouseEntity::getMaterialCode, (Object)materiaCode);
        if (!StrUtil.isBlank((CharSequence)companyId)) {
            queryWrapper.lambda().eq(ErpWarehouseEntity::getCompanyId, (Object)companyId);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean computePriceAtAddStorage(ErpStorageRecordsEntity recordsEntity) {
        ErpWarehouseEntity warehouseEntity = (ErpWarehouseEntity)JsonUtil.getJsonToBean((Object)recordsEntity, ErpWarehouseEntity.class);
        List<ErpWarehouseEntity> listByMateriaCode = ((ErpWarehouseMapper)this.baseMapper).getListByMateriaCode(warehouseEntity);
        if (StrUtil.isNotEmpty((CharSequence)recordsEntity.getPricingScheme()) && StrUtil.equals((CharSequence)"individualPricing", (CharSequence)recordsEntity.getPricingScheme())) {
            listByMateriaCode = new ArrayList<ErpWarehouseEntity>();
        }
        ErpEntrepotEntity code = this.erpEntrepotService.getCode(recordsEntity.getWarehouseId());
        Boolean flag = code.getEntrepotType().equals(Constants.STEP_ENTREPOT);
        BigDecimal bigDecimal = recordsEntity.getPrice().multiply(new BigDecimal(recordsEntity.getAmount()));
        Integer amount = recordsEntity.getAmount();
        BigDecimal averagePrice = new BigDecimal(0.0);
        if (!listByMateriaCode.isEmpty() && !flag.booleanValue()) {
            for (ErpWarehouseEntity erpWarehouseEntity : listByMateriaCode) {
                bigDecimal = bigDecimal.add(erpWarehouseEntity.getPrice().multiply(new BigDecimal(erpWarehouseEntity.getAmount())));
                amount = amount + erpWarehouseEntity.getAmount();
            }
            averagePrice = bigDecimal.divide(new BigDecimal(amount), 2, RoundingMode.HALF_UP);
        } else {
            averagePrice = recordsEntity.getPrice();
        }
        if (!listByMateriaCode.isEmpty() && !flag.booleanValue()) {
            List collect = listByMateriaCode.stream().filter(item -> item.getWarehouseId().equals(recordsEntity.getWarehouseId())).collect(Collectors.toList());
            if (ObjectUtil.isEmpty(collect)) {
                warehouseEntity.setId(RandomUtil.uuId());
                warehouseEntity.setVersion(1);
                warehouseEntity.setPrice(averagePrice);
                this.save(warehouseEntity);
            }
            for (ErpWarehouseEntity erpWarehouseEntity : listByMateriaCode) {
                erpWarehouseEntity.setPrice(averagePrice);
                if (erpWarehouseEntity.getWarehouseId().equals(recordsEntity.getWarehouseId())) {
                    erpWarehouseEntity.setAmount(erpWarehouseEntity.getAmount() + recordsEntity.getAmount());
                }
                erpWarehouseEntity.setVersion(erpWarehouseEntity.getVersion() + 1);
                ((ErpWarehouseMapper)this.baseMapper).updateById(erpWarehouseEntity);
            }
            listByMateriaCode.stream().filter(item -> item.getMaterialCode().equals(recordsEntity.getMaterialCode())).collect(Collectors.toList());
            return true;
        }
        ErpWarehouseEntity jsonToBean = (ErpWarehouseEntity)JsonUtil.getJsonToBean((Object)recordsEntity, ErpWarehouseEntity.class);
        jsonToBean.setVersion(1);
        this.save(jsonToBean);
        return true;
    }

    @Override
    public Boolean checkVersion(String id, Integer version) {
        ErpWarehouseEntity erpWarehouseEntity = (ErpWarehouseEntity)((ErpWarehouseMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (erpWarehouseEntity.getVersion() == version) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean warehouseAllocation(String id, ErpOutboundCrForm erpOutboundCrForm) {
        Boolean flag = this.checkVersion(id, erpOutboundCrForm.getVersion());
        ErpWarehouseEntity erpWarehouseEntity = (ErpWarehouseEntity)((ErpWarehouseMapper)this.baseMapper).selectById((Serializable)((Object)id));
        ErpWarehouseEntity oldWarehouseEntity = this.getInfo(id);
        if (flag.booleanValue() || !flag.booleanValue() && erpWarehouseEntity.getAmount() - erpOutboundCrForm.getAmount() >= 0) {
            ErpConsumingApplyEntity consumingApplyEntity;
            erpWarehouseEntity.setAmount(erpWarehouseEntity.getAmount() - erpOutboundCrForm.getAmount());
            erpWarehouseEntity.setVersion(erpWarehouseEntity.getVersion() + 1);
            ((ErpWarehouseMapper)this.baseMapper).updateById(erpWarehouseEntity);
            ErpOutboundEntity OutboundEntity = (ErpOutboundEntity)JsonUtil.getJsonToBean((Object)erpOutboundCrForm, ErpOutboundEntity.class);
            OutboundEntity.setBatch(erpOutboundCrForm.getBatch());
            OutboundEntity.setApplyCode(erpOutboundCrForm.getPutStorageApplyCode());
            boolean save = this.erpOutboundService.save(OutboundEntity);
            ErpStorageRecordsEntity recordsEntity = (ErpStorageRecordsEntity)JsonUtil.getJsonToBean((Object)erpOutboundCrForm, ErpStorageRecordsEntity.class);
            recordsEntity.setWarehouseId(erpOutboundCrForm.getWarehouseIdOut());
            recordsEntity.setAmount(~(erpOutboundCrForm.getAmount() - 1));
            recordsEntity.setApplyCode(erpOutboundCrForm.getPutStorageApplyCode());
            recordsEntity.setBatch(erpOutboundCrForm.getBatch());
            recordsEntity.setErpStorageRecordsId(erpOutboundCrForm.getErpStorageRecordsId());
            recordsEntity.setConsumingId(erpOutboundCrForm.getConsumingId());
            if (StringUtil.isNotEmpty((String)erpOutboundCrForm.getConsumingId()) && ObjectUtil.isNotEmpty((Object)(consumingApplyEntity = this.erpConsumingApplyService.getInfo(erpOutboundCrForm.getConsumingId())))) {
                recordsEntity.setContractId(consumingApplyEntity.getContractId());
            }
            ArrayList<ErpStorageRecordsEntity> objects = new ArrayList<ErpStorageRecordsEntity>();
            objects.add(recordsEntity);
            if (erpOutboundCrForm.getType().equals(Constants.ALLOCATION)) {
                ErpStorageRecordsEntity storageRecordsEntity = (ErpStorageRecordsEntity)ObjectUtil.clone((Object)recordsEntity);
                String mainId = RandomUtil.uuId();
                storageRecordsEntity.setId(mainId);
                storageRecordsEntity.setWarehouseId(erpOutboundCrForm.getWarehouseIdEnter());
                storageRecordsEntity.setAmount(erpOutboundCrForm.getAmount());
                storageRecordsEntity.setApplyCode(erpOutboundCrForm.getPutStorageApplyCode());
                storageRecordsEntity.setBatch(erpOutboundCrForm.getBatch());
                storageRecordsEntity.setErpStorageRecordsId(erpOutboundCrForm.getErpStorageRecordsId());
                objects.add(storageRecordsEntity);
            }
            this.erpStorageRecordsService.saveBatch(objects);
            if (erpOutboundCrForm.getType().equals(Constants.ALLOCATION)) {
                ErpWarehouseEntity warehouseEntity = this.getInfoByWarehouseIdAndMaterialCode(erpOutboundCrForm.getWarehouseIdEnter(), erpOutboundCrForm.getMaterialCode());
                ErpEntrepotEntity entrepotEntity = this.erpEntrepotService.getInfo(erpOutboundCrForm.getWarehouseIdEnter());
                if (ObjectUtil.isEmpty((Object)warehouseEntity)) {
                    oldWarehouseEntity.setId(RandomUtil.uuId());
                    oldWarehouseEntity.setWarehouseId(erpOutboundCrForm.getWarehouseIdEnter());
                    oldWarehouseEntity.setAmount(erpOutboundCrForm.getAmount());
                    oldWarehouseEntity.setVersion(1);
                    this.save(oldWarehouseEntity);
                } else {
                    warehouseEntity.setAmount(warehouseEntity.getAmount() + erpOutboundCrForm.getAmount());
                    warehouseEntity.setVersion(warehouseEntity.getVersion() + 1);
                    this.updateById(warehouseEntity);
                }
            }
            if (erpOutboundCrForm.getType().equals(Constants.SALE_OUT_STORAGE)) {
                ErpConsumingApplyEntity consumingApplyEntity2 = this.erpConsumingApplyService.getInfo(erpOutboundCrForm.getConsumingId());
                List<ErpConsumingDetailEntity> listByApplyId = this.erpConsumingDetailService.getListByApplyId(erpOutboundCrForm.getConsumingId());
                List erpDetailEntityList = listByApplyId.stream().filter(i -> i.getMaterialCode().equals(erpOutboundCrForm.getMaterialCode())).collect(Collectors.toList());
                Boolean statusFlag = false;
                if (!erpDetailEntityList.isEmpty()) {
                    for (ErpConsumingDetailEntity erpConsumingDetailEntity : erpDetailEntityList) {
                        int noOut = erpConsumingDetailEntity.getNotOut() - erpOutboundCrForm.getAmount();
                        int aleardyOut = erpConsumingDetailEntity.getAleardyOut() + erpOutboundCrForm.getAmount();
                        if (!erpConsumingDetailEntity.getMaterialCode().equals(erpOutboundCrForm.getMaterialCode())) continue;
                        erpConsumingDetailEntity.setAleardyOut(aleardyOut);
                        erpConsumingDetailEntity.setNotOut(noOut);
                        if (noOut != 0 || aleardyOut != erpConsumingDetailEntity.getAmount()) continue;
                        statusFlag = true;
                    }
                    this.erpConsumingDetailService.updateBatchById(erpDetailEntityList);
                    List erpConsumingDetailEntityList = listByApplyId.stream().filter(i -> !i.getMaterialCode().equals(erpOutboundCrForm.getMaterialCode())).collect(Collectors.toList());
                    for (ErpConsumingDetailEntity erpConsumingDetailEntity : erpConsumingDetailEntityList) {
                        if (erpConsumingDetailEntity.getNotOut() == 0) continue;
                        statusFlag = false;
                    }
                    if (statusFlag.booleanValue()) {
                        consumingApplyEntity2.setStatus(Constants.ALL_OUT);
                    } else {
                        consumingApplyEntity2.setStatus(Constants.SOME_OUT);
                    }
                    this.erpConsumingApplyService.update(consumingApplyEntity2.getId(), consumingApplyEntity2);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void delete(ErpWarehouseEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

