/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.example.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.example.entity.ContractEntity;
import com.bringspring.example.mapper.ContractMapper;
import com.bringspring.example.service.ContractService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractServiceImpl
extends ServiceImpl<ContractMapper, ContractEntity>
implements ContractService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ContractEntity> getlist(Pagination pagination) {
        UserInfo userProvider = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtil.isEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(ContractEntity::getContractName, (Object)pagination.getKeyword())).or()).like(ContractEntity::getMytelePhone, (Object)pagination.getKeyword());
            });
        }
        if (!StringUtil.isEmpty((String)pagination.getSidx())) {
            queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)pagination.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)pagination.getSidx());
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public ContractEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ContractEntity::getId, (Object)id);
        return (ContractEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(ContractEntity entity) {
        entity.setId(RandomUtil.uuId());
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, ContractEntity entity) {
        entity.setId(id);
        this.updateById(entity);
    }

    @Override
    public void delete(ContractEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

