/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.example.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.example.entity.ContractEntity;
import com.bringspring.example.model.ContractForm;
import com.bringspring.example.model.ContractInfoVO;
import com.bringspring.example.model.ContractListVO;
import com.bringspring.example.service.ContractService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Contract"})
public class ContractController {
    @Autowired
    private ContractService contractService;

    @GetMapping(value={"/List"})
    public ActionResult list(Pagination pagination) {
        List<ContractEntity> entity = this.contractService.getlist(pagination);
        List listVo = JsonUtil.getJsonToList((String)JsonUtil.getObjectToStringDateFormat(entity, (String)"yyyy-MM-dd HH:mm:ss"), ContractListVO.class);
        PaginationVO vo = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)listVo, (PaginationVO)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id) {
        ContractEntity entity = this.contractService.getInfo(id);
        ContractInfoVO vo = (ContractInfoVO)JsonUtil.getJsonToBean((Object)entity, ContractInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid ContractForm contractForm) {
        ContractEntity entity = (ContractEntity)JsonUtil.getJsonToBean((Object)contractForm, ContractEntity.class);
        this.contractService.create(entity);
        return ActionResult.success((String)MsgCode.SU002.get());
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ContractForm contractForm) {
        ContractEntity entity = (ContractEntity)JsonUtil.getJsonToBean((Object)contractForm, ContractEntity.class);
        this.contractService.update(id, entity);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ContractEntity entity = this.contractService.getInfo(id);
        this.contractService.delete(entity);
        return ActionResult.success((String)MsgCode.SU003.get());
    }
}

