/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.example.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.example.entity.ExtWorklogEntity;
import com.bringspring.example.model.extworklog.ExtWorklogCrForm;
import com.bringspring.example.model.extworklog.ExtWorklogInfoVO;
import com.bringspring.example.model.extworklog.ExtWorklogListVO;
import com.bringspring.example.model.extworklog.ExtWorklogPagination;
import com.bringspring.example.model.extworklog.ExtWorklogUpForm;
import com.bringspring.example.service.ExtWorklogService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5de5\u4f5c\u65e5\u5fd7"}, value="example")
@RequestMapping(value={"/api/example/ExtWorklog"})
public class ExtWorklogController {
    private static final Logger log = LoggerFactory.getLogger(ExtWorklogController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ExtWorklogService extWorklogService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody ExtWorklogPagination extWorklogPagination) throws IOException {
        List<ExtWorklogEntity> list = this.extWorklogService.getList(extWorklogPagination);
        for (ExtWorklogEntity extWorklogEntity : list) {
            extWorklogEntity.setTodaycontent(this.baseDataUtil.getDictName(extWorklogEntity.getTodaycontent(), "567706785801127685"));
        }
        List listVO = JsonUtil.getJsonToList(list, ExtWorklogListVO.class);
        for (ExtWorklogListVO extWorklogListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)extWorklogPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid ExtWorklogCrForm extWorklogCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        ExtWorklogEntity entity = (ExtWorklogEntity)JsonUtil.getJsonToBean((Object)extWorklogCrForm, ExtWorklogEntity.class);
        entity.setId(mainId);
        this.extWorklogService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ExtWorklogInfoVO> info(@PathVariable(value="id") String id) {
        ExtWorklogEntity entity = this.extWorklogService.getInfo(id);
        ExtWorklogInfoVO vo = (ExtWorklogInfoVO)JsonUtil.getJsonToBean((Object)entity, ExtWorklogInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<ExtWorklogInfoVO> detailInfo(@PathVariable(value="id") String id) {
        ExtWorklogEntity entity = this.extWorklogService.getInfo(id);
        ExtWorklogInfoVO vo = (ExtWorklogInfoVO)JsonUtil.getJsonToBean((Object)entity, ExtWorklogInfoVO.class);
        vo.setTodaycontent(this.baseDataUtil.getDictName(vo.getTodaycontent(), "567706785801127685"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ExtWorklogUpForm extWorklogUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        ExtWorklogEntity entity = this.extWorklogService.getInfo(id);
        if (entity != null) {
            ExtWorklogEntity subentity = (ExtWorklogEntity)JsonUtil.getJsonToBean((Object)extWorklogUpForm, ExtWorklogEntity.class);
            this.extWorklogService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        ExtWorklogEntity entity = this.extWorklogService.getInfo(id);
        if (entity != null) {
            this.extWorklogService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

