/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.example.license;

import com.bringspring.common.license.license.CustomLicenseManager;
import com.bringspring.common.license.license.model.CustomKeyStoreParam;
import com.bringspring.example.license.LicenseCreatorParam;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseParam;
import java.io.File;
import java.text.MessageFormat;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseCreator {
    private static final Logger log = LoggerFactory.getLogger(LicenseCreator.class);
    private static final X500Principal DEFAULT_HOLDER_AND_ISSUER = new X500Principal("CN=RJHQ, OU=BringSpring, O=development, L=ZZ, ST=HN, C=CN");
    private LicenseCreatorParam param;

    public LicenseCreator(LicenseCreatorParam param) {
        this.param = param;
    }

    public boolean generateLicense() {
        try {
            CustomLicenseManager licenseManager = new CustomLicenseManager(this.initLicenseParam());
            LicenseContent licenseContent = this.initLicenseContent();
            licenseManager.store(licenseContent, new File(this.param.getLicensePath()));
            log.debug("\u8bc1\u4e66\u751f\u6210\u6210\u529f\uff01");
            return true;
        }
        catch (Exception e) {
            log.error(MessageFormat.format("\u8bc1\u4e66\u751f\u6210\u5931\u8d25\uff1a{0}", this.param), (Throwable)e);
            return false;
        }
    }

    private LicenseParam initLicenseParam() {
        Preferences preferences = Preferences.userNodeForPackage(LicenseCreator.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(this.param.getStorePass());
        CustomKeyStoreParam privateStoreParam = new CustomKeyStoreParam(LicenseCreator.class, this.param.getPrivateKeysStorePath(), this.param.getPrivateAlias(), this.param.getStorePass(), this.param.getKeyPass());
        DefaultLicenseParam licenseParam = new DefaultLicenseParam(this.param.getSubject(), preferences, (KeyStoreParam)privateStoreParam, (CipherParam)cipherParam);
        return licenseParam;
    }

    private LicenseContent initLicenseContent() {
        LicenseContent licenseContent = new LicenseContent();
        licenseContent.setHolder(DEFAULT_HOLDER_AND_ISSUER);
        licenseContent.setIssuer(DEFAULT_HOLDER_AND_ISSUER);
        licenseContent.setSubject(this.param.getSubject());
        licenseContent.setIssued(this.param.getIssuedTime());
        licenseContent.setNotBefore(this.param.getIssuedTime());
        licenseContent.setNotAfter(this.param.getExpiryTime());
        licenseContent.setConsumerType(this.param.getConsumerType());
        licenseContent.setConsumerAmount(this.param.getConsumerAmount().intValue());
        licenseContent.setInfo(this.param.getDescription());
        licenseContent.setExtra((Object)this.param.getLicenseCode());
        return licenseContent;
    }
}

