package com.bringspring.example.license;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.license.license.model.LicenseCheckModel;
import com.bringspring.common.license.utils.AbstractServerInfo;
import com.bringspring.common.license.utils.LinuxServerInfo;
import com.bringspring.common.license.utils.WindowsServerInfo;
import com.bringspring.common.util.Md5Util;
import lombok.extern.slf4j.Slf4j;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * @desc
 *
 * @author huangchen@deepglint.com
 * 
 * @date 2019/3/14 13:55
 */
@Slf4j
public class LicenseTest {
    /**
     * test 获取客户机信息
     */
    public static void main3(String[] args) {
        String osName = System.getProperty("os.name").toLowerCase();
        AbstractServerInfo abstractServerInfo;
        //根据不同操作系统类型选择不同的数据获取方法
        if (osName.startsWith("windows")) {
            abstractServerInfo = new WindowsServerInfo();
        } else if (osName.startsWith("linux")) {
            abstractServerInfo = new LinuxServerInfo();
        }else{//其他服务器类型
            abstractServerInfo = new LinuxServerInfo();
        }

        log.debug("客户机信息：{}", JSONObject.toJSONString(LicenseCheckModel.installServerInfo(abstractServerInfo)));
        log.debug("客户机机器码：{}", Md5Util.getStringMd5(JSONObject.toJSONString(LicenseCheckModel.installServerInfo(abstractServerInfo))));
    }

    /**
     * test 生成授权
     */
    public static void main(String[] args) {
        LicenseCreatorParam param = new LicenseCreatorParam();
        param.setSubject("jsbos");
        param.setPrivateAlias("jsbos");
        param.setKeyPass("RongKe@888");
        param.setStorePass("RongKe@888");
        param.setLicensePath("D:/License/license.lic");
        param.setPrivateKeysStorePath("jsbos_private.keystore");
        param.setDescription("朱俊杰开发环境");
        try {
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            param.setIssuedTime(dateFormat.parse("2019-03-13 00:00:01"));
            param.setExpiryTime(dateFormat.parse("2024-03-16 15:30:00"));
        } catch (ParseException e) { e.printStackTrace();}

        param.setLicenseCode("bba0e4964910551a88b2d1a450d51ba0");
        LicenseCreator licenseCreator = new LicenseCreator(param);
        licenseCreator.generateLicense();
    }
}
