package com.bringspring.example.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.*;

/**
 *
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WorkitemEnableMarkEnum {

    Submit("submited","已提交"),Accepted("accepted","已受理") ;
    /**
     *  submited：已提交  accepted：已受理  70：已执行  complated：已完成
     */
    private String value;
    private String name;
    @JsonValue
    public String getValue() {
        return value;
    }
    @JsonValue
    public String getName() {
        return name;
    }

    WorkitemEnableMarkEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }
    public static HashMap<String,String> getEnumMap() {
        HashMap<String, String> map = new HashMap<>();
        for (WorkitemEnableMarkEnum testEnum : EnumSet.allOf(WorkitemEnableMarkEnum.class)) {
            map.put(testEnum.value, testEnum.name);
        }
        return map;
    }
    public static List<HashMap<String,String>> getEnumList() {
        List<HashMap<String, String>> list = new ArrayList<>();
        for (WorkitemEnableMarkEnum testEnum : EnumSet.allOf(WorkitemEnableMarkEnum.class)) {
            String s = testEnum.getClass().getProtectionDomain().toString();
            HashMap<String, String> map = new HashMap<>();
            map.put("code",testEnum.value);
            map.put("name",testEnum.name);
            list.add(map);
        }
        return list;
    }
    public static void main(String[] args) {
        String s = JSONObject.toJSONString(WorkitemEnableMarkEnum.getEnumList());
    }
}
