/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.example.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.example.entity.ContractEntity;
import com.bringspring.example.model.ContractForm;
import com.bringspring.example.model.ContractInfoVO;
import com.bringspring.example.model.ContractListVO;
import com.bringspring.example.service.ContractService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5408\u540c\u7ba1\u7406", description="\u5408\u540c\u4fe1\u606f\u7684\u589e\u5220\u6539\u67e5\u64cd\u4f5c")
@RestController
@RequestMapping(value={"/Contract"})
public class ContractController {
    @Autowired
    private ContractService contractService;

    @Operation(summary="\u83b7\u53d6\u5408\u540c\u5217\u8868", description="\u5206\u9875\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5217\u8868")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u6210\u529f\u83b7\u53d6\u5408\u540c\u5217\u8868"), @ApiResponse(responseCode="400", description="\u53c2\u6570\u9519\u8bef"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @GetMapping(value={"/List"})
    public ActionResult list(@Parameter(description="\u5206\u9875\u53c2\u6570") Pagination pagination) {
        List<ContractEntity> entity = this.contractService.getlist(pagination);
        List listVo = JsonUtil.getJsonToList((String)JsonUtil.getObjectToStringDateFormat(entity, (String)"yyyy-MM-dd HH:mm:ss"), ContractListVO.class);
        PaginationVO vo = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)listVo, (PaginationVO)vo);
    }

    @Operation(summary="\u83b7\u53d6\u5408\u540c\u8be6\u60c5", description="\u6839\u636eID\u83b7\u53d6\u5408\u540c\u8be6\u7ec6\u4fe1\u606f")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u6210\u529f\u83b7\u53d6\u5408\u540c\u8be6\u60c5"), @ApiResponse(responseCode="404", description="\u5408\u540c\u4e0d\u5b58\u5728"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @GetMapping(value={"/{id}"})
    public ActionResult info(@Parameter(description="\u5408\u540cID", required=true) @PathVariable(value="id") String id) {
        ContractEntity entity = this.contractService.getInfo(id);
        ContractInfoVO vo = (ContractInfoVO)JsonUtil.getJsonToBean((Object)entity, ContractInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u521b\u5efa\u5408\u540c", description="\u521b\u5efa\u65b0\u7684\u5408\u540c\u4fe1\u606f")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u5408\u540c\u521b\u5efa\u6210\u529f"), @ApiResponse(responseCode="400", description="\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @PostMapping
    public ActionResult create(@Parameter(description="\u5408\u540c\u8868\u5355\u6570\u636e", required=true) @RequestBody @Valid ContractForm contractForm) {
        ContractEntity entity = (ContractEntity)JsonUtil.getJsonToBean((Object)contractForm, ContractEntity.class);
        this.contractService.create(entity);
        return ActionResult.success((String)MsgCode.SU002.get());
    }

    @Operation(summary="\u66f4\u65b0\u5408\u540c", description="\u6839\u636eID\u66f4\u65b0\u5408\u540c\u4fe1\u606f")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u5408\u540c\u66f4\u65b0\u6210\u529f"), @ApiResponse(responseCode="400", description="\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25"), @ApiResponse(responseCode="404", description="\u5408\u540c\u4e0d\u5b58\u5728"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @PutMapping(value={"/{id}"})
    public ActionResult update(@Parameter(description="\u5408\u540cID", required=true) @PathVariable(value="id") String id, @Parameter(description="\u5408\u540c\u8868\u5355\u6570\u636e", required=true) @RequestBody @Valid ContractForm contractForm) {
        ContractEntity entity = (ContractEntity)JsonUtil.getJsonToBean((Object)contractForm, ContractEntity.class);
        this.contractService.update(id, entity);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u5220\u9664\u5408\u540c", description="\u6839\u636eID\u5220\u9664\u5408\u540c\u4fe1\u606f")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u5408\u540c\u5220\u9664\u6210\u529f"), @ApiResponse(responseCode="404", description="\u5408\u540c\u4e0d\u5b58\u5728"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@Parameter(description="\u5408\u540cID", required=true) @PathVariable(value="id") String id) {
        ContractEntity entity = this.contractService.getInfo(id);
        this.contractService.delete(entity);
        return ActionResult.success((String)MsgCode.SU003.get());
    }
}

