/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.MailAccount;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.extend.entity.EmailSendEntity;
import com.bringspring.extend.model.email.EmailCheckForm;
import com.bringspring.extend.model.email.EmailCofigInfoVO;
import com.bringspring.extend.model.email.EmailCrForm;
import com.bringspring.extend.model.email.EmailDraftListVO;
import com.bringspring.extend.model.email.EmailInfoVO;
import com.bringspring.extend.model.email.EmailReceiveListVO;
import com.bringspring.extend.model.email.EmailSendCrForm;
import com.bringspring.extend.model.email.EmailSentListVO;
import com.bringspring.extend.model.email.EmailStarredListVO;
import com.bringspring.extend.model.email.PaginationEmail;
import com.bringspring.extend.service.EmailReceiveService;
import com.bringspring.system.base.entity.EmailConfigEntity;
import com.bringspring.system.base.entity.EmailReceiveEntity;
import com.bringspring.system.base.service.SysconfigService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.base.util.Pop3Util;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u90ae\u4ef6\u6536\u53d1"}, value="Email")
@RestController
@RequestMapping(value={"/api/extend/Email"})
public class EmailController {
    @Autowired
    private EmailReceiveService emailReceiveService;
    @Autowired
    private Pop3Util pop3Util;
    @Autowired
    private SysconfigService sysconfigService;

    @ApiOperation(value="\u83b7\u53d6\u90ae\u4ef6\u5217\u8868(\u6536\u4ef6\u7bb1\u3001\u6807\u661f\u4ef6\u3001\u8349\u7a3f\u7bb1\u3001\u5df2\u53d1\u9001)")
    @GetMapping
    public ActionResult receiveList(PaginationEmail paginationEmail) {
        String type;
        switch (type = paginationEmail.getType() != null ? paginationEmail.getType() : "inBox") {
            case "inBox": {
                List<EmailReceiveEntity> entity = this.emailReceiveService.getReceiveList(paginationEmail);
                PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationEmail), PaginationVO.class);
                List listVO = JsonUtil.getJsonToList(entity, EmailReceiveListVO.class);
                return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
            }
            case "star": {
                List<EmailReceiveEntity> entity1 = this.emailReceiveService.getStarredList(paginationEmail);
                PaginationVO paginationVo1 = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationEmail), PaginationVO.class);
                List listVo1 = JsonUtil.getJsonToList(entity1, EmailStarredListVO.class);
                return ActionResult.page((List)listVo1, (PaginationVO)paginationVo1);
            }
            case "draft": {
                List<EmailSendEntity> entity2 = this.emailReceiveService.getDraftList(paginationEmail);
                PaginationVO paginationVo2 = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationEmail), PaginationVO.class);
                List listVo2 = JsonUtil.getJsonToList(entity2, EmailDraftListVO.class);
                return ActionResult.page((List)listVo2, (PaginationVO)paginationVo2);
            }
            case "sent": {
                List<EmailSendEntity> entity3 = this.emailReceiveService.getSentList(paginationEmail);
                PaginationVO paginationVo3 = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationEmail), PaginationVO.class);
                List listVo3 = JsonUtil.getJsonToList(entity3, EmailSentListVO.class);
                return ActionResult.page((List)listVo3, (PaginationVO)paginationVo3);
            }
        }
        return ActionResult.fail((String)"\u83b7\u53d6\u5931\u8d25");
    }

    @ApiOperation(value="\u83b7\u53d6\u90ae\u7bb1\u914d\u7f6e")
    @GetMapping(value={"/Config"})
    public ActionResult<EmailCofigInfoVO> configInfo() {
        EmailConfigEntity entity = this.emailReceiveService.getConfigInfo();
        EmailCofigInfoVO vo = (EmailCofigInfoVO)JsonUtil.getJsonToBean((Object)entity, EmailCofigInfoVO.class);
        if (vo == null) {
            vo = new EmailCofigInfoVO();
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u90ae\u4ef6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<EmailInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        Object entity = this.emailReceiveService.getInfo(id);
        EmailInfoVO vo = (EmailInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, EmailInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5220\u9664\u90ae\u4ef6")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        boolean flag = this.emailReceiveService.delete(id);
        if (!flag) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25\uff0c\u90ae\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5df2\u8bfb\u90ae\u4ef6")
    @PutMapping(value={"/{id}/Actions/Read"})
    public ActionResult receiveRead(@PathVariable(value="id") String id) {
        boolean flag = this.emailReceiveService.receiveRead(id, 1);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u90ae\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u8bbe\u7f6e\u672a\u8bfb\u90ae\u4ef6")
    @PutMapping(value={"/{id}/Actions/Unread"})
    public ActionResult receiveUnread(@PathVariable(value="id") String id) {
        boolean flag = this.emailReceiveService.receiveRead(id, 0);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u90ae\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u8bbe\u7f6e\u661f\u6807\u90ae\u4ef6")
    @PutMapping(value={"/{id}/Actions/Star"})
    public ActionResult receiveYesStarred(@PathVariable(value="id") String id) {
        boolean flag = this.emailReceiveService.receiveStarred(id, 1);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u90ae\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u8bbe\u7f6e\u53d6\u6d88\u661f\u6807")
    @PutMapping(value={"/{id}/Actions/Unstar"})
    public ActionResult receiveNoStarred(@PathVariable(value="id") String id) {
        boolean flag = this.emailReceiveService.receiveStarred(id, 0);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u90ae\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u6536\u90ae\u4ef6")
    @PostMapping(value={"/Receive"})
    public ActionResult receive() {
        EmailConfigEntity configEntity = this.emailReceiveService.getConfigInfo();
        if (configEntity != null) {
            MailAccount mailAccount = new MailAccount();
            mailAccount.setAccount(configEntity.getAccount());
            mailAccount.setPassword(configEntity.getPassword());
            mailAccount.setPop3Host(configEntity.getPop3Host());
            mailAccount.setPop3Port(configEntity.getPop3Port().intValue());
            mailAccount.setSmtpHost(configEntity.getSmtpHost());
            mailAccount.setSmtpPort(configEntity.getSmtpPort().intValue());
            if ("1".equals(String.valueOf(configEntity.getEmailSsl()))) {
                mailAccount.setSsl(Boolean.valueOf(true));
            } else {
                mailAccount.setSsl(Boolean.valueOf(false));
            }
            String checkResult = this.pop3Util.checkConnected(mailAccount);
            if ("true".equals(checkResult)) {
                int mailCount = this.emailReceiveService.receive(configEntity);
                return ActionResult.success((String)MsgCode.SU005.get(), (Object)mailCount);
            }
            return ActionResult.fail((String)checkResult);
        }
        return ActionResult.fail((String)"\u4f60\u8fd8\u6ca1\u6709\u8bbe\u7f6e\u90ae\u4ef6\u7684\u5e10\u6237");
    }

    @ApiOperation(value="\u5b58\u8349\u7a3f")
    @PostMapping(value={"/Actions/SaveDraft"})
    public ActionResult saveDraft(@RequestBody @Valid EmailSendCrForm emailSendCrForm) {
        EmailSendEntity entity = (EmailSendEntity)JsonUtil.getJsonToBean((Object)emailSendCrForm, EmailSendEntity.class);
        this.emailReceiveService.saveDraft(entity);
        return ActionResult.success((String)MsgCode.SU002.get());
    }

    @ApiOperation(value="\u53d1\u90ae\u4ef6")
    @PostMapping
    public ActionResult saveSent(@RequestBody @Valid EmailCrForm emailCrForm) {
        EmailSendEntity entity = (EmailSendEntity)JsonUtil.getJsonToBean((Object)emailCrForm, EmailSendEntity.class);
        EmailConfigEntity configEntity = this.emailReceiveService.getConfigInfo();
        if (configEntity != null) {
            MailAccount mailAccount = new MailAccount();
            mailAccount.setAccount(configEntity.getAccount());
            mailAccount.setPassword(configEntity.getPassword());
            mailAccount.setPop3Host(configEntity.getPop3Host());
            mailAccount.setPop3Port(configEntity.getPop3Port().intValue());
            mailAccount.setSmtpHost(configEntity.getSmtpHost());
            mailAccount.setSmtpPort(configEntity.getSmtpPort().intValue());
            if ("1".equals(String.valueOf(configEntity.getEmailSsl()))) {
                mailAccount.setSsl(Boolean.valueOf(true));
            } else {
                mailAccount.setSsl(Boolean.valueOf(false));
            }
            int flag = this.emailReceiveService.saveSent(entity, configEntity);
            if (flag == 0) {
                return ActionResult.success((String)MsgCode.SU012.get());
            }
            return ActionResult.fail((String)"\u8d26\u6237\u8ba4\u8bc1\u9519\u8bef");
        }
        return ActionResult.fail((String)"\u4f60\u8fd8\u6ca1\u6709\u8bbe\u7f6e\u90ae\u4ef6\u7684\u5e10\u6237");
    }

    @ApiOperation(value="\u66f4\u65b0\u90ae\u4ef6\u914d\u7f6e")
    @PutMapping(value={"/Config"})
    public ActionResult saveConfig(@RequestBody @Valid EmailCheckForm emailCheckForm) throws DataException {
        EmailConfigEntity entity = (EmailConfigEntity)JsonUtil.getJsonToBean((Object)emailCheckForm, EmailConfigEntity.class);
        this.emailReceiveService.saveConfig(entity);
        return ActionResult.success((String)MsgCode.SU002.get());
    }

    @ApiOperation(value="\u90ae\u7bb1\u914d\u7f6e-\u6d4b\u8bd5\u8fde\u63a5")
    @PostMapping(value={"/Config/Actions/CheckMail"})
    public ActionResult checkLogin(@RequestBody @Valid EmailCheckForm emailCheckForm) {
        EmailConfigEntity entity = (EmailConfigEntity)JsonUtil.getJsonToBean((Object)emailCheckForm, EmailConfigEntity.class);
        String result = this.sysconfigService.checkLogin(entity);
        if ("true".equals(result)) {
            return ActionResult.success((String)MsgCode.SU017.get());
        }
        return ActionResult.fail((String)result);
    }
}

