/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.extend.entity.WorkLogEntity;
import com.bringspring.extend.model.worklog.WorkLogCrForm;
import com.bringspring.extend.model.worklog.WorkLogInfoVO;
import com.bringspring.extend.model.worklog.WorkLogListVO;
import com.bringspring.extend.model.worklog.WorkLogUpForm;
import com.bringspring.extend.service.WorkLogService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"app\u5de5\u4f5c\u65e5\u5fd7"}, value="WorkLog")
@RestController
@RequestMapping(value={"/api/extend/WorkLog"})
public class WorkLogController {
    @Autowired
    private WorkLogService workLogService;
    @Autowired
    private UserService userService;

    @GetMapping(value={"/Send"})
    public ActionResult getSendList(Pagination pageModel) {
        List<WorkLogEntity> data = this.workLogService.getSendList(pageModel);
        List list = JsonUtil.getJsonToList(data, WorkLogListVO.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pageModel, PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"/Receive"})
    public ActionResult getReceiveList(Pagination pageModel) {
        List<WorkLogEntity> data = this.workLogService.getReceiveList(pageModel);
        List list = JsonUtil.getJsonToList(data, WorkLogListVO.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pageModel, PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id) throws DataException {
        WorkLogEntity entity = this.workLogService.getInfo(id);
        StringJoiner userName = new StringJoiner(",");
        StringJoiner userIds = new StringJoiner(",");
        List<String> userId = Arrays.asList(entity.getToUserId().split(","));
        List userList = this.userService.getUserName(userId);
        for (UserEntity user : userList) {
            userIds.add(user.getId());
            userName.add(user.getRealName() + "/" + user.getAccount());
        }
        entity.setToUserId(userName.toString());
        WorkLogInfoVO vo = (WorkLogInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, WorkLogInfoVO.class);
        vo.setUserIds(userIds.toString());
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid WorkLogCrForm workLogCrForm) {
        WorkLogEntity entity = (WorkLogEntity)JsonUtil.getJsonToBean((Object)workLogCrForm, WorkLogEntity.class);
        this.workLogService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid WorkLogUpForm workLogUpForm) {
        WorkLogEntity entity = (WorkLogEntity)JsonUtil.getJsonToBean((Object)workLogUpForm, WorkLogEntity.class);
        boolean flag = this.workLogService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        WorkLogEntity entity = this.workLogService.getInfo(id);
        if (entity != null) {
            this.workLogService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }
}

