/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.DocumentEntity;
import com.bringspring.extend.entity.DocumentShareEntity;
import com.bringspring.extend.mapper.DocumentMapper;
import com.bringspring.extend.service.DocumentService;
import com.bringspring.extend.service.DocumentShareService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
extends ServiceImpl<DocumentMapper, DocumentEntity>
implements DocumentService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DocumentShareService documentShareService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public List<DocumentEntity> getFolderList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(DocumentEntity::getType, (Object)0)).eq(DocumentEntity::getDeleteMark, (Object)0)).orderByAsc(DocumentEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DocumentEntity> getAllList(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(DocumentEntity::getDeleteMark, (Object)0)).eq(DocumentEntity::getParentId, (Object)parentId)).orderByAsc(DocumentEntity::getType)).orderByAsc(DocumentEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DocumentEntity> getTrashList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(DocumentEntity::getDeleteMark, (Object)1)).orderByAsc(DocumentEntity::getType)).orderByDesc(DocumentEntity::getDeleteTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DocumentEntity> getShareOutList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).eq(DocumentEntity::getDeleteMark, (Object)0)).gt(DocumentEntity::getIsShare, (Object)0)).orderByAsc(DocumentEntity::getType)).orderByDesc(DocumentEntity::getDeleteTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<DocumentEntity> getShareTomeList() {
        return ((DocumentMapper)this.baseMapper).getShareTomeList(this.userProvider.get().getUserId());
    }

    @Override
    public List<DocumentShareEntity> getShareUserList(String documentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)documentId);
        return this.documentShareService.list((Wrapper)queryWrapper);
    }

    @Override
    public DocumentEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentEntity::getId, (Object)id);
        return (DocumentEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(DocumentEntity entity) {
        entity.setDeleteTime(new Date());
        entity.setDeleteUserId(this.userProvider.get().getUserId());
        entity.setDeleteMark(1);
        this.updateById(entity);
    }

    @Override
    public void create(DocumentEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setDeleteMark(0);
        this.save(entity);
    }

    @Override
    public boolean update(String id, DocumentEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public boolean shareCreate(String documentId, String[] shareUserId) {
        ArrayList<DocumentShareEntity> entitys = new ArrayList<DocumentShareEntity>();
        for (String item : shareUserId) {
            DocumentShareEntity entity = new DocumentShareEntity();
            entity.setId(RandomUtil.uuId());
            entity.setDocumentId(documentId);
            entity.setShareUserId(item);
            entity.setShareTime(new Date());
            entitys.add(entity);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        DocumentEntity entity = (DocumentEntity)this.getOne((Wrapper)queryWrapper.lambda().eq(DocumentEntity::getId, (Object)documentId));
        if (entity != null) {
            entity.setIsShare(entitys.size());
            entity.setShareTime(new Date());
            this.updateById(entity);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)documentId);
            this.documentShareService.remove((Wrapper)wrapper);
            for (DocumentShareEntity shareEntity : entitys) {
                this.documentShareService.save(shareEntity);
            }
            return true;
        }
        return false;
    }

    @Override
    @DSTransactional
    public boolean shareCancel(String documentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DocumentEntity::getId, (Object)documentId);
        DocumentEntity entity = (DocumentEntity)this.getOne((Wrapper)queryWrapper);
        if (entity != null) {
            entity.setIsShare(0);
            entity.setShareTime(new Date());
            this.updateById(entity);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.lambda().eq(DocumentShareEntity::getDocumentId, (Object)documentId);
            this.documentShareService.remove((Wrapper)wrapper);
            return true;
        }
        return false;
    }

    @Override
    @DSTransactional
    public void trashDelete(String folderId) {
        DocumentEntity entity = this.getInfo(folderId);
        if (entity != null) {
            this.removeById((Serializable)((Object)folderId));
            FileUtil.deleteFile((String)(this.configValueUtil.getDocumentFilePath() + entity.getFilePath()));
        }
    }

    @Override
    public boolean trashRecovery(String id) {
        return this.retBool(((DocumentMapper)this.baseMapper).trashRecovery(id));
    }

    @Override
    public boolean moveTo(String id, String toId) {
        DocumentEntity entity = this.getInfo(id);
        if (entity != null) {
            entity.setParentId(toId);
            this.updateById(entity);
            return true;
        }
        return false;
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(DocumentEntity::getFullName, (Object)fullName)).eq(DocumentEntity::getDeleteMark, (Object)0)).eq(DocumentEntity::getCreatorUserId, (Object)userId);
        if (!StringUtil.isEmpty((String)id)) {
            queryWrapper.lambda().ne(DocumentEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }
}

