/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.extend.entity.DocumentEntity;
import com.bringspring.extend.entity.DocumentShareEntity;
import com.bringspring.extend.model.document.DocumentCrForm;
import com.bringspring.extend.model.document.DocumentFolderTreeModel;
import com.bringspring.extend.model.document.DocumentFolderTreeVO;
import com.bringspring.extend.model.document.DocumentInfoVO;
import com.bringspring.extend.model.document.DocumentListVO;
import com.bringspring.extend.model.document.DocumentShareForm;
import com.bringspring.extend.model.document.DocumentSoutListVO;
import com.bringspring.extend.model.document.DocumentStomeListVO;
import com.bringspring.extend.model.document.DocumentSuserListVO;
import com.bringspring.extend.model.document.DocumentUpForm;
import com.bringspring.extend.model.document.DocumentUploader;
import com.bringspring.extend.model.document.PageDocument;
import com.bringspring.extend.service.DocumentService;
import com.bringspring.files.model.MergeChunkDto;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.base.util.OptimizeUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u77e5\u8bc6\u7ba1\u7406"}, value="Document")
@RestController
@RequestMapping(value={"/api/extend/Document"})
public class DocumentController {
    @Autowired
    private DocumentService documentService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6/\u6587\u4ef6\u5939\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<DocumentInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        DocumentEntity entity = this.documentService.getInfo(id);
        DocumentInfoVO vo = (DocumentInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, DocumentInfoVO.class);
        String[] fullName = vo.getFullName().split("\\.");
        if (fullName.length > 1) {
            String fullNames = "";
            for (int i = 0; i < fullName.length - 1; ++i) {
                fullNames = i > 0 ? fullNames + "." + fullName[i] : fullNames + fullName[i];
            }
            vo.setFullName(fullNames);
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6dfb\u52a0\u6587\u4ef6\u5939")
    @PostMapping
    public ActionResult create(@RequestBody @Valid DocumentCrForm documentCrForm) {
        DocumentEntity entity = (DocumentEntity)JsonUtil.getJsonToBean((Object)documentCrForm, DocumentEntity.class);
        if (this.documentService.isExistByFullName(documentCrForm.getFullName(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST004.get());
        }
        this.documentService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u6587\u4ef6\u540d/\u6587\u4ef6\u5939\u540d")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DocumentUpForm documentUpForm) {
        boolean flag;
        DocumentEntity entity = (DocumentEntity)JsonUtil.getJsonToBean((Object)documentUpForm, DocumentEntity.class);
        if (this.documentService.isExistByFullName(documentUpForm.getFullName(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST004.get());
        }
        DocumentEntity info = this.documentService.getInfo(id);
        String[] fullName = info.getFullName().split("\\.");
        if (fullName.length > 1) {
            entity.setFullName(entity.getFullName() + "." + fullName[fullName.length - 1]);
        }
        if (!(flag = this.documentService.update(id, entity))) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u77e5\u8bc6\u7ba1\u7406")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        DocumentEntity entity = this.documentService.getInfo(id);
        if (entity != null) {
            List<DocumentEntity> allList = this.documentService.getAllList(entity.getId());
            if (allList.size() > 0) {
                return ActionResult.fail((String)MsgCode.FA016.get());
            }
            this.documentService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u6587\u4ef6\u5939\u6811\uff09")
    @GetMapping(value={"/FolderTree/{id}"})
    public ActionResult<ListVO<DocumentFolderTreeVO>> folderTree(@PathVariable(value="id") String id) {
        List<DocumentEntity> data = this.documentService.getFolderList();
        if (!"0".equals(id)) {
            data.remove(this.documentService.getInfo(id));
        }
        ArrayList<DocumentFolderTreeModel> treeList = new ArrayList<DocumentFolderTreeModel>();
        DocumentFolderTreeModel model = new DocumentFolderTreeModel();
        model.setId("-1");
        model.setFullName("\u5168\u90e8\u6587\u6863");
        model.setParentId("0");
        model.setIcon("0");
        treeList.add(model);
        for (DocumentEntity entity : data) {
            DocumentFolderTreeModel treeModel = new DocumentFolderTreeModel();
            treeModel.setId(entity.getId());
            treeModel.setFullName(entity.getFullName());
            treeModel.setParentId(entity.getParentId());
            treeModel.setIcon("fa fa-folder");
            treeList.add(treeModel);
        }
        List trees = TreeDotUtils.convertListToTreeDotFilter(treeList);
        List listVO = JsonUtil.getJsonToList((Object)trees, DocumentFolderTreeVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u5168\u90e8\u6587\u6863\uff09")
    @GetMapping
    public ActionResult<ListVO<DocumentListVO>> allList(PageDocument page) {
        List<DocumentEntity> data = this.documentService.getAllList(page.getParentId());
        if (!StringUtil.isEmpty((String)page.getKeyword())) {
            data = data.stream().filter(t -> t.getFullName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        List list = JsonUtil.getJsonToList(data, DocumentListVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u77e5\u8bc6\u7ba1\u7406\uff08\u6211\u7684\u5171\u4eab\u5217\u8868\uff09")
    @GetMapping(value={"/Share"})
    public ActionResult<ListVO<DocumentSoutListVO>> shareOutList(Page page) {
        List<DocumentEntity> data = this.documentService.getShareOutList();
        if (!StringUtil.isEmpty((String)page.getKeyword())) {
            data = data.stream().filter(t -> t.getFullName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        ListVO vo = new ListVO();
        vo.setList(data);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u5171\u4eab\u7ed9\u6211\uff09")
    @GetMapping(value={"/ShareTome"})
    public ActionResult<ListVO<DocumentStomeListVO>> shareTomeList(Page page) {
        List<DocumentEntity> list = this.documentService.getShareTomeList();
        if (!StringUtil.isEmpty((String)page.getKeyword())) {
            list = list.stream().filter(t -> t.getFullName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        List userId = list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList());
        List userName = this.userService.getUserName(userId);
        for (DocumentEntity entity : list) {
            UserEntity userEntity = userName.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(userEntity != null ? userEntity.getRealName() + "/" + userEntity.getAccount() : "");
        }
        List vos = JsonUtil.getJsonToList(list, DocumentStomeListVO.class);
        ListVO vo = new ListVO();
        vo.setList(vos);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u56de\u6536\u7ad9\uff09")
    @GetMapping(value={"/Trash"})
    public ActionResult<ListVO<DocumentEntity>> trashList(Page page) {
        List<DocumentEntity> data = this.documentService.getTrashList();
        if (!StringUtil.isEmpty((String)page.getKeyword())) {
            data = data.stream().filter(t -> t.getFullName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        ListVO vo = new ListVO();
        vo.setList(data);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u77e5\u8bc6\u7ba1\u7406\u5217\u8868\uff08\u5171\u4eab\u4eba\u5458\uff09")
    @GetMapping(value={"/ShareUser/{documentId}"})
    public ActionResult<ListVO<DocumentSuserListVO>> shareUserList(@PathVariable(value="documentId") String documentId) {
        List<DocumentShareEntity> data = this.documentService.getShareUserList(documentId);
        List list = JsonUtil.getJsonToList(data, DocumentSuserListVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u77e5\u8bc6\u7ba1\u7406\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult uploader(DocumentUploader documentUploader) {
        String fileName = documentUploader.getFile().getOriginalFilename();
        List<DocumentEntity> data = this.documentService.getAllList(documentUploader.getParentId());
        String finalFileName = fileName;
        if ((data = data.stream().filter(t -> finalFileName.equals(t.getFullName())).collect(Collectors.toList())).size() > 0) {
            fileName = DateUtil.getNow((String)"+8") + "-" + fileName;
        }
        String fileType = UpUtil.getFileType((MultipartFile)documentUploader.getFile());
        String name = RandomUtil.uuId();
        String filePath = this.configValueUtil.getDocumentFilePath();
        if (!OptimizeUtil.fileType((String)this.configValueUtil.getAllowUploadFileType(), (String)fileType)) {
            return ActionResult.fail((String)MsgCode.FA017.get());
        }
        UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)"document", (String)(name + "." + fileType), (MultipartFile)documentUploader.getFile(), (String)filePath);
        DocumentEntity entity = new DocumentEntity();
        entity.setType(1);
        entity.setFullName(fileName);
        entity.setParentId(documentUploader.getParentId());
        entity.setFileExtension(fileType);
        entity.setFilePath(name + "." + fileType);
        entity.setFileSize(String.valueOf(documentUploader.getFile().getSize()));
        entity.setDeleteMark(0);
        this.documentService.create(entity);
        return ActionResult.success((String)MsgCode.SU015.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoDataSourceBind
    @ApiOperation(value="\u5206\u7247\u7ec4\u88c5")
    @PostMapping(value={"/merge"})
    public ActionResult merge(MergeChunkDto mergeChunkDto) {
        String identifier = mergeChunkDto.getIdentifier();
        String path = FilePathUtil.getFilePath((String)"temporary");
        String filePath = XSSEscape.escapePath((String)(path + identifier));
        String partFile = XSSEscape.escapePath((String)(path + mergeChunkDto.getFileName()));
        try {
            List mergeFileList = FileUtil.getFile((File)new File(filePath));
            FileOutputStream destTempfos = new FileOutputStream(partFile, true);
            try {
                for (int i = 0; i < mergeFileList.size(); ++i) {
                    String chunkName = identifier.concat("-") + (i + 1);
                    File files = new File(filePath, chunkName);
                    if (!files.exists()) continue;
                    FileUtils.copyFile((File)files, (OutputStream)destTempfos);
                }
                File partFiles = new File(partFile);
                if (partFiles.exists()) {
                    MultipartFile multipartFile = FileUtil.createFileItem((File)partFiles);
                    this.uploaderVO(multipartFile, mergeChunkDto.getParentId());
                    FileUtil.deleteTmp((MultipartFile)multipartFile);
                }
            }
            finally {
                if (Collections.singletonList(destTempfos).get(0) != null) {
                    destTempfos.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtils.deleteQuietly((File)new File(filePath));
            FileUtils.deleteQuietly((File)new File(partFile));
        }
        return ActionResult.success((String)MsgCode.SU015.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u94fe\u63a5")
    @PostMapping(value={"/Download/{id}"})
    public ActionResult<DownloadVO> download(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        DocumentEntity entity = this.documentService.getInfo(id);
        if (entity != null) {
            String name = entity.getFilePath();
            String fileName = userInfo.getId() + "#" + name + "#document#" + entity.getFullName() + "." + entity.getFileExtension();
            DownloadVO vo = DownloadVO.builder().name(entity.getFullName()).url(UploaderUtil.uploaderFile((String)fileName)).build();
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)MsgCode.FA018.get());
    }

    @ApiOperation(value="\u56de\u6536\u7ad9\uff08\u5f7b\u5e95\u5220\u9664\uff09")
    @DeleteMapping(value={"/Trash/{id}"})
    public ActionResult trashDelete(@PathVariable(value="id") String id) {
        this.documentService.trashDelete(id);
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @ApiOperation(value="\u56de\u6536\u7ad9\uff08\u8fd8\u539f\u6587\u4ef6\uff09")
    @PostMapping(value={"/Trash/{id}/Actions/Recovery"})
    public ActionResult trashRecovery(@PathVariable(value="id") String id) {
        boolean flag = this.documentService.trashRecovery(id);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA010.get());
        }
        return ActionResult.success((String)MsgCode.SU010.get());
    }

    @ApiOperation(value="\u5206\u4eab\u6587\u4ef6/\u6587\u4ef6\u5939")
    @PostMapping(value={"/{id}/Actions/Share"})
    public ActionResult shareCreate(@PathVariable(value="id") String id, @RequestBody DocumentShareForm documentShareForm) {
        String[] shareUserId = documentShareForm.getUserId().split(",");
        boolean flag = this.documentService.shareCreate(id, shareUserId);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u53d6\u6d88\u5206\u4eab\u6587\u4ef6/\u6587\u4ef6\u5939")
    @DeleteMapping(value={"/{id}/Actions/Share"})
    public ActionResult shareCancel(@PathVariable(value="id") String id) {
        boolean flag = this.documentService.shareCancel(id);
        if (!flag) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @ApiOperation(value="\u79fb\u52a8\u6587\u4ef6/\u6587\u4ef6\u5939")
    @PutMapping(value={"/{id}/Actions/MoveTo/{toId}"})
    public ActionResult moveTo(@PathVariable(value="id") String id, @PathVariable(value="toId") String toId) {
        if (id.equals(toId)) {
            return ActionResult.fail((String)"\u4e0d\u80fd\u79fb\u52a8\u5230\u81ea\u5df1\u7684\u6587\u4ef6\u5939");
        }
        boolean flag = this.documentService.moveTo(id, toId);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    private void uploaderVO(MultipartFile file, String parentId) {
        String fileType = UpUtil.getFileType((MultipartFile)file);
        String filePath = this.configValueUtil.getDocumentFilePath();
        String name = RandomUtil.uuId();
        String fileName = file.getOriginalFilename();
        List<DocumentEntity> data = this.documentService.getAllList(parentId);
        String finalFileName = fileName;
        if ((data = data.stream().filter(t -> finalFileName.equals(t.getFullName())).collect(Collectors.toList())).size() > 0) {
            fileName = DateUtil.getNow((String)"+8") + "-" + fileName;
        }
        UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)"document", (String)(name + "." + fileType), (MultipartFile)file, (String)filePath);
        DocumentEntity entity = new DocumentEntity();
        entity.setType(1);
        entity.setFullName(fileName);
        entity.setParentId(parentId);
        entity.setFileExtension(fileType);
        entity.setFilePath(name + "." + fileType);
        entity.setFileSize(String.valueOf(file.getSize()));
        entity.setDeleteMark(0);
        this.documentService.create(entity);
    }
}

