/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.extend.entity.ScheduleEntity;
import com.bringspring.extend.model.schedule.ScheduleCrForm;
import com.bringspring.extend.model.schedule.ScheduleInfoVO;
import com.bringspring.extend.model.schedule.ScheduleListVO;
import com.bringspring.extend.model.schedule.ScheduleTime;
import com.bringspring.extend.model.schedule.ScheduleTimes;
import com.bringspring.extend.model.schedule.ScheduleUpForm;
import com.bringspring.extend.service.ScheduleService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65e5\u7a0b\u5b89\u6392"}, value="Schedule")
@RestController
@RequestMapping(value={"/api/extend/Schedule"})
public class ScheduleController {
    @Autowired
    private ScheduleService scheduleService;

    @ApiOperation(value="\u83b7\u53d6\u65e5\u7a0b\u5b89\u6392\u5217\u8868")
    @GetMapping
    public ActionResult<ListVO<ScheduleListVO>> list(ScheduleTime scheduleTime) {
        List<ScheduleEntity> data = this.scheduleService.getList(scheduleTime.getStartTime(), scheduleTime.getEndTime());
        List list = JsonUtil.getJsonToList(data, ScheduleListVO.class);
        ListVO listVO = new ListVO();
        listVO.setList(list);
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\uff08\u5f85\u5b9a\uff09\u5217\u8868")
    @GetMapping(value={"/AppList"})
    public ActionResult appList(ScheduleTimes scheduleTime) {
        LinkedHashMap<String, Integer> days = new LinkedHashMap<String, Integer>();
        List<ScheduleEntity> scheduleList = this.scheduleService.getList(scheduleTime.getStartTime(), scheduleTime.getEndTime());
        Date start = DateUtil.stringToDates((String)scheduleTime.getStartTime());
        Date end = DateUtil.stringToDates((String)scheduleTime.getEndTime());
        List item = DateUtil.getAllDays((Date)start, (Date)end);
        if (StringUtils.isEmpty((CharSequence)scheduleTime.getDateTime())) {
            scheduleTime.setDateTime(DateUtil.dateNow((String)"yyyyMMdd"));
        } else {
            scheduleTime.setDateTime(scheduleTime.getDateTime().replaceAll("-", ""));
        }
        HashMap dataList = new HashMap(16);
        for (int i = 0; i < item.size(); ++i) {
            String startTime = DateUtil.daFormat((Date)((Date)item.get(i))) + " 00:00";
            String endTime = DateUtil.daFormat((Date)((Date)item.get(i))) + " 23:59";
            List count = scheduleList.stream().filter(m -> DateUtil.dateFormat((Date)m.getStartTime()).compareTo(endTime) <= 0 && DateUtil.dateFormat((Date)m.getEndTime()).compareTo(startTime) >= 0).collect(Collectors.toList());
            String time = DateUtil.daFormat((Date)((Date)item.get(i))).replaceAll("-", "");
            days.put(time, count.size());
            dataList.put(time, count);
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("signList", days);
        List todayList = (List)dataList.get(scheduleTime.getDateTime());
        data.put("todayList", JsonUtil.listToJsonField((List)todayList));
        return ActionResult.success(data);
    }

    @ApiOperation(value="\uff08\u5f85\u5b9a\uff09\u5217\u8868")
    @GetMapping(value={"/AppDayList"})
    public ActionResult list(ScheduleTimes scheduleTimes) {
        List<ScheduleEntity> data = this.scheduleService.getList(scheduleTimes.getStartTime(), scheduleTimes.getEndTime());
        ArrayList<ScheduleEntity> datas = new ArrayList<ScheduleEntity>();
        Date dateTimes = DateUtil.stringToDates((String)scheduleTimes.getDateTime());
        if (!StringUtils.isEmpty((CharSequence)scheduleTimes.getDateTime())) {
            for (ScheduleEntity entity : data) {
                Date endTimes;
                Date startTimes = entity.getStartTime();
                if (!DateUtil.isEffectiveDate((Date)dateTimes, (Date)startTimes, (Date)(endTimes = entity.getEndTime()))) continue;
                datas.add(entity);
            }
        }
        return ActionResult.success((Object)JsonUtil.listToJsonField(datas));
    }

    @ApiOperation(value="\u83b7\u53d6\u65e5\u7a0b\u5b89\u6392\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<ScheduleInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ScheduleEntity entity = this.scheduleService.getInfo(id);
        ScheduleInfoVO vo = (ScheduleInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, ScheduleInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u65e5\u7a0b\u5b89\u6392")
    @PostMapping
    public ActionResult create(@RequestBody @Valid ScheduleCrForm scheduleCrForm) {
        ScheduleEntity entity = (ScheduleEntity)JsonUtil.getJsonToBean((Object)scheduleCrForm, ScheduleEntity.class);
        this.scheduleService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u65e5\u7a0b\u5b89\u6392")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ScheduleUpForm scheduleUpForm) {
        ScheduleEntity entity = (ScheduleEntity)JsonUtil.getJsonToBean((Object)scheduleUpForm, ScheduleEntity.class);
        boolean flag = this.scheduleService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u65e5\u7a0b\u5b89\u6392")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ScheduleEntity entity = this.scheduleService.getInfo(id);
        if (entity != null) {
            this.scheduleService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }
}

