/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.ScheduleEntity;
import com.bringspring.extend.mapper.ScheduleMapper;
import com.bringspring.extend.service.ScheduleService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
extends ServiceImpl<ScheduleMapper, ScheduleEntity>
implements ScheduleService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ScheduleEntity> getList(String startTime, String endTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Date startTimes = DateUtil.stringToDates((String)startTime);
        Date endTimes = DateUtil.stringToDates((String)endTime);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ScheduleEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).ge(ScheduleEntity::getStartTime, (Object)startTimes)).le(ScheduleEntity::getEndTime, (Object)endTimes)).orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ScheduleEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ScheduleEntity::getId, (Object)id);
        return (ScheduleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(ScheduleEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public void create(ScheduleEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String id, ScheduleEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }
}

