/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.extend.entity.TableExampleEntity;
import com.bringspring.extend.model.tableexample.PaginationTableExample;
import com.bringspring.extend.model.tableexample.TableExampleCityListVO;
import com.bringspring.extend.model.tableexample.TableExampleCrForm;
import com.bringspring.extend.model.tableexample.TableExampleIndustryListVO;
import com.bringspring.extend.model.tableexample.TableExampleInfoVO;
import com.bringspring.extend.model.tableexample.TableExampleListAllVO;
import com.bringspring.extend.model.tableexample.TableExampleListVO;
import com.bringspring.extend.model.tableexample.TableExampleRowUpForm;
import com.bringspring.extend.model.tableexample.TableExampleSignUpForm;
import com.bringspring.extend.model.tableexample.TableExampleTreeModel;
import com.bringspring.extend.model.tableexample.TableExampleUpForm;
import com.bringspring.extend.model.tableexample.postil.PostilInfoVO;
import com.bringspring.extend.model.tableexample.postil.PostilModel;
import com.bringspring.extend.model.tableexample.postil.PostilSendForm;
import com.bringspring.extend.service.TableExampleService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8868\u683c\u793a\u4f8b\u6570\u636e"}, value="TableExample")
@RestController
@RequestMapping(value={"/api/extend/TableExample"})
public class TableExampleController {
    @Autowired
    private TableExampleService tableExampleService;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;

    @ApiOperation(value="\u83b7\u53d6\u8868\u683c\u6570\u636e\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<TableExampleListVO>> list(PaginationTableExample paginationTableExample) {
        List<TableExampleEntity> data = this.tableExampleService.getList(paginationTableExample);
        List list = JsonUtil.getJsonToList(data, TableExampleListVO.class);
        List userId = list.stream().map(t -> t.getRegistrant()).collect(Collectors.toList());
        List userList = this.userService.getUserName(userId);
        for (TableExampleListVO tableExampleListVO : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(tableExampleListVO.getRegistrant())).findFirst().orElse(null);
            tableExampleListVO.setRegistrant(user != null ? user.getRealName() + "/" + user.getAccount() : "");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationTableExample), PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\uff08\u6811\u5f62\u8868\u683c\uff09")
    @GetMapping(value={"/ControlSample/{typeId}"})
    public ActionResult list(@PathVariable(value="typeId") String typeId, PaginationTableExample paginationTableExample) {
        List<TableExampleEntity> data = this.tableExampleService.getList(typeId, paginationTableExample);
        List list = JsonUtil.getJsonToList(data, TableExampleListVO.class);
        List userId = list.stream().map(t -> t.getRegistrant()).collect(Collectors.toList());
        List userList = this.userService.getUserName(userId);
        for (TableExampleListVO tableExampleListVO : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(tableExampleListVO.getRegistrant())).findFirst().orElse(null);
            tableExampleListVO.setRegistrant(user != null ? user.getRealName() + "/" + user.getAccount() : "");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationTableExample), PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u683c\u5206\u7ec4\u5217\u8868")
    @GetMapping(value={"/All"})
    public ActionResult listAll() {
        List<TableExampleEntity> data = this.tableExampleService.getList();
        List list = JsonUtil.getJsonToList(data, TableExampleListAllVO.class);
        List userId = list.stream().map(t -> t.getRegistrant()).collect(Collectors.toList());
        List userList = this.userService.getUserName(userId);
        for (TableExampleListAllVO tableExampleListVO : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(tableExampleListVO.getRegistrant())).findFirst().orElse(null);
            tableExampleListVO.setRegistrant(user != null ? user.getRealName() + "/" + user.getAccount() : "");
        }
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5ef6\u4f38\u6269\u5c55\u5217\u8868(\u884c\u653f\u533a\u5212)")
    @GetMapping(value={"/IndustryList"})
    public ActionResult industryList() {
        List data = this.provinceService.getList("-1");
        List listVos = JsonUtil.getJsonToList((Object)data, TableExampleIndustryListVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVos);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u57ce\u5e02\u4fe1\u606f\u5217\u8868(\u83b7\u53d6\u5ef6\u4f38\u6269\u5c55\u5217\u8868(\u884c\u653f\u533a\u5212))")
    @GetMapping(value={"/CityList/{id}"})
    public ActionResult cityList(@PathVariable(value="id") String id) {
        List data = this.provinceService.getList(id);
        List listVos = JsonUtil.getJsonToList((Object)data, TableExampleCityListVO.class);
        ListVO vo = new ListVO();
        vo.setList(listVos);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u8868\u683c\u6811\u5f62")
    @GetMapping(value={"/ControlSample/TreeList"})
    public ActionResult treeList(String isTree) {
        List data = this.dictionaryDataService.getList("d59a3cf65f9847dbb08be449e3feae16");
        ArrayList<TableExampleTreeModel> treeList = new ArrayList<TableExampleTreeModel>();
        for (DictionaryDataEntity entity : data) {
            TableExampleTreeModel treeModel = new TableExampleTreeModel();
            treeModel.setId(entity.getId());
            treeModel.setText(entity.getFullName());
            treeModel.setParentId(entity.getParentId());
            treeModel.setLoaded(true);
            treeModel.setExpanded(true);
            treeModel.setHt(JsonUtil.entityToMap((Object)entity));
            treeList.add(treeModel);
        }
        if (isTree != null && "1".equals(isTree)) {
            List trees = TreeDotUtils.convertListToTreeDot(treeList);
            List listVO = JsonUtil.getJsonToList((Object)trees, TableExampleTreeModel.class);
            ListVO vo = new ListVO();
            vo.setList(listVO);
            return ActionResult.success((Object)vo);
        }
        ListVO vo = new ListVO();
        vo.setList(treeList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u666e\u901a\u8868\u683c\u793a\u4f8b\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<TableExampleInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        TableExampleEntity entity = this.tableExampleService.getInfo(id);
        TableExampleInfoVO vo = (TableExampleInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, TableExampleInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5220\u9664\u9879\u76ee")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        TableExampleEntity entity = this.tableExampleService.getInfo(id);
        if (entity != null) {
            this.tableExampleService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u65b0\u5efa\u9879\u76ee")
    @PostMapping
    public ActionResult create(@RequestBody @Valid TableExampleCrForm tableExampleCrForm) {
        TableExampleEntity entity;
        entity.setCostAmount((entity = (TableExampleEntity)JsonUtil.getJsonToBean((Object)tableExampleCrForm, TableExampleEntity.class)).getCostAmount() == null ? new BigDecimal("0") : entity.getCostAmount());
        entity.setTunesAmount(entity.getTunesAmount() == null ? new BigDecimal("0") : entity.getTunesAmount());
        entity.setProjectedIncome(entity.getProjectedIncome() == null ? new BigDecimal("0") : entity.getProjectedIncome());
        entity.setSign("0000000");
        this.tableExampleService.create(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0\u9879\u76ee")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid TableExampleUpForm tableExampleUpForm) {
        TableExampleEntity entity;
        entity.setCostAmount((entity = (TableExampleEntity)JsonUtil.getJsonToBean((Object)tableExampleUpForm, TableExampleEntity.class)).getCostAmount() == null ? new BigDecimal("0") : entity.getCostAmount());
        entity.setTunesAmount(entity.getTunesAmount() == null ? new BigDecimal("0") : entity.getTunesAmount());
        entity.setProjectedIncome(entity.getProjectedIncome() == null ? new BigDecimal("0") : entity.getProjectedIncome());
        boolean flag = this.tableExampleService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u6807\u8bb0")
    @PutMapping(value={"/UpdateSign/{id}"})
    public ActionResult updateSign(@PathVariable(value="id") String id, @RequestBody @Valid TableExampleSignUpForm tableExampleSignUpForm) {
        TableExampleEntity entity = (TableExampleEntity)JsonUtil.getJsonToBean((Object)tableExampleSignUpForm, TableExampleEntity.class);
        TableExampleEntity tableExampleEntity = this.tableExampleService.getInfo(id);
        if (tableExampleEntity == null) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        tableExampleEntity.setSign(entity.getSign());
        this.tableExampleService.update(id, entity);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u884c\u7f16\u8f91")
    @PutMapping(value={"/{id}/Actions/RowsEdit"})
    public ActionResult rowEditing(@PathVariable(value="id") String id, @RequestBody @Valid TableExampleRowUpForm tableExampleRowUpForm) {
        TableExampleEntity entity;
        entity.setCostAmount((entity = (TableExampleEntity)JsonUtil.getJsonToBean((Object)tableExampleRowUpForm, TableExampleEntity.class)).getCostAmount() == null ? new BigDecimal("0") : entity.getCostAmount());
        entity.setTunesAmount(entity.getTunesAmount() == null ? new BigDecimal("0") : entity.getTunesAmount());
        entity.setProjectedIncome(entity.getProjectedIncome() == null ? new BigDecimal("0") : entity.getProjectedIncome());
        entity.setId(id);
        boolean falg = this.tableExampleService.rowEditing(entity);
        if (!falg) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u53d1\u9001\u6279\u6ce8")
    @PostMapping(value={"/{id}/Postil"})
    public ActionResult sendPostil(@PathVariable(value="id") String id, @RequestBody PostilSendForm postilSendForm) {
        TableExampleEntity tableExampleEntity = this.tableExampleService.getInfo(id);
        if (tableExampleEntity == null) {
            return ActionResult.success((String)MsgCode.FA005.get());
        }
        UserInfo userInfo = this.userProvider.get();
        PostilModel model = new PostilModel();
        model.setCreatorTime(DateUtil.getNow((String)"+8"));
        model.setText(postilSendForm.getText());
        model.setUserId(userInfo != null ? userInfo.getUserName() + "/" + userInfo.getUserAccount() : "");
        ArrayList<PostilModel> list = new ArrayList<PostilModel>();
        list.add(model);
        if (!StringUtil.isEmpty((String)tableExampleEntity.getPostilJson())) {
            list.addAll(JsonUtil.getJsonToList((String)tableExampleEntity.getPostilJson(), PostilModel.class));
        }
        String postilJson = JsonUtil.getObjectToString(list);
        tableExampleEntity.setPostilJson(postilJson);
        tableExampleEntity.setPostilCount(list.size());
        this.tableExampleService.update(id, tableExampleEntity);
        return ActionResult.success((String)MsgCode.SU012.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u6279\u6ce8")
    @GetMapping(value={"/{id}/Actions/Postil"})
    public ActionResult getPostil(@PathVariable(value="id") String id) {
        TableExampleEntity tableExampleEntity = this.tableExampleService.getInfo(id);
        if (tableExampleEntity == null) {
            return ActionResult.success((String)MsgCode.FA012.get());
        }
        PostilInfoVO vo = new PostilInfoVO();
        vo.setPostilJson(tableExampleEntity.getPostilJson());
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5220\u9664\u6279\u6ce8")
    @DeleteMapping(value={"/{id}/Postil/{index}"})
    public ActionResult deletePostil(@PathVariable(value="id") String id, @PathVariable(value="index") int index) {
        TableExampleEntity tableExampleEntity = this.tableExampleService.getInfo(id);
        if (tableExampleEntity == null) {
            return ActionResult.success((String)MsgCode.FA003.get());
        }
        List list = JsonUtil.getJsonToList((String)tableExampleEntity.getPostilJson(), PostilModel.class);
        list.remove(index);
        String postilJson = JsonUtil.getObjectToString((Object)list);
        tableExampleEntity.setPostilJson(postilJson);
        tableExampleEntity.setPostilCount(list.size());
        this.tableExampleService.update(id, tableExampleEntity);
        return ActionResult.success((String)MsgCode.SU003.get());
    }
}

