/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.ScheduleEntity;
import com.bringspring.extend.mapper.ScheduleMapper;
import com.bringspring.extend.service.ScheduleService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
extends ServiceImpl<ScheduleMapper, ScheduleEntity>
implements ScheduleService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private ServiceAllUtil serviceUtil;

    @Override
    public List<ScheduleEntity> getList(String startTime, String endTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Date startTimes = DateUtil.stringToDates((String)startTime);
        Date endTimes = DateUtil.stringToDates((String)endTime);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ScheduleEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).ge(ScheduleEntity::getStartTime, (Object)startTimes)).le(ScheduleEntity::getEndTime, (Object)endTimes)).orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ScheduleEntity> getListByTimeScoped(String startTime, String endTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Date startTimes = DateUtil.stringToDate((String)startTime);
        Date endTimes = DateUtil.stringToDate((String)endTime);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().ge(ScheduleEntity::getStartTime, (Object)startTimes)).le(ScheduleEntity::getEndTime, (Object)endTimes)).orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ScheduleEntity> getListByTimeScopedAndUserId(String startTime, String endTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Date startTimes = DateUtil.stringToDate((String)startTime);
        Date endTimes = DateUtil.stringToDate((String)endTime);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ScheduleEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())).ge(ScheduleEntity::getStartTime, (Object)startTimes)).le(ScheduleEntity::getEndTime, (Object)endTimes)).orderByAsc(ScheduleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ScheduleEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ScheduleEntity::getId, (Object)id);
        return (ScheduleEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(ScheduleEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public void create(ScheduleEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public Boolean judgeScheduleTimeConflict(ScheduleEntity entity) {
        String s = DateUtil.dateFormatToDay((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd");
        List<ScheduleEntity> list = this.getListByTimeScopedAndUserId(s + " 00:00:00", s + " 23:59:59");
        if (!list.isEmpty()) {
            for (ScheduleEntity scheduleEntity : list) {
                boolean b = DateUtil.hasOverlap((Date)scheduleEntity.getStartTime(), (Date)scheduleEntity.getEndTime(), (Date)entity.getStartTime(), (Date)entity.getEndTime());
                if (!b) continue;
                return b;
            }
        }
        return false;
    }

    @Override
    public boolean update(String id, ScheduleEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void sendMessage(List<String> userId, String title, String content, String url) throws Exception {
        List collect = userId.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(Integer.valueOf(50));
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId(this.sysConfigService.getConfigByKeyName("scheduleMessage").getKeyValue());
        sentMessageForm.setTitle("\u7ad9\u5185\u4fe1\u6807\u9898");
        sentMessageForm.setContent("\u7ad9\u5185\u4fe1\u5185\u5bb9");
        sentMessageForm.setBodyText(new HashMap());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", title);
        map.put("content", content);
        map.put("AppUrl", this.sysConfigService.getConfigByKeyName("qyhMobileUrl").getKeyValue() + url);
        sentMessageForm.setParameterMap(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
        this.serviceUtil.sendMessage(messageListAll);
    }

    @Override
    public void scheduledRemindeMorning() throws Exception {
        Map<String, List<ScheduleEntity>> mapByTime = this.getMapByTime();
        if (mapByTime != null || !mapByTime.isEmpty()) {
            for (String key : mapByTime.keySet()) {
                List<ScheduleEntity> scheduleEntities = mapByTime.get(key);
                if (scheduleEntities.isEmpty()) continue;
                ArrayList<String> userids = new ArrayList<String>();
                userids.add(scheduleEntities.get(0).getCreatorUserId());
                String url = "/#";
                String content = "";
                for (int i = 0; i < scheduleEntities.size(); ++i) {
                    content = i != scheduleEntities.size() - 1 ? content + scheduleEntities.get(i).getTitle() + "\n" : content + scheduleEntities.get(i).getTitle();
                }
                this.sendMessage(userids, "\u60a8\u4eca\u65e5\u6709" + scheduleEntities.size() + "\u4e2a\u65e5\u7a0b\uff01", content, url);
            }
        }
    }

    @Override
    public void scheduledRemindeEvery() throws Exception {
        Map<String, List<ScheduleEntity>> mapByTime = this.getMapByTime();
        if (mapByTime != null || !mapByTime.isEmpty()) {
            for (String key : mapByTime.keySet()) {
                List<ScheduleEntity> scheduleEntities = mapByTime.get(key);
                if (scheduleEntities.isEmpty()) continue;
                for (ScheduleEntity scheduleEntity : scheduleEntities) {
                    if (DateUtil.getNowDate().getTime() - scheduleEntity.getStartTime().getTime() > 600000L) continue;
                    ArrayList<String> userids = new ArrayList<String>();
                    userids.add(scheduleEntity.getCreatorUserId());
                    String url = "/#/";
                    this.sendMessage(userids, "\u60a8\u6709\u65e5\u7a0b" + scheduleEntity.getTitle() + "\u5feb\u5f00\u59cb\u4e86", scheduleEntity.getContent(), url);
                }
            }
        }
    }

    public Map<String, List<ScheduleEntity>> getMapByTime() {
        String s = DateUtil.dateFormatToDay((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd");
        List<ScheduleEntity> list = this.getListByTimeScoped(s + " 00:00:00", s + " 23:59:59");
        if (!list.isEmpty()) {
            Map<String, List<ScheduleEntity>> map = list.stream().collect(Collectors.groupingBy(ScheduleEntity::getCreatorUserId));
            return map;
        }
        return null;
    }
}

