package com.bringspring.extend.model.document;

import com.bringspring.extend.entity.DocumentHistoryEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 9:58
 */
@Data
public class DocumentListVO {
    @ApiModelProperty(value = "主键id")
    private String id;
    @ApiModelProperty(value = "文件夹名称")
    private String fullName;
    @ApiModelProperty(value = "文档分类(0-文件夹，1-文件)")
    private Integer type;
    @ApiModelProperty(value = "创建日期")
    private Long creatorTime;
    @ApiModelProperty(value = "是否分享")
    private Integer isShare;
    @ApiModelProperty(value = "大小")
    private String fileSize;
    @ApiModelProperty(value = "父级Id")
    private String parentId;
    @ApiModelProperty(value = "后缀名")
    private String fileExtension;
    @JsonProperty("fileVersion")
    private String fileVersion;
    @JsonProperty("documentHistory")
    private List<DocumentHistoryEntity> documentHistory;

    private String isPublic;

    //摘要
    @ApiModelProperty(value = "摘要")
    private String description;
    //标签
    @ApiModelProperty(value = "文件标签")
    private String fileLable;
    //路径
    @ApiModelProperty(value = "路径")
    private String filePath;
    //公司名称
    @ApiModelProperty(value = "公司名称")
    private String companyName;
    //公司ID
    @ApiModelProperty(value = "公司ID")
    private String companyId;


}
