package com.bringspring.extend.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.extend.entity.DocumentEntity;
import com.bringspring.extend.entity.DocumentShareEntity;
import com.bringspring.extend.model.document.DocumentShareForm;
import com.bringspring.extend.model.document.PageDocument;

import java.io.File;
import java.util.List;

/**
 * 知识文档
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
public interface DocumentService extends IService<DocumentEntity> {

    /**
     * 列表（全部文档）
     *
     * @return
     */
    List<DocumentEntity> getFolderList();

    /**
     * 列表（全部文档）
     *
     * @param parentId 文档父级
     * @return
     */
    List<DocumentEntity> getAllList(String parentId,String isPublic);

    /**
     * 列表（全部文档）
     *
     * @param
     * @return
     */
    List<DocumentEntity> getAllList(PageDocument page);

    /**
     * 列表（回收站）
     */
    List<DocumentEntity> getTrashList();

    /**
     * 列表（我的共享）
     */
    List<DocumentEntity> getShareOutList();

    /**
     * 列表（共享给我）
     */
    List<DocumentEntity> getShareTomeList();


    /**
     * 列表（共享人员）
     *
     * @param documentId 文档主键
     * @return
     */
    List<DocumentShareEntity> getShareUserList(String documentId);

    /**
     * 信息
     *
     * @param id 主键值
     * @return
     */
    DocumentEntity getInfo(String id);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(DocumentEntity entity);

    /**
     * 创建
     *
     * @param entity 实体对象
     */
    void create(DocumentEntity entity);

    /**
     * 更新
     *
     * @param id     主键值
     * @param entity 实体对象
     */
    boolean update(String id, DocumentEntity entity);

    /**
     * 共享文件（创建）
     *
     * @param documentId  文档主键
     * @param
     */
    boolean shareCreate(String documentId, DocumentShareForm documentShareForm);

    /**
     * 共享文件（修改）
     *
     * @param   shareId 共享文件主键
     * @param
     */
    boolean shareUpdate(String shareId, DocumentShareForm documentShareForm);

    /**
     * 根据文件分享id获取
     * @param shareId
     * @return
     */
    DocumentShareForm getShareEntityById(String shareId);

    /**
     * 共享文件（取消）
     *
     * @param documentId 文档主键
     */
    boolean shareCancel(String documentId);

    /**
     * 删除共享文件链接（）
     *
     * @param id 主键值
     * @return
     */
    boolean handleDelShareLink(String id);

    /**
     * 回收站（删除）
     *
     * @param folderId 文件夹主键值
     */
    void trashDelete(String folderId);

    /**
     * 回收站（还原）
     *
     * @param id 主键值
     */
    boolean trashRecovery(String id);

    /**
     * 文件/夹移动到
     *
     * @param id   主键值
     * @param toId 将要移动到Id
     */
    boolean moveTo(String id, String toId);

    /**
     * 验证文件名是否重复
     *
     * @param
     * @param
     */
    boolean isExistByFullName(DocumentEntity entity);


    //获取共享给我的文件列表
    List<DocumentEntity> getListByShareUserId();


    //获取该文件夹下的所有文件
    DownloadVO getAllDocumentByParentId(String parentId);

    //根据文件id获取该文件的绝对路径
    String getAbsoluteRouteById(String id);

    //清空临时下载目录
    void clearDoc();

}
