package com.bringspring.extend.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * 知识文档
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2023-09-22
 */
@Data
@TableName("EXT_DOCUMENT_HISTORY")
public class DocumentHistoryEntity {

    @TableId("ID")
    private String id;

    @TableField("ORIGINAL_FILE_ID")
    private String originalFileId;

    @TableField("PARENT_ID")
    private String parentId;

    @TableField("TYPE")
    private Integer type;

    @TableField("FULL_NAME")
    private String fullName;

    @TableField("FILE_PATH")
    private String filePath;

    @TableField("FILE_SIZE")
    private String fileSize;

    @TableField("FILE_EXTENSION")
    private String fileExtension;

    @TableField("READE_COUNT")
    private Integer readeCount;

    @TableField("IS_SHARE")
    private Integer isShare;

    @TableField("SHARE_TIME")
    private Date shareTime;

    @TableField("FILE_VERSION")
    private String fileVersion;

    @TableField("DESCRIPTION")
    private String description;

    @TableField("SORT_CODE")
    private Long sortCode;

    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    @TableField("DELETE_MARK")
    private Integer deleteMark;

    @TableField("DELETE_TIME")
    private Date deleteTime;

    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}
