package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 知识文档共享
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("ext_document_share")
public class DocumentShareEntity {
    /**
     * 共享主键
     */
    @TableId("ID")
    private String id;

    /**
     * 文档主键
     */
    @TableField("DOCUMENT_ID")
    private String documentId;

    /**
     * 共享人员
     */
    @TableField("SHARE_USER_ID")
    private String shareUserId;

    /**
     * 共享类型
     */
    @TableField("SHARE_TYPE")
    private String shareType;

    /**
     * 对外分享链接
     */
    @TableField("EXPOSE_LINK")
    private String exposeLink;

    /**
     * 短链接
     */
    @TableField("SHORT_LINK")
    private String shortLink;

    /**
     * 共享口令
     */
    @TableField("password")
    private String password;


    /**
     * 共享截止时间
     */
    @TableField("END_TIME")
    private Date endTime;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;
}
