package com.bringspring.extend.model.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 订单信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 8:46
 */
@Data
public class OrderForm {
   @ApiModelProperty(value = "订单日期")
   private Long orderDate;
   @ApiModelProperty(value = "订单编号")
   private String orderCode;
   @ApiModelProperty(value = "应收金额")
   private String receivableMoney;
   @ApiModelProperty(value = "定金比率")
   private String earnestRate;
   @ApiModelProperty(value = "预付定金")
   private String prepayEarnest;
   @ApiModelProperty(value = "客户名称")
   private String customerName;
   @ApiModelProperty(value = "客户Id")
   private String customerId;
   @ApiModelProperty(value = "业务员Id")
   private String salesmanId;
   @ApiModelProperty(value = "业务员")
   private String salesmanName;
   @ApiModelProperty(value = "付款方式")
   private String paymentMode;
   @ApiModelProperty(value = "描述")
   private String description;
   @ApiModelProperty(value = "运输方式")
   private String transportMode;
   @ApiModelProperty(value = "发货日期")
   private Long deliveryDate;
   @ApiModelProperty(value = "发货地址")
   private String deliveryAddress;
   @ApiModelProperty(value = "附件信息")
   private String fileJson;
   @ApiModelProperty(value = "自然主键")
   private String id;
   private List<OrderEntryModel> goodsList;
   private List<OrderReceivableModel> collectionPlanList;
   @ApiModelProperty(value = "候选人")
   private Map<String, List<String>> candidateList;
   /**0.提交 1.保存**/
   private String status;
   /**指定用户**/
   private String freeApproverUserId;
}

