package com.bringspring.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.ProductclassifyEntity;
import com.bringspring.extend.mapper.ProductclassifyMapper;
import com.bringspring.extend.service.ProductclassifyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 *
 * 产品库
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2021-07-10 14:34:04
 */
@Service
public class ProductclassifyServiceImpl extends ServiceImpl<ProductclassifyMapper, ProductclassifyEntity> implements ProductclassifyService {

    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ProductclassifyEntity> getList(){
        QueryWrapper<ProductclassifyEntity> queryWrapper=new QueryWrapper<>();
        return list(queryWrapper);
    }

    @Override
    public ProductclassifyEntity getInfo(String id){
        QueryWrapper<ProductclassifyEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.lambda().eq(ProductclassifyEntity::getId,id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void create(ProductclassifyEntity entity){
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(userProvider.get().getUserId());
        entity.setCreatorTime(new Date());
        this.save(entity);
    }

    @Override
    public boolean update(String id, ProductclassifyEntity entity){
        entity.setId(id);
        entity.setLastModifyUserId(userProvider.get().getUserId());
        entity.setLastModifyTime(new Date());
        return this.updateById(entity);
    }
    @Override
    public void delete(ProductclassifyEntity entity){
        if(entity!=null){
            this.removeById(entity.getId());
        }
    }

}
