/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ai.demo.controller;

import com.bringspring.ai.demo.entity.AiDemoEntity;
import com.bringspring.ai.demo.model.aiDemo.AiDemoCrForm;
import com.bringspring.ai.demo.model.aiDemo.AiDemoInfoVO;
import com.bringspring.ai.demo.model.aiDemo.AiDemoListVO;
import com.bringspring.ai.demo.model.aiDemo.AiDemoPagination;
import com.bringspring.ai.demo.model.aiDemo.AiDemoUpForm;
import com.bringspring.ai.demo.service.AiDemoService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"AI\u6848\u4f8b"}, value="example")
@RequestMapping(value={"/api/example/AiDemo"})
public class AiDemoController {
    private static final Logger log = LoggerFactory.getLogger(AiDemoController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private AiDemoService aiDemoService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="AI\u6848\u4f8b\u5217\u8868")
    public ActionResult list(@RequestBody AiDemoPagination aiDemoPagination) throws IOException {
        List<AiDemoEntity> list = this.aiDemoService.getList(aiDemoPagination);
        for (AiDemoEntity aiDemoEntity : list) {
            aiDemoEntity.setDemoVideo(this.baseDataUtil.getFileNameInJson(aiDemoEntity.getDemoVideo()));
            aiDemoEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(aiDemoEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, AiDemoListVO.class);
        for (AiDemoListVO aiDemoListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)aiDemoPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @ApiOperation(value="AI\u6848\u4f8b\u521b\u5efa")
    @PostMapping
    public ActionResult create(@RequestBody @Valid AiDemoCrForm aiDemoCrForm) throws DataException {
        this.aiDemoService.create(aiDemoCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="AI\u6848\u4f8b\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<AiDemoInfoVO> info(@PathVariable(value="id") String id) {
        AiDemoEntity entity = this.aiDemoService.getInfo(id);
        AiDemoInfoVO vo = (AiDemoInfoVO)JsonUtil.getJsonToBean((Object)entity, AiDemoInfoVO.class);
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="AI\u6848\u4f8b\u8868\u5355\u4fe1\u606f(\u8be6\u60c5\u9875)")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AiDemoInfoVO> detailInfo(@PathVariable(value="id") String id) {
        AiDemoEntity entity = this.aiDemoService.getInfo(id);
        AiDemoInfoVO vo = (AiDemoInfoVO)JsonUtil.getJsonToBean((Object)entity, AiDemoInfoVO.class);
        vo.setDemoVideo(this.baseDataUtil.getFileNameInJson(vo.getDemoVideo()));
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u5f00", "\u5173"));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="AI\u6848\u4f8b\u66f4\u65b0")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AiDemoUpForm aiDemoUpForm) throws DataException {
        this.aiDemoService.update(id, aiDemoUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="AI\u6848\u4f8b\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        AiDemoEntity entity = this.aiDemoService.getInfo(id);
        if (entity != null) {
            this.aiDemoService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

