package com.bringspring.extend.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 订单明细
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("ext_orderentry")
public class OrderEntryEntity {
    /**
     * 订单明细主键
     */
    @TableId("ID")
    private String id;

    /**
     * 订单主键
     */
    @TableField("ORDERID")
    private String orderId;

    /**
     * 商品Id
     */
    @TableField("GOODSID")
    private String goodsId;

    /**
     * 商品编码
     */
    @TableField("GOODSCODE")
    private String goodsCode;

    /**
     * 商品名称
     */
    @TableField("GOODSNAME")
    private String goodsName;

    /**
     * 规格型号
     */
    @TableField("SPECIFICATIONS")
    private String specifications;

    /**
     * 单位
     */
    @TableField("UNIT")
    private String unit;

    /**
     * 数量
     */
    @TableField("QTY")
    private BigDecimal qty;

    /**
     * 单价
     */
    @TableField("PRICE")
    private BigDecimal price;

    /**
     * 金额
     */
    @TableField("AMOUNT")
    private BigDecimal amount;

    /**
     * 折扣%
     */
    @TableField("DISCOUNT")
    private BigDecimal discount;

    /**
     * 税率%
     */
    @TableField("CESS")
    private BigDecimal cess;

    /**
     * 实际单价
     */
    @TableField("ACTUALPRICE")
    private BigDecimal actualPrice;

    /**
     * 实际金额
     */
    @TableField("ACTUALAMOUNT")
    private BigDecimal actualAmount;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;
}
