package com.bringspring.extend.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.extend.entity.ScheduleEntity;
import com.bringspring.extend.model.schedule.SchedulePagination;
import com.bringspring.system.base.entity.MessageTemplateEntity;

import java.util.HashMap;
import java.util.List;

/**
 * 日程安排
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
public interface ScheduleService extends IService<ScheduleEntity> {

    /**
     * 列表
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return
     */
    List<ScheduleEntity> getList(String startTime, String endTime);

    /**
     * 根据时间查询所有人创建的列表
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return
     */
    List<ScheduleEntity> getListByTimeScoped(String startTime, String endTime);

    /**
     * 根据时间查询所有人创建的列表
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return
     */
    List<ScheduleEntity> getListByTimeScopedAndUserId(String startTime, String endTime);

    /**
     * 信息
     *
     * @param id 主键值
     * @return
     */
    ScheduleEntity getInfo(String id);

    /**
     * 删除
     *
     * @param entity 实体对象
     * @return
     */
    void delete(ScheduleEntity entity);

    /**
     * 创建
     *
     * @param entity 实体对象
     */
    void create(ScheduleEntity entity);

    /**
     * 判断日程时间是否重复
     */
    Boolean judgeScheduleTimeConflict(ScheduleEntity entity);

    /**
     * 更新
     *
     * @param id     主键值
     * @param entity 实体对象
     */
    boolean update(String id, ScheduleEntity entity);

    /**
     * 系统提醒
     */
    void sendMessage(List<String> userId, String title, String content,String url) throws Exception;


    /**
     * 智行首页准时工作签系统提醒
     */
    void sendFinishMessage(String taskCode, String sendCode, HashMap<String, String> keys, String linkUrl, String appUrl, String pcUrl, String userId,String termType,String typeDesc) throws Exception;

    /**
     * 每天早上8.30提醒当天日程
     */
    void scheduledRemindeMorning() throws Exception;


    /**
     * 每个日程开始前10分钟提醒
     */
    void scheduledRemindeEvery() throws Exception;

//    智行首页展示工作签列表
    List<ScheduleEntity> getListPagination(SchedulePagination schedulePagination) throws Exception;

    /**
     * 日历，展示标记，日期值
     * @param schedulePagination
     * @return
     */
    List<ScheduleEntity> getDateList(SchedulePagination schedulePagination);

    /**
     * 日程准时提醒
     */
    void scheduledfinishEvery() throws Exception;
}
