/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.DownUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.WordUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.extend.entity.EmployeeEntity;
import com.bringspring.extend.model.EmployeeModel;
import com.bringspring.extend.model.employee.EmployeeCrForm;
import com.bringspring.extend.model.employee.EmployeeExportVO;
import com.bringspring.extend.model.employee.EmployeeImportVO;
import com.bringspring.extend.model.employee.EmployeeInfoVO;
import com.bringspring.extend.model.employee.EmployeeListVO;
import com.bringspring.extend.model.employee.EmployeeUpForm;
import com.bringspring.extend.model.employee.PaginationEmployee;
import com.bringspring.extend.service.EmployeeService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u804c\u5458\u4fe1\u606f"}, description="Employee")
@RestController
@RequestMapping(value={"/api/extend/Employee"})
public class EmployeeController {
    private static final Logger log = LoggerFactory.getLogger(EmployeeController.class);
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;

    @ApiOperation(value="\u83b7\u53d6\u804c\u5458\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<EmployeeListVO>> getList(PaginationEmployee paginationEmployee) {
        List<EmployeeEntity> data = this.employeeService.getList(paginationEmployee);
        List list = JsonUtil.getJsonToList(data, EmployeeListVO.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationEmployee), PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u804c\u5458\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<EmployeeInfoVO> Info(@PathVariable(value="id") String id) throws DataException {
        EmployeeEntity entity = this.employeeService.getInfo(id);
        EmployeeInfoVO vo = (EmployeeInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, EmployeeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="app\u6dfb\u52a0\u804c\u5458\u4fe1\u606f")
    @PostMapping
    public ActionResult create(@RequestBody @Valid EmployeeCrForm employeeCrForm) {
        EmployeeEntity entity = (EmployeeEntity)JsonUtil.getJsonToBean((Object)employeeCrForm, EmployeeEntity.class);
        this.employeeService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="app\u4fee\u6539\u804c\u5458\u4fe1\u606f")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EmployeeUpForm employeeUpForm) {
        EmployeeEntity entity = (EmployeeEntity)JsonUtil.getJsonToBean((Object)employeeUpForm, EmployeeEntity.class);
        this.employeeService.update(id, entity);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u5220\u9664\u804c\u5458\u4fe1\u606f")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        EmployeeEntity entity = this.employeeService.getInfo(id);
        if (entity != null) {
            this.employeeService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/ExportExcel"})
    public ActionResult<DownloadVO> ExportExcel() throws Exception {
        UserInfo userInfo = this.userProvider.get();
        List<EmployeeEntity> entityList = this.employeeService.getList();
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList((String)JsonUtilEx.getObjectToStringDateFormat(entityList, (String)"yyyy-MM-dd"), EmployeeExportVO.class));
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        entitys.add(new ExcelExportEntity("\u5de5\u53f7", (Object)"enCode"));
        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"fullName"));
        entitys.add(new ExcelExportEntity("\u6027\u522b", (Object)"gender"));
        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"departmentName"));
        entitys.add(new ExcelExportEntity("\u5c97\u4f4d", (Object)"positionName", 25));
        entitys.add(new ExcelExportEntity("\u7528\u5de5\u6027\u8d28", (Object)"workingNature"));
        entitys.add(new ExcelExportEntity("\u8eab\u4efd\u8bc1\u53f7", (Object)"idNumber", 25));
        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u7535\u8bdd", (Object)"telephone", 20));
        entitys.add(new ExcelExportEntity("\u51fa\u751f\u5e74\u6708", (Object)"birthday", 20));
        entitys.add(new ExcelExportEntity("\u53c2\u52a0\u5de5\u4f5c", (Object)"attendWorkTime", 20));
        entitys.add(new ExcelExportEntity("\u6700\u9ad8\u5b66\u5386", (Object)"education"));
        entitys.add(new ExcelExportEntity("\u6240\u5b66\u4e13\u4e1a", (Object)"major"));
        entitys.add(new ExcelExportEntity("\u6bd5\u4e1a\u9662\u6821", (Object)"graduationAcademy"));
        entitys.add(new ExcelExportEntity("\u6bd5\u4e1a\u65f6\u95f4", (Object)"graduationTime", 20));
        ExportParams exportParams = new ExportParams(null, "\u804c\u5458\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                }
                String name = "\u804c\u5458\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faWord")
    @GetMapping(value={"/ExportWord"})
    public ActionResult<DownloadVO> ExportWord() {
        UserInfo userInfo = this.userProvider.get();
        List<EmployeeEntity> list = this.employeeService.getList();
        String inputUrl = this.configValueUtil.getTemplateFilePath() + "employee_export_template.docx";
        String name = "\u804c\u5458\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".docx";
        String outputUrl = this.configValueUtil.getTemporaryFilePath() + name;
        ArrayList<String[]> testList = new ArrayList<String[]>();
        HashMap testMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            String[] employee = new String[13];
            EmployeeEntity entity = list.get(i);
            employee[0] = entity.getFullName();
            employee[1] = entity.getGender();
            employee[2] = entity.getDepartmentName();
            employee[3] = entity.getPositionName();
            employee[4] = entity.getWorkingNature();
            employee[5] = entity.getIdNumber();
            employee[6] = entity.getTelephone();
            employee[7] = entity.getBirthday() != null ? DateUtil.daFormat((Date)entity.getBirthday()) : "";
            employee[8] = entity.getAttendWorkTime() != null ? DateUtil.daFormat((Date)entity.getAttendWorkTime()) : "";
            employee[9] = entity.getEducation();
            employee[10] = entity.getMajor();
            employee[11] = entity.getGraduationAcademy();
            employee[12] = entity.getGraduationTime() != null ? DateUtil.daFormat((Date)entity.getGraduationTime()) : "";
            testList.add(employee);
        }
        WordUtil.changWord((String)inputUrl, (String)outputUrl, testMap, testList);
        if (FileUtil.fileIsFile((String)outputUrl)) {
            DownloadVO vo = DownloadVO.builder().name(name).url(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary"))).build();
            return ActionResult.success((Object)vo);
        }
        return ActionResult.success((String)"\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25");
    }

    @ApiOperation(value="\u5bfc\u51fapdf")
    @GetMapping(value={"/ExportPdf"})
    public ActionResult<DownloadVO> ExportPdf() {
        UserInfo userInfo = this.userProvider.get();
        String name = "\u804c\u5458\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".pdf";
        String outputUrl = this.configValueUtil.getTemporaryFilePath() + name;
        this.employeeService.exportPdf(this.employeeService.getList(), outputUrl);
        if (FileUtil.fileIsFile((String)outputUrl)) {
            DownloadVO vo = DownloadVO.builder().name(name).url(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary"))).build();
            return ActionResult.success((Object)vo);
        }
        return ActionResult.success((String)"\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5bfc\u51faExcel(\u5907\u7528)")
    @GetMapping(value={"/Excel"})
    public void Excel() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List<EmployeeEntity> list = this.employeeService.getList();
            TemplateExportParams param = new TemplateExportParams(this.configValueUtil.getTemplateFilePath() + "employee_import_template.xlsx", true, new String[0]);
            map.put("Employee", JSON.parse((String)JSONObject.toJSONStringWithDateFormat(list, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0])));
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)param, map);
            try {
                DownUtil.dowloadExcel((Workbook)workbook, (String)"\u804c\u5458\u4fe1\u606f.xlsx");
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = this.configValueUtil.getTemporaryFilePath();
            String fileName = RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file);
            fileName = XSSEscape.escape((String)fileName);
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List personList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, EmployeeModel.class);
        Map<String, Object> map = this.employeeService.importPreview(personList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult ImportData(@RequestBody EmployeeModel data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), EmployeeModel.class);
        EmployeeImportVO result = this.employeeService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5bfc\u51faExcel\uff08\u53ef\u9009\u5b57\u6bb5\uff09")
    @GetMapping(value={"/ExportExcelData"})
    public ActionResult ExportExcelData(String dataType, String selectKey, PaginationEmployee paginationEmployee) {
        UserInfo userInfo = this.userProvider.get();
        List<Object> entityList = new ArrayList();
        if ("0".equals(dataType)) {
            entityList = this.employeeService.getList(paginationEmployee);
        } else if ("1".equals(dataType)) {
            entityList = this.employeeService.getList();
        }
        ArrayList<EmployeeModel> modeList = new ArrayList<EmployeeModel>();
        for (EmployeeEntity employeeEntity : entityList) {
            EmployeeModel mode = new EmployeeModel();
            mode.setEnCode(employeeEntity.getEnCode());
            mode.setFullName(employeeEntity.getFullName());
            mode.setGender(employeeEntity.getGender());
            mode.setDepartmentName(employeeEntity.getDepartmentName());
            mode.setPositionName(employeeEntity.getPositionName());
            mode.setWorkingNature(employeeEntity.getWorkingNature());
            mode.setIdNumber(employeeEntity.getIdNumber());
            mode.setTelephone(employeeEntity.getTelephone());
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            if (employeeEntity.getBirthday() != null) {
                String birthday = sf.format(employeeEntity.getBirthday());
                mode.setBirthday(birthday);
            }
            if (employeeEntity.getAttendWorkTime() != null) {
                String attendWorkTime = sf.format(employeeEntity.getAttendWorkTime());
                mode.setAttendWorkTime(attendWorkTime);
            }
            mode.setEducation(employeeEntity.getEducation());
            mode.setMajor(employeeEntity.getMajor());
            mode.setGraduationAcademy(employeeEntity.getGraduationAcademy());
            if (employeeEntity.getGraduationTime() != null) {
                String graduationTime = sf.format(employeeEntity.getGraduationTime());
                mode.setGraduationTime(graduationTime);
            }
            SimpleDateFormat sf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            if (employeeEntity.getCreatorTime() != null) {
                String creatorTime = sf1.format(employeeEntity.getCreatorTime());
                mode.setCreatorTime(creatorTime);
            }
            modeList.add(mode);
        }
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(modeList, EmployeeExportVO.class));
        ArrayList<ExcelExportEntity> arrayList = new ArrayList<ExcelExportEntity>();
        String[] splitData = selectKey.split(",");
        if (splitData != null && splitData.length > 0) {
            for (int i = 0; i < splitData.length; ++i) {
                if (splitData[i].equals("enCode")) {
                    arrayList.add(new ExcelExportEntity("\u5de5\u53f7", (Object)"enCode"));
                }
                if (splitData[i].equals("fullName")) {
                    arrayList.add(new ExcelExportEntity("\u59d3\u540d", (Object)"fullName"));
                }
                if (splitData[i].equals("gender")) {
                    arrayList.add(new ExcelExportEntity("\u6027\u522b", (Object)"gender"));
                }
                if (splitData[i].equals("departmentName")) {
                    arrayList.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"departmentName"));
                }
                if (splitData[i].equals("positionName")) {
                    arrayList.add(new ExcelExportEntity("\u5c97\u4f4d", (Object)"positionName", 25));
                }
                if (splitData[i].equals("workingNature")) {
                    arrayList.add(new ExcelExportEntity("\u7528\u5de5\u6027\u8d28", (Object)"workingNature"));
                }
                if (splitData[i].equals("idNumber")) {
                    arrayList.add(new ExcelExportEntity("\u8eab\u4efd\u8bc1\u53f7", (Object)"idNumber", 25));
                }
                if (splitData[i].equals("telephone")) {
                    arrayList.add(new ExcelExportEntity("\u8054\u7cfb\u7535\u8bdd", (Object)"telephone", 20));
                }
                if (splitData[i].equals("birthday")) {
                    arrayList.add(new ExcelExportEntity("\u51fa\u751f\u5e74\u6708", (Object)"birthday", 20));
                }
                if (splitData[i].equals("attendWorkTime")) {
                    arrayList.add(new ExcelExportEntity("\u53c2\u52a0\u5de5\u4f5c", (Object)"attendWorkTime", 20));
                }
                if (splitData[i].equals("education")) {
                    arrayList.add(new ExcelExportEntity("\u6700\u9ad8\u5b66\u5386", (Object)"education"));
                }
                if (splitData[i].equals("major")) {
                    arrayList.add(new ExcelExportEntity("\u6240\u5b66\u4e13\u4e1a", (Object)"major"));
                }
                if (splitData[i].equals("graduationAcademy")) {
                    arrayList.add(new ExcelExportEntity("\u6bd5\u4e1a\u9662\u6821", (Object)"graduationAcademy"));
                }
                if (splitData[i].equals("graduationTime")) {
                    arrayList.add(new ExcelExportEntity("\u6bd5\u4e1a\u65f6\u95f4", (Object)"graduationTime", 20));
                }
                if (!splitData[i].equals("creatorTime")) continue;
                arrayList.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u804c\u5458\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (arrayList.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, arrayList, (Collection)list);
                }
                String name = "\u804c\u5458\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(fileName);
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }
}

