/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.extend.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FileModel;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.extend.entity.OrderEntity;
import com.bringspring.extend.entity.OrderEntryEntity;
import com.bringspring.extend.entity.OrderReceivableEntity;
import com.bringspring.extend.mapper.OrderMapper;
import com.bringspring.extend.model.order.OrderForm;
import com.bringspring.extend.model.order.OrderInfoOrderEntryModel;
import com.bringspring.extend.model.order.OrderInfoOrderReceivableModel;
import com.bringspring.extend.model.order.OrderInfoVO;
import com.bringspring.extend.model.order.PaginationOrder;
import com.bringspring.extend.service.OrderEntryService;
import com.bringspring.extend.service.OrderReceivableService;
import com.bringspring.extend.service.OrderService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.BillRuleService;
import com.bringspring.system.base.util.FileManageUtil;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.enums.FlowHandleEventEnum;
import com.bringspring.workflow.engine.enums.FlowModuleEnum;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.model.FlowHandleModel;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskNewService;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@DSTransactional
public class OrderServiceImpl
extends ServiceImpl<OrderMapper, OrderEntity>
implements OrderService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrderReceivableService orderReceivableService;
    @Autowired
    private OrderEntryService orderEntryService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private FileManageUtil fileManageUtil;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private UserService userService;
    @Autowired
    private FlowTaskNewService flowTaskNewService;
    private static String PREV = "prev";
    private static String NEXT = "next";

    @Override
    public List<OrderEntity> getList(PaginationOrder paginationOrder) {
        String mark;
        String endTime;
        String keyWord;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        String string = keyWord = paginationOrder.getKeyword() != null ? paginationOrder.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) {
            String word = keyWord;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(OrderEntity::getOrderCode, (Object)word)).or()).like(OrderEntity::getCustomerName, (Object)word)).or()).like(OrderEntity::getSalesmanName, (Object)word);
            });
        }
        String startTime = paginationOrder.getStartTime() != null ? paginationOrder.getStartTime() : null;
        String string2 = endTime = paginationOrder.getEndTime() != null ? paginationOrder.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(OrderEntity::getOrderDate, (Object)startTimes)).le(OrderEntity::getOrderDate, (Object)endTimes);
        }
        String string3 = mark = paginationOrder.getEnabledMark() != null ? paginationOrder.getEnabledMark() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mark)) {
            queryWrapper.lambda().eq(OrderEntity::getEnabledMark, (Object)mark);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)paginationOrder.getSidx())) {
            queryWrapper.lambda().orderByDesc(OrderEntity::getCreatorTime);
        } else {
            QueryWrapper queryWrapper2 = queryWrapper = "asc".equals(paginationOrder.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)paginationOrder.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)paginationOrder.getSidx());
        }
        if (!userInfo.getIsAdministrator().booleanValue()) {
            QueryWrapper obj = queryWrapper;
            queryWrapper = (QueryWrapper)this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, "F4FCA43A-B563-4149-AB16-486589CFC154", "ext_order"));
        }
        Page page = new Page(paginationOrder.getCurrentPage(), paginationOrder.getPageSize());
        IPage orderEntityPage = this.page((IPage)page, (Wrapper)queryWrapper);
        List data = orderEntityPage.getRecords();
        List id = data.stream().map(t -> t.getId()).collect(Collectors.toList());
        if (data.size() > 0) {
            List orderStaList = this.flowTaskService.getOrderStaList(id);
            for (OrderEntity entity : data) {
                FlowTaskEntity taskEntity = orderStaList.stream().filter(t -> t.getId().equals(entity.getId())).findFirst().orElse(null);
                if (taskEntity == null) continue;
                entity.setCurrentState(taskEntity.getStatus());
            }
        }
        return paginationOrder.setData(data, page.getTotal());
    }

    @Override
    public List<OrderEntryEntity> getOrderEntryList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OrderEntryEntity::getOrderId, (Object)id)).orderByDesc(OrderEntryEntity::getSortCode);
        return this.orderEntryService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OrderReceivableEntity> getOrderReceivableList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OrderReceivableEntity::getOrderId, (Object)id)).orderByDesc(OrderReceivableEntity::getSortCode);
        return this.orderReceivableService.list((Wrapper)queryWrapper);
    }

    @Override
    public OrderEntity getPrevOrNextInfo(String id, String method) {
        List data;
        QueryWrapper result = new QueryWrapper();
        OrderEntity orderEntity = this.getInfo(id);
        String orderBy = "desc";
        if (PREV.equals(method)) {
            result.lambda().gt(OrderEntity::getCreatorTime, (Object)orderEntity.getCreatorTime());
            orderBy = "";
        } else if (NEXT.equals(method)) {
            result.lambda().lt(OrderEntity::getCreatorTime, (Object)orderEntity.getCreatorTime());
        }
        result.lambda().notIn(OrderEntity::getId, new Object[]{orderEntity.getId()});
        if (StringUtils.isNotEmpty((String)orderBy)) {
            result.lambda().orderByDesc(OrderEntity::getCreatorTime);
        }
        if ((data = this.list((Wrapper)result)).size() > 0) {
            return (OrderEntity)data.get(0);
        }
        return null;
    }

    @Override
    public OrderInfoVO getInfoVo(String id, String method) throws DataException {
        OrderInfoVO infoModel = null;
        OrderEntity orderEntity = this.getPrevOrNextInfo(id, method);
        if (orderEntity != null) {
            List<OrderEntryEntity> orderEntryList = this.getOrderEntryList(orderEntity.getId());
            List<OrderReceivableEntity> orderReceivableList = this.getOrderReceivableList(orderEntity.getId());
            infoModel = (OrderInfoVO)JsonUtilEx.getJsonToBeanEx((Object)orderEntity, OrderInfoVO.class);
            UserEntity createUser = null;
            if (StringUtils.isNotEmpty((String)infoModel.getCreatorUserId())) {
                createUser = this.userService.getInfo(infoModel.getCreatorUserId());
            }
            infoModel.setCreatorUserId(createUser != null ? createUser.getRealName() : "");
            UserEntity lastUser = null;
            if (StringUtils.isNotEmpty((String)infoModel.getLastModifyUserId())) {
                lastUser = this.userService.getInfo(infoModel.getLastModifyUserId());
            }
            infoModel.setLastModifyUserId(lastUser != null ? lastUser.getRealName() : "");
            List orderEntryModels = JsonUtil.getJsonToList(orderEntryList, OrderInfoOrderEntryModel.class);
            infoModel.setGoodsList(orderEntryModels);
            List orderReceivableModels = JsonUtil.getJsonToList(orderReceivableList, OrderInfoOrderReceivableModel.class);
            infoModel.setCollectionPlanList(orderReceivableModels);
        }
        return infoModel;
    }

    @Override
    public OrderEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrderEntity::getId, (Object)id);
        return (OrderEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(OrderEntity entity) {
        QueryWrapper orderWrapper = new QueryWrapper();
        orderWrapper.lambda().eq(OrderEntity::getId, (Object)entity.getId());
        this.remove((Wrapper)orderWrapper);
        QueryWrapper entryWrapper = new QueryWrapper();
        entryWrapper.lambda().eq(OrderEntryEntity::getOrderId, (Object)entity.getId());
        this.orderEntryService.remove((Wrapper)entryWrapper);
        QueryWrapper receivableWrapper = new QueryWrapper();
        receivableWrapper.lambda().eq(OrderReceivableEntity::getOrderId, (Object)entity.getId());
        this.orderReceivableService.remove((Wrapper)receivableWrapper);
        this.fileManageUtil.deleteFile(JsonUtil.getJsonToList((String)entity.getFileJson(), FileModel.class));
    }

    @Override
    public void create(OrderEntity entity, List<OrderEntryEntity> orderEntryList, List<OrderReceivableEntity> orderReceivableList, OrderForm orderForm) throws WorkFlowException {
        try {
            int i;
            entity.setId(RandomUtil.uuId());
            entity.setCreatorUserId(this.userProvider.get().getUserId());
            entity.setEnabledMark(1);
            for (i = 0; i < orderEntryList.size(); ++i) {
                orderEntryList.get(i).setId(RandomUtil.uuId());
                orderEntryList.get(i).setOrderId(entity.getId());
                orderEntryList.get(i).setSortCode(Long.parseLong(i + ""));
                this.orderEntryService.save(orderEntryList.get(i));
            }
            for (i = 0; i < orderReceivableList.size(); ++i) {
                orderReceivableList.get(i).setId(RandomUtil.uuId());
                orderReceivableList.get(i).setOrderId(entity.getId());
                orderReceivableList.get(i).setSortCode(Long.parseLong(i + ""));
                this.orderReceivableService.save(orderReceivableList.get(i));
            }
            this.billRuleService.useBillNumber("OrderNumber");
            if (FlowTaskStatusEnum.Handle.getCode().equals(orderForm.getStatus())) {
                String flowModuleMark = FlowModuleEnum.CRM_Order.getMessage();
                FlowEngineEntity flowEngineEntity = this.flowEngineService.getInfoByEnCode(flowModuleMark);
                entity.setCurrentState(FlowTaskStatusEnum.Handle.getCode());
                entity.setLastModifyTime(new Date());
                entity.setLastModifyUserId(this.userProvider.get().getUserId());
                this.flowSubmit(flowEngineEntity, orderForm.getFreeApproverUserId(), entity, orderForm.getCandidateList());
            }
            this.fileManageUtil.createFile(JsonUtil.getJsonToList((String)entity.getFileJson(), FileModel.class));
            this.save(entity);
        }
        catch (WorkFlowException e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            throw new WorkFlowException(e.getMessage());
        }
    }

    @Override
    public boolean update(String id, OrderEntity entity, List<OrderEntryEntity> orderEntryList, List<OrderReceivableEntity> orderReceivableList, OrderForm orderForm) throws WorkFlowException {
        int i;
        OrderEntity deEntity = this.getInfo(id);
        List list1 = JsonUtil.getJsonToList((String)deEntity.getFileJson(), FileModel.class);
        for (FileModel model : list1) {
            model.setFileType("delete");
        }
        this.fileManageUtil.updateFile(list1);
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        QueryWrapper entryWrapper = new QueryWrapper();
        entryWrapper.lambda().eq(OrderEntryEntity::getOrderId, (Object)entity.getId());
        this.orderEntryService.remove((Wrapper)entryWrapper);
        QueryWrapper receivableWrapper = new QueryWrapper();
        receivableWrapper.lambda().eq(OrderReceivableEntity::getOrderId, (Object)entity.getId());
        this.orderReceivableService.remove((Wrapper)receivableWrapper);
        for (i = 0; i < orderEntryList.size(); ++i) {
            orderEntryList.get(i).setId(RandomUtil.uuId());
            orderEntryList.get(i).setOrderId(entity.getId());
            orderEntryList.get(i).setSortCode(Long.parseLong(i + ""));
            this.orderEntryService.save(orderEntryList.get(i));
        }
        for (i = 0; i < orderReceivableList.size(); ++i) {
            orderReceivableList.get(i).setId(RandomUtil.uuId());
            orderReceivableList.get(i).setOrderId(entity.getId());
            orderReceivableList.get(i).setSortCode(Long.parseLong(i + ""));
            this.orderReceivableService.save(orderReceivableList.get(i));
        }
        List list2 = JsonUtil.getJsonToList((String)entity.getFileJson(), FileModel.class);
        for (FileModel model : list2) {
            model.setFileType("add");
        }
        this.fileManageUtil.updateFile(list2);
        if (FlowTaskStatusEnum.Handle.getCode().equals(orderForm.getStatus())) {
            String flowModuleMark = FlowModuleEnum.CRM_Order.getMessage();
            FlowEngineEntity flowEngineEntity = this.flowEngineService.getInfoByEnCode(flowModuleMark);
            entity.setCurrentState(FlowTaskStatusEnum.Handle.getCode());
            entity.setLastModifyTime(new Date());
            entity.setLastModifyUserId(this.userProvider.get().getUserId());
            this.flowSubmit(flowEngineEntity, orderForm.getFreeApproverUserId(), entity, orderForm.getCandidateList());
        }
        boolean flag = this.updateById(entity);
        return flag;
    }

    @Override
    public void flowSubmit(FlowEngineEntity flowEngineEntity, String freeApproverUserId, OrderEntity orderEntity, Map<String, List<String>> candidateList) throws WorkFlowException {
        UserInfo userInfo = this.userProvider.get();
        FlowTaskEntity flowTaskEntity = this.flowTaskService.getInfoSubmit(orderEntity.getId(), new SFunction[]{FlowTaskEntity::getId});
        String id = null;
        if (flowTaskEntity != null) {
            id = flowTaskEntity.getId();
        }
        FlowUtil.submit((String)id, (String)flowEngineEntity.getId(), null, (String)orderEntity.getId(), (String)(userInfo.getRealName() + "\u7684\u8ba2\u5355\u793a\u4f8b"), (int)1, (String)orderEntity.getOrderCode(), (Object)orderEntity, (String)freeApproverUserId, candidateList);
    }

    @Override
    public void flowRevoke(FlowTaskEntity flowTaskEntity, FlowHandleModel flowHandleModel) throws WorkFlowException {
        OrderEntity orderEntity = this.getInfo(flowTaskEntity.getProcessId());
        orderEntity.setCurrentState(FlowTaskStatusEnum.Revoke.getCode());
        orderEntity.setLastModifyTime(new Date());
        this.updateById(orderEntity);
        List flowTaskNodeEntityList = this.flowTaskNodeService.getList(flowTaskEntity.getId());
        Optional<FlowTaskNodeEntity> first = flowTaskNodeEntityList.stream().filter(m -> "2".equals(String.valueOf(m.getSortCode()))).findFirst();
        if (!first.isPresent()) {
            throw new WorkFlowException(MsgCode.COD001.get());
        }
        FlowTaskNodeEntity flowTaskNodeEntity = first.get();
        if (flowTaskNodeEntity.getCompletion() > 0) {
            throw new WorkFlowException(MsgCode.WF104.get());
        }
        FlowModel flowModel = (FlowModel)JsonUtil.getJsonToBean((Object)flowHandleModel, FlowModel.class);
        this.flowTaskNewService.revoke(flowTaskEntity, flowModel);
    }

    @Override
    public void flowHandleEvent(FlowHandleEventEnum flowHandleEvent, FlowTaskEntity flowTaskEntity) {
        OrderEntity orderEntity = this.getInfo(flowTaskEntity.getProcessId());
        if (orderEntity != null) {
            orderEntity.setCurrentState(flowTaskEntity.getStatus());
            this.updateById(orderEntity);
        }
    }

    @Override
    public void data(String id, String data) {
        int i;
        OrderForm orderForm = (OrderForm)JsonUtil.getJsonToBean((String)data, OrderForm.class);
        OrderEntity entity = (OrderEntity)JsonUtil.getJsonToBean((Object)orderForm, OrderEntity.class);
        ArrayList goodsList = orderForm.getGoodsList() != null ? orderForm.getGoodsList() : new ArrayList();
        List orderEntryList = JsonUtil.getJsonToList(goodsList, OrderEntryEntity.class);
        ArrayList collectionPlanList = orderForm.getCollectionPlanList() != null ? orderForm.getCollectionPlanList() : new ArrayList();
        List orderReceivableList = JsonUtil.getJsonToList(collectionPlanList, OrderReceivableEntity.class);
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        QueryWrapper entryWrapper = new QueryWrapper();
        entryWrapper.lambda().eq(OrderEntryEntity::getOrderId, (Object)entity.getId());
        this.orderEntryService.remove((Wrapper)entryWrapper);
        QueryWrapper receivableWrapper = new QueryWrapper();
        receivableWrapper.lambda().eq(OrderReceivableEntity::getOrderId, (Object)entity.getId());
        this.orderReceivableService.remove((Wrapper)receivableWrapper);
        for (i = 0; i < orderEntryList.size(); ++i) {
            ((OrderEntryEntity)orderEntryList.get(i)).setId(RandomUtil.uuId());
            ((OrderEntryEntity)orderEntryList.get(i)).setOrderId(entity.getId());
            ((OrderEntryEntity)orderEntryList.get(i)).setSortCode(Long.parseLong(i + ""));
            this.orderEntryService.save(orderEntryList.get(i));
        }
        for (i = 0; i < orderReceivableList.size(); ++i) {
            ((OrderReceivableEntity)orderReceivableList.get(i)).setId(RandomUtil.uuId());
            ((OrderReceivableEntity)orderReceivableList.get(i)).setOrderId(entity.getId());
            ((OrderReceivableEntity)orderReceivableList.get(i)).setSortCode(Long.parseLong(i + ""));
            this.orderReceivableService.save(orderReceivableList.get(i));
        }
        this.saveOrUpdate(entity);
    }
}

