package com.bringspring.extend.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.extend.entity.DocumentHistoryEntity;
import com.bringspring.extend.mapper.DocumentHistoryMapper;
import com.bringspring.extend.model.documenthistory.DocumentHistoryPagination;
import com.bringspring.extend.service.DocumentHistoryService;
import com.bringspring.system.permission.service.AuthorizeService;

import java.lang.reflect.Field;

import com.baomidou.mybatisplus.annotation.TableField;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.util.*;

import java.util.*;

/**
 * 知识文档
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2023-09-22
 */
@Service
public class DocumentHistoryServiceImpl extends ServiceImpl<DocumentHistoryMapper, DocumentHistoryEntity> implements DocumentHistoryService {


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private AuthorizeService authorizeService;


    @Override
    public List<DocumentHistoryEntity> getList(DocumentHistoryPagination documentHistoryPagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int extDocumentHistoryNum = 0;
        QueryWrapper<DocumentHistoryEntity> extDocumentHistoryQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(documentHistoryPagination.getType())) {
            extDocumentHistoryNum++;
            extDocumentHistoryQueryWrapper.lambda().like(DocumentHistoryEntity::getType, documentHistoryPagination.getType());
        }

        if (StringUtils.isNotEmpty(documentHistoryPagination.getFullName())) {
            extDocumentHistoryNum++;
            extDocumentHistoryQueryWrapper.lambda().like(DocumentHistoryEntity::getFullName, documentHistoryPagination.getFullName());
        }

        if (AllIdList.size() > 0) {
            extDocumentHistoryQueryWrapper.lambda().in(DocumentHistoryEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(documentHistoryPagination.getSidx())) {
            extDocumentHistoryQueryWrapper.lambda().orderByDesc(DocumentHistoryEntity::getId);
        } else {
            try {
                String sidx = documentHistoryPagination.getSidx();
                DocumentHistoryEntity documentHistoryEntity = new DocumentHistoryEntity();
                Field declaredField = documentHistoryEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                extDocumentHistoryQueryWrapper = "asc".equals(documentHistoryPagination.getSort().toLowerCase()) ? extDocumentHistoryQueryWrapper.orderByAsc(value) : extDocumentHistoryQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<DocumentHistoryEntity> page = new Page<>(documentHistoryPagination.getCurrentPage(), documentHistoryPagination.getPageSize());
            IPage<DocumentHistoryEntity> userIPage = this.page(page, extDocumentHistoryQueryWrapper);
            return documentHistoryPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<DocumentHistoryEntity> list = new ArrayList();
            return documentHistoryPagination.setData(list, list.size());
        }
    }

    @Override
    public List<DocumentHistoryEntity> getTypeList(DocumentHistoryPagination documentHistoryPagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int extDocumentHistoryNum = 0;
        QueryWrapper<DocumentHistoryEntity> extDocumentHistoryQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(documentHistoryPagination.getType())) {
            extDocumentHistoryNum++;
            extDocumentHistoryQueryWrapper.lambda().like(DocumentHistoryEntity::getType, documentHistoryPagination.getType());
        }

        if (StringUtils.isNotEmpty(documentHistoryPagination.getFullName())) {
            extDocumentHistoryNum++;
            extDocumentHistoryQueryWrapper.lambda().like(DocumentHistoryEntity::getFullName, documentHistoryPagination.getFullName());
        }

        if (AllIdList.size() > 0) {
            extDocumentHistoryQueryWrapper.lambda().in(DocumentHistoryEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(documentHistoryPagination.getSidx())) {
            extDocumentHistoryQueryWrapper.lambda().orderByDesc(DocumentHistoryEntity::getId);
        } else {
            try {
                String sidx = documentHistoryPagination.getSidx();
                DocumentHistoryEntity documentHistoryEntity = new DocumentHistoryEntity();
                Field declaredField = documentHistoryEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                extDocumentHistoryQueryWrapper = "asc".equals(documentHistoryPagination.getSort().toLowerCase()) ? extDocumentHistoryQueryWrapper.orderByAsc(value) : extDocumentHistoryQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<DocumentHistoryEntity> page = new Page<>(documentHistoryPagination.getCurrentPage(), documentHistoryPagination.getPageSize());
                IPage<DocumentHistoryEntity> userIPage = this.page(page, extDocumentHistoryQueryWrapper);
                return documentHistoryPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<DocumentHistoryEntity> list = new ArrayList();
                return documentHistoryPagination.setData(list, list.size());
            }
        } else {
            return this.list(extDocumentHistoryQueryWrapper);
        }
    }

    @Override
    public DocumentHistoryEntity getInfo(String id) {
        QueryWrapper<DocumentHistoryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(DocumentHistoryEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void create(DocumentHistoryEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, DocumentHistoryEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<DocumentHistoryEntity> getListByOriginalFileId(String originalFileId) {
        QueryWrapper<DocumentHistoryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(DocumentHistoryEntity::getOriginalFileId, originalFileId);
        return this.list(queryWrapper);
    }

    @Override
    public void delete(DocumentHistoryEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }
    //子表方法

    //列表子表数据方法


}